/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextIteratorProvider;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextProvider2;
import net.sourceforge.plantuml.eclipse.utils.PlantumlUtil;
import net.sourceforge.plantuml.text.AbstractDiagramTextProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextEditorDiagramTextProvider
extends AbstractDiagramTextProvider
implements DiagramTextProvider2,
DiagramTextIteratorProvider {
    private final boolean startIsRegexp = true;
    private final boolean endIsRegexp = true;
    private final boolean includeStart = true;
    private final boolean includeEnd = true;
    private static final String newline = "\n";
    private final Collection<String> supportedExtensions = new ArrayList<String>(Arrays.asList("txt", "text", "puml", "plantuml"));

    public TextEditorDiagramTextProvider() {
        this.setEditorType(ITextEditor.class);
    }

    public boolean supportsSelection(ISelection selection) {
        return selection instanceof ITextSelection;
    }

    @Override
    protected String getDiagramText(IEditorPart editorPart, IEditorInput editorInput, ISelection selection, Map<String, Object> markerAttributes) {
        StringBuilder lines = this.getDiagramTextLines(editorPart, editorInput, selection, markerAttributes);
        return lines != null ? this.getDiagramText(lines) : null;
    }

    protected String getEntPlantUml() {
        return "@enduml";
    }

    protected String getStartPlantUml() {
        return "@startuml";
    }

    protected StringBuilder getDiagramTextLines(IEditorPart editorPart, IEditorInput editorInput, ISelection selection, Map<String, Object> markerAttributes) {
        ITextEditor textEditor = (ITextEditor)editorPart;
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)editorInput);
        int selectionStart = ((ITextSelection)(selection != null ? selection : textEditor.getSelectionProvider().getSelection())).getOffset();
        FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(document);
        try {
            String startPlantUml = this.getStartPlantUml();
            String entPlantUml = this.getEntPlantUml();
            IRegion start = finder.find(selectionStart, startPlantUml, true, true, false, true);
            IRegion end = finder.find(selectionStart, entPlantUml, true, true, false, true);
            if (start == null || end != null && end.getOffset() < start.getOffset()) {
                start = finder.find(Math.min(selectionStart + startPlantUml.length(), document.getLength()), startPlantUml, false, true, false, true);
            }
            if (start != null) {
                int startOffset = start.getOffset();
                int startLine = document.getLineOfOffset(startOffset);
                end = finder.find(startOffset, entPlantUml, true, true, false, true);
                if (end != null) {
                    int endOffset = end.getOffset() + end.getLength();
                    StringBuilder result = new StringBuilder();
                    int maxLine = Math.min(document.getLineOfOffset(endOffset) + 1, document.getNumberOfLines());
                    int lineNum = startLine + 0;
                    while (lineNum < maxLine) {
                        String line = document.get(document.getLineOffset(lineNum), document.getLineLength(lineNum)).trim();
                        result.append(line);
                        if (!line.endsWith(newline)) {
                            result.append(newline);
                        }
                        ++lineNum;
                    }
                    markerAttributes.put("charStart", start.getOffset());
                    return result;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public String getDiagramText(CharSequence lines) {
        return this.getDiagramText(new StringBuilder(lines.toString()));
    }

    protected String getDiagramText(StringBuilder lines) {
        String startPlantUml = this.getStartPlantUml();
        String entPlantUml = this.getEntPlantUml();
        int start = Math.max(lines.indexOf(startPlantUml), 0);
        int end = Math.min(lines.lastIndexOf(entPlantUml) + entPlantUml.length(), lines.length());
        String linePrefix = lines.substring(0, start).trim();
        StringBuilder result = new StringBuilder(lines.length());
        while (start < end) {
            String line;
            int lineEnd = lines.indexOf(newline, start);
            if (lineEnd > end) break;
            if (lineEnd < 0) {
                lineEnd = lines.length();
            }
            if ((line = lines.substring(start, lineEnd).trim()).startsWith(linePrefix)) {
                line = line.substring(linePrefix.length()).trim();
            }
            result.append(line);
            result.append(newline);
            start = lineEnd + 1;
        }
        return result.toString().trim();
    }

    public boolean supportsPath(IPath path) {
        return this.supportedExtensions.contains(path.getFileExtension());
    }

    public String getDiagramText(IPath path) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (file != null && file.exists()) {
            IMarker marker = PlantumlUtil.getPlantUmlMarker((IFile)file, (boolean)false);
            int startOffset = marker.getAttribute("charStart", 0);
            StringBuilder builder = null;
            try {
                Scanner scanner = new Scanner(file.getContents());
                while (scanner.hasNextLine()) {
                    String nextLine = scanner.nextLine();
                    if (builder == null) {
                        if (startOffset <= nextLine.length()) {
                            if (nextLine.indexOf(this.getStartPlantUml(), startOffset) >= 0) {
                                builder = new StringBuilder();
                            }
                            startOffset = 0;
                        } else {
                            startOffset = startOffset - nextLine.length() - 1;
                        }
                    }
                    if (builder == null) continue;
                    builder.append(nextLine);
                    builder.append(newline);
                    if (nextLine.contains(this.getEntPlantUml())) break;
                }
                scanner.close();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (builder != null) {
                return this.getDiagramText(builder);
            }
        }
        return null;
    }

    public Iterator<ISelection> getDiagramText(IEditorPart editorPart) {
        ITextEditor textEditor = (ITextEditor)editorPart;
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)editorPart.getEditorInput());
        FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(document);
        int selectionStart = 0;
        ArrayList<1> selections = new ArrayList<1>();
        try {
            while (true) {
                IRegion start = finder.find(selectionStart, this.getStartPlantUml(), true, true, false, true);
                IRegion end = finder.find(selectionStart, this.getEntPlantUml(), true, true, false, true);
                if (start != null && end != null) {
                    int diagramStart = start.getOffset() + start.getLength() + 1;
                    int diagramLine = document.getLineOfOffset(diagramStart);
                    final String line = document.get(document.getLineOffset(diagramLine), document.getLineLength(diagramLine)).trim();
                    TextSelection selection = new TextSelection(start.getOffset() + start.getLength(), 0){

                        public String toString() {
                            return line;
                        }
                    };
                    selections.add(selection);
                    selectionStart = end.getOffset() + end.getLength() + 1;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return selections.iterator();
    }
}

