/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.views;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.sourceforge.plantuml.eclipse.Activator;
import net.sourceforge.plantuml.eclipse.imagecontrol.ILinkSupport;
import net.sourceforge.plantuml.eclipse.imagecontrol.ImageControl;
import net.sourceforge.plantuml.eclipse.imagecontrol.jface.MenuSupport;
import net.sourceforge.plantuml.eclipse.imagecontrol.jface.actions.ZoomAction;
import net.sourceforge.plantuml.eclipse.imagecontrol.jface.actions.ZoomFitAction;
import net.sourceforge.plantuml.eclipse.imagecontrol.jface.actions.ZoomResetAction;
import net.sourceforge.plantuml.eclipse.utils.Diagram;
import net.sourceforge.plantuml.eclipse.utils.ILinkOpener;
import net.sourceforge.plantuml.eclipse.utils.LinkData;
import net.sourceforge.plantuml.eclipse.utils.PlantumlUtil;
import net.sourceforge.plantuml.eclipse.views.AbstractDiagramSourceView;
import net.sourceforge.plantuml.eclipse.views.DiagramImageControl;
import net.sourceforge.plantuml.eclipse.views.actions.CopyAction;
import net.sourceforge.plantuml.eclipse.views.actions.CopyAsciiAction;
import net.sourceforge.plantuml.eclipse.views.actions.CopySourceAction;
import net.sourceforge.plantuml.eclipse.views.actions.ExportAction;
import net.sourceforge.plantuml.eclipse.views.actions.PrintAction;
import net.sourceforge.plantuml.eclipse.views.actions.SaveAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class PlantUmlView
extends AbstractDiagramSourceView
implements ILinkSupport {
    private Composite composite;
    private DiagramImageControl[] imageControls;
    private TabFolder tabFolder = null;
    private MenuSupport menuSupport;
    private final Listener mouseWheelListener = new Listener(){

        public void handleEvent(Event e) {
            if ((e.stateMask & 0x40000) != 0) {
                if (e.count > 0) {
                    PlantUmlView.this.zoomInAction.run();
                } else {
                    PlantUmlView.this.zoomOutAction.run();
                }
            }
        }
    };
    private final KeyAdapter keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            switch (e.character) {
                case '+': {
                    PlantUmlView.this.zoomInAction.run();
                    break;
                }
                case '-': {
                    PlantUmlView.this.zoomOutAction.run();
                    break;
                }
            }
        }
    };
    private IAction zoomInAction;
    private IAction zoomOutAction;
    private IAction fitCanvasAction;
    private IAction showOriginalAction;
    private final float ZOOMIN_RATE = 1.1f;
    private final float ZOOMOUT_RATE = 0.9f;
    private Diagram diagram;
    private DiagramData lastDiagramData = null;
    private Collection<ILinkOpener> linkOpeners = null;

    @Override
    public void createPartControl(Composite parent) {
        this.menuSupport = new MenuSupport();
        this.composite = parent;
        this.createImageControls(0);
        this.diagram = new Diagram();
        this.addListeners();
        super.createPartControl(parent);
    }

    private DiagramImageControl createImageControl(Composite parent) {
        DiagramImageControl imageControl = new DiagramImageControl(parent);
        imageControl.addLinkSupport(this);
        this.menuSupport.addImageControl((Control)imageControl);
        imageControl.addListener(37, this.mouseWheelListener);
        imageControl.addKeyListener((KeyListener)this.keyListener);
        return imageControl;
    }

    private void createImageControls(int count) {
        if (this.imageControls != null && this.imageControls.length == count) {
            return;
        }
        if (this.tabFolder != null && count <= 1) {
            this.tabFolder.dispose();
            this.tabFolder = null;
        } else if (this.imageControls != null) {
            int retained = count > 1 && this.tabFolder == null ? 0 : count;
            int i = this.imageControls.length - 1;
            while (i >= retained) {
                if (this.tabFolder != null) {
                    this.tabFolder.getItem(i).dispose();
                }
                this.imageControls[i].dispose();
                --i;
            }
        } else {
            this.imageControls = new DiagramImageControl[count];
        }
        if (this.imageControls.length != count) {
            DiagramImageControl[] newImageControls = new DiagramImageControl[count];
            System.arraycopy(this.imageControls, 0, newImageControls, 0, Math.min(this.imageControls.length, newImageControls.length));
            this.imageControls = newImageControls;
        }
        if (count > 1 && this.tabFolder == null) {
            this.tabFolder = new TabFolder(this.composite, 1024);
        }
        int i = 0;
        while (i < this.imageControls.length) {
            if (this.imageControls[i] == null || this.imageControls[i].isDisposed()) {
                this.imageControls[i] = this.createImageControl((Composite)(this.tabFolder != null ? this.tabFolder : this.composite));
                if (this.tabFolder != null) {
                    TabItem tab = new TabItem(this.tabFolder, 0);
                    tab.setText(String.valueOf(i + 1));
                    tab.setControl((Control)this.imageControls[i]);
                }
            }
            ++i;
        }
    }

    private void addListeners() {
        this.addCanvasActions();
    }

    private void addCanvasActions() {
        Display display = this.composite.getDisplay();
        this.menuSupport.addMenuAction((Action)new CopyAction(null){

            public ImageControl getControl() {
                return PlantUmlView.this.getCurrentImageControl();
            }
        });
        this.menuSupport.addMenuAction((Action)new CopySourceAction(display, this.diagram));
        this.menuSupport.addMenuAction((Action)new CopyAsciiAction(display, this.diagram));
        this.menuSupport.addMenuAction((Action)new SaveAction(null, this.diagram){

            public ImageControl getControl() {
                return PlantUmlView.this.getCurrentImageControl();
            }
        });
        this.menuSupport.addMenuAction((Action)new ExportAction(null, this.diagram){

            public ImageControl getControl() {
                return PlantUmlView.this.getCurrentImageControl();
            }
        });
        this.menuSupport.addMenuAction((Action)new PrintAction(null){

            public ImageControl getControl() {
                return PlantUmlView.this.getCurrentImageControl();
            }
        });
    }

    protected DiagramImageControl getCurrentImageControl() {
        int imageNum = 0;
        if (this.tabFolder != null) {
            imageNum = this.tabFolder.getSelectionIndex();
        }
        return this.imageControls.length > imageNum ? this.imageControls[imageNum] : null;
    }

    @Override
    protected void makeActions() {
        super.makeActions();
        this.zoomInAction = new ZoomAction(null, 1.1f){

            public ImageControl getControl() {
                return PlantUmlView.this.getCurrentImageControl();
            }
        };
        this.zoomInAction.setToolTipText("Zoom in");
        this.zoomOutAction = new ZoomAction(null, 0.9f){

            public ImageControl getControl() {
                return PlantUmlView.this.getCurrentImageControl();
            }
        };
        this.zoomOutAction.setToolTipText("Zoom out");
        this.fitCanvasAction = new ZoomFitAction(null){

            public ImageControl getControl() {
                return PlantUmlView.this.getCurrentImageControl();
            }
        };
        this.fitCanvasAction.setToolTipText("Fit to canvas");
        this.showOriginalAction = new ZoomResetAction(null){

            public ImageControl getControl() {
                return PlantUmlView.this.getCurrentImageControl();
            }
        };
        this.showOriginalAction.setToolTipText("Show original");
    }

    @Override
    protected void contributeToActionBars() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.addZoomActions((IContributionManager)toolBarManager);
        this.addViewActions((IContributionManager)toolBarManager);
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        MenuManager editorSelectionActionMenu = new MenuManager("Diagrams");
        editorSelectionActionMenu.add((IAction)new Action(){});
        editorSelectionActionMenu.setRemoveAllWhenShown(true);
        editorSelectionActionMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                for (ActionContributionItem actionContributionItem : PlantUmlView.this.getEditorSelectionActions(menu)) {
                    menu.add((IContributionItem)actionContributionItem);
                }
            }
        });
        menu.add((IContributionItem)editorSelectionActionMenu);
    }

    protected void addZoomActions(IContributionManager toolBarManager) {
        this.addActions(toolBarManager, this.zoomInAction, this.zoomOutAction, this.fitCanvasAction, this.showOriginalAction);
    }

    public void setFocus() {
        DiagramImageControl imageControl = this.getCurrentImageControl();
        (imageControl != null ? imageControl : this.composite).setFocus();
    }

    @Override
    public String getDiagramText() {
        return this.diagram != null ? this.diagram.getTextDiagram() : null;
    }

    @Override
    protected void updateDiagramText(String textDiagram, IPath original, Map<String, Object> markerAttributes) {
        if (!(textDiagram == null || this.lastDiagramData != null && textDiagram.equals(this.lastDiagramData.diagramText))) {
            this.lastDiagramData = new DiagramData();
            this.lastDiagramData.diagramText = textDiagram;
            this.lastDiagramData.original = original;
            this.lastDiagramData.markerAttributes = markerAttributes;
            if (this.isVisible()) {
                this.updateDiagram(this.lastDiagramData);
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.lastDiagramData != null) {
            this.updateDiagram(this.lastDiagramData);
        }
    }

    private void updateDiagram(final DiagramData diagramData) {
        this.diagram.setTextDiagram(diagramData.diagramText);
        this.createImageControls(this.diagram.getImageCount());
        Job job = new Job("Generate diagram"){

            protected IStatus run(IProgressMonitor monitor) {
                IFile file;
                int i = 0;
                while (i < PlantUmlView.this.imageControls.length) {
                    if (PlantUmlView.this.imageControls.length > i && PlantUmlView.this.imageControls[i] != null && !PlantUmlView.this.imageControls[i].isDisposed()) {
                        PlantUmlView.this.imageControls[i].updateDiagramImage(diagramData.original, PlantUmlView.this.diagram, i);
                    }
                    ++i;
                }
                if (!PlantUmlView.this.composite.isDisposed()) {
                    PlantUmlView.this.composite.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!PlantUmlView.this.composite.isDisposed()) {
                                PlantUmlView.this.composite.layout();
                            }
                        }
                    });
                }
                if (diagramData.original != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(diagramData.original)) != null && file.exists()) {
                    PlantumlUtil.updateMarker(file, diagramData.diagramText, null, true, diagramData.markerAttributes);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private Collection<ILinkOpener> getLinkOpeners() {
        if (this.linkOpeners == null) {
            this.linkOpeners = Arrays.asList(Activator.getDefault().getLinkOpeners());
        }
        return this.linkOpeners;
    }

    public Object getLink(int x, int y) {
        DiagramImageControl imageControl = this.getCurrentImageControl();
        if (imageControl != null) {
            for (LinkData linkData : imageControl.getLinks()) {
                if (linkData.rect == null || !linkData.rect.contains(x, y)) continue;
                return linkData.title != null ? linkData.title : linkData.href;
            }
        }
        return null;
    }

    public void openLink(Object href) {
        DiagramImageControl imageControl = this.getCurrentImageControl();
        if (imageControl != null) {
            for (LinkData linkData : this.getCurrentImageControl().getLinks()) {
                ILinkOpener linkOpener;
                if (linkData.title != href && linkData.href != href || (linkOpener = this.findBestLinkOpener(linkData, 0)) == null) continue;
                linkOpener.openLink(linkData);
                return;
            }
        }
    }

    private ILinkOpener findBestLinkOpener(LinkData link, int minSupport) {
        int bestSupport = -1;
        ILinkOpener best = null;
        for (ILinkOpener linkOpener : this.getLinkOpeners()) {
            int support = -1;
            try {
                support = linkOpener.supportsLink(link);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (support < bestSupport) continue;
            bestSupport = support;
            best = linkOpener;
        }
        return bestSupport >= minSupport ? best : null;
    }

    private static class DiagramData {
        String diagramText;
        IPath original;
        Map<String, Object> markerAttributes;

        private DiagramData() {
        }
    }
}

