/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.views;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.eclipse.Activator;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextProvider;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextProvider2;
import net.sourceforge.plantuml.eclipse.utils.PlantumlConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractDiagramSourceView
extends ViewPart {
    private String pinnedToId = null;
    private IEditorPart pinnedTo = null;
    private String initialDiagramSource = null;
    private IAction toggleAction;
    private IAction pinToAction;
    private IAction spawnAction;
    private final IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            this.updateDiagramText(part);
        }

        protected void updateDiagramText(IWorkbenchPart part) {
            if (AbstractDiagramSourceView.this.isLinkingActive()) {
                AbstractDiagramSourceView.this.updateDiagramText(false, part, null);
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }
    };
    private final DiagramTextChangedListener diagramTextChangedListener = new DiagramTextChangedListener();
    private IEditorPart currentEditor;

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString("pinnedTo", this.pinnedTo != null ? this.getEditorInputId(this.pinnedTo.getEditorInput()) : null);
        memento.putString("initialDiagramSource", this.getDiagramText());
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.pinnedToId = memento.getString("pinnedTo");
            this.initialDiagramSource = memento.getString("initialDiagramSource");
        }
    }

    public boolean isLinkedToActiveEditor() {
        return true;
    }

    public boolean isLinkingActive() {
        return this.isLinkedToActiveEditor() && this.toggleAction == null || this.toggleAction.isChecked();
    }

    public void createPartControl(Composite parent) {
        if (this.isLinkedToActiveEditor()) {
            this.registerListeners();
            parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AbstractDiagramSourceView.this.pinnedTo != null || AbstractDiagramSourceView.this.initialDiagramSource == null) {
                        AbstractDiagramSourceView.this.updateDiagramText(true, (IWorkbenchPart)AbstractDiagramSourceView.this.pinnedTo, null);
                    } else if (AbstractDiagramSourceView.this.initialDiagramSource != null) {
                        AbstractDiagramSourceView.this.updateDiagramText(AbstractDiagramSourceView.this.initialDiagramSource, null, null);
                    }
                }
            });
        }
        this.makeActions();
        this.contributeToActionBars();
    }

    protected void contributeToActionBars() {
    }

    protected void makeActions() {
        this.pinToAction = new Action(){

            public boolean isEnabled() {
                return AbstractDiagramSourceView.this.isLinkedToActiveEditor();
            }

            public void run() {
                AbstractDiagramSourceView.this.pinnedTo = this.isChecked() ? AbstractDiagramSourceView.this.currentEditor : null;
                if (AbstractDiagramSourceView.this.pinnedTo != null) {
                    this.setToolTipText("Pinned to " + AbstractDiagramSourceView.this.getEditorInputId(AbstractDiagramSourceView.this.pinnedTo.getEditorInput()));
                } else {
                    AbstractDiagramSourceView.this.updateDiagramText(true, null, null);
                    this.setToolTipText("Pin view to editor");
                }
            }
        };
        this.pinToAction.setToolTipText("Pin view to editor");
        this.pinToAction.setImageDescriptor(ImageDescriptor.createFromFile(PlantumlConstants.class, (String)"/icons/pin.png"));
        this.pinToAction.setChecked(this.pinnedTo != null || this.pinnedToId != null);
        this.spawnAction = new Action(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                String id = AbstractDiagramSourceView.this.getViewSite().getId();
                try {
                    page.showView(id, String.valueOf(id) + "-" + System.currentTimeMillis(), 1);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        };
        this.spawnAction.setToolTipText("Open another view");
        this.spawnAction.setImageDescriptor(ImageDescriptor.createFromFile(PlantumlConstants.class, (String)"/icons/spawn.png"));
        this.toggleAction = new Action(){

            public void run() {
                if (this.isChecked()) {
                    AbstractDiagramSourceView.this.updateDiagramText(true, null, null);
                }
            }
        };
        this.toggleAction.setToolTipText("Link with editor");
        this.toggleAction.setImageDescriptor(ImageDescriptor.createFromFile(PlantumlConstants.class, (String)"/icons/link.gif"));
        this.toggleAction.setChecked(true);
    }

    protected void addActions(IContributionManager manager, IAction ... actions) {
        if (!manager.isEmpty()) {
            manager.add((IContributionItem)new Separator());
        }
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            manager.add(action);
            ++n2;
        }
    }

    protected void addViewActions(IContributionManager toolBarManager) {
        this.addActions(toolBarManager, this.spawnAction, this.pinToAction, this.toggleAction);
    }

    protected String getEditorInputId(IEditorInput editorInput) {
        if (editorInput instanceof IStorageEditorInput) {
            IPath path = null;
            try {
                path = ((IStorageEditorInput)editorInput).getStorage().getFullPath();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (path != null) {
                return path.toString();
            }
        }
        if (editorInput instanceof IPathEditorInput) {
            return ((IPathEditorInput)editorInput).getPath().toString();
        }
        if (editorInput instanceof IURIEditorInput) {
            return ((IURIEditorInput)editorInput).getURI().toString();
        }
        return editorInput.getName();
    }

    protected boolean acceptEditor(IEditorPart editor) {
        if (this.pinnedTo == null && this.pinnedToId == null) {
            return true;
        }
        if (this.pinnedTo != null && this.pinnedTo == editor) {
            return true;
        }
        if (this.pinnedToId != null && this.acceptEditorInput(this.pinnedToId, editor.getEditorInput())) {
            this.pinnedTo = editor;
            this.pinnedToId = null;
            return true;
        }
        return false;
    }

    protected boolean acceptEditorInput(String inputId, IEditorInput editorInput) {
        return this.pinnedToId.equals(this.getEditorInputId(editorInput));
    }

    protected void registerListeners() {
        this.getSite().getPage().addPartListener(this.partListener);
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this.diagramTextChangedListener);
    }

    public void dispose() {
        if (this.currentEditor != null) {
            this.currentEditor.removePropertyListener((IPropertyListener)this.diagramTextChangedListener);
        }
        this.getSite().getPage().removePartListener(this.partListener);
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this.diagramTextChangedListener);
    }

    protected abstract void updateDiagramText(String var1, IPath var2, Map<String, Object> var3);

    public abstract String getDiagramText();

    private void handleEditorChange(IEditorPart editor) {
        if (this.currentEditor != null) {
            this.currentEditor.removePropertyListener((IPropertyListener)this.diagramTextChangedListener);
        }
        this.currentEditor = editor;
        if (this.currentEditor != null) {
            this.currentEditor.addPropertyListener((IPropertyListener)this.diagramTextChangedListener);
        }
    }

    protected void updateDiagramText(boolean force, IWorkbenchPart part, ISelection selection) {
        IEditorPart activeEditor;
        Object object = part instanceof IEditorPart ? (IEditorPart)part : (activeEditor = this.isLinkedToActiveEditor() ? this.getSite().getPage().getActiveEditor() : null);
        if ((force || activeEditor != this.currentEditor) && (activeEditor == null || this.acceptEditor(activeEditor))) {
            IPath path = null;
            this.handleEditorChange(activeEditor);
            if (activeEditor != null) {
                ISelectionProvider selectionProvider;
                if (activeEditor.getEditorInput() instanceof IFileEditorInput) {
                    path = ((IFileEditorInput)activeEditor.getEditorInput()).getFile().getFullPath();
                }
                if (selection == null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
                    selection = selectionProvider.getSelection();
                }
                if (this.updateDiagramText(activeEditor, selection, path)) {
                    return;
                }
                if (selection != null && this.updateDiagramText(activeEditor, null, path)) {
                    return;
                }
            }
            this.updateDiagramText((String)null, (IPath)null, (Map<String, Object>)null);
        }
    }

    private boolean updateDiagramText(IEditorPart activeEditor, ISelection selection, IPath path) {
        if (activeEditor != null) {
            DiagramTextProvider[] diagramTextProviders = Activator.getDefault().getDiagramTextProviders();
            HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
            int i = 0;
            while (i < diagramTextProviders.length) {
                DiagramTextProvider diagramTextProvider = diagramTextProviders[i];
                if (diagramTextProvider.supportsEditor(activeEditor) && (selection == null || diagramTextProvider.supportsSelection(selection))) {
                    String diagramText = null;
                    if (diagramTextProvider instanceof DiagramTextProvider2) {
                        markerAttributes.clear();
                        diagramText = ((DiagramTextProvider2)diagramTextProvider).getDiagramText(activeEditor, selection, markerAttributes);
                    } else {
                        diagramText = diagramTextProvider.getDiagramText(activeEditor, selection);
                    }
                    if (diagramText != null) {
                        this.updateDiagramText(diagramText, path, markerAttributes);
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private class DiagramTextChangedListener
    implements IPropertyListener,
    ISelectionListener {
        private DiagramTextChangedListener() {
        }

        public void propertyChanged(Object source, int propId) {
            if (source == AbstractDiagramSourceView.this.currentEditor && propId == 257 && !AbstractDiagramSourceView.this.currentEditor.isDirty()) {
                this.diagramChanged(AbstractDiagramSourceView.this.currentEditor, null);
            }
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part == AbstractDiagramSourceView.this.currentEditor) {
                this.diagramChanged(AbstractDiagramSourceView.this.currentEditor, selection);
            }
        }

        protected void diagramChanged(IEditorPart editor, ISelection selection) {
            if (AbstractDiagramSourceView.this.isLinkingActive()) {
                AbstractDiagramSourceView.this.updateDiagramText(true, (IWorkbenchPart)editor, selection);
            }
        }
    }
}

