/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextProvider;
import net.sourceforge.plantuml.eclipse.utils.ILinkOpener;
import net.sourceforge.plantuml.eclipse.utils.PlantumlUtil;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "net.sourceforge.plantuml.eclipse";
    private static Activator plugin;
    private IResourceChangeListener resourceListener;
    private List<DiagramTextProvider> diagramTextProviders;
    public int DEFAULT_PRIORITY = 0;
    public int NORMAL_PRIORITY = 5;
    public int CUSTOM_PRIORITY = 10;
    private List<ILinkOpener> linkOpeners;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.resourceListener = PlantumlUtil.createResourceListener();
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 16);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public DiagramTextProvider[] getDiagramTextProviders() {
        if (this.diagramTextProviders == null) {
            this.diagramTextProviders = new ArrayList<DiagramTextProvider>();
            this.processDiagramTextProviders();
        }
        return this.diagramTextProviders.toArray(new DiagramTextProvider[this.diagramTextProviders.size()]);
    }

    private void processDiagramTextProviders() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(this.getBundle().getSymbolicName()) + ".diagramTextProvider");
        IExtension[] extensions = ep.getExtensions();
        final HashMap<DiagramTextProvider, Integer> diagramTextProviders = new HashMap<DiagramTextProvider, Integer>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] iConfigurationElementArray = extensions[i].getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ces = iConfigurationElementArray[n2];
                String name = ces.getName();
                if ("diagramTextProvider".equals(name)) {
                    try {
                        DiagramTextProvider diagramTextProvider = (DiagramTextProvider)ces.createExecutableExtension("providerClass");
                        String priorityValue = ces.getAttribute("priority");
                        int priority = this.NORMAL_PRIORITY;
                        if ("custom".equals(priorityValue)) {
                            priority = this.CUSTOM_PRIORITY;
                        } else if ("normal".equals(priorityValue)) {
                            priority = this.NORMAL_PRIORITY;
                        } else if ("default".equals(priorityValue)) {
                            priority = this.DEFAULT_PRIORITY;
                        } else {
                            try {
                                priority = Integer.valueOf(priorityValue);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        diagramTextProviders.put(diagramTextProvider, priority);
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            ++i;
        }
        this.diagramTextProviders.addAll(diagramTextProviders.keySet());
        Collections.sort(this.diagramTextProviders, new Comparator<DiagramTextProvider>(){

            @Override
            public int compare(DiagramTextProvider dtp2, DiagramTextProvider dtp1) {
                return (Integer)diagramTextProviders.get(dtp1) - (Integer)diagramTextProviders.get(dtp2);
            }
        });
    }

    public ILinkOpener[] getLinkOpeners() {
        if (this.linkOpeners == null) {
            this.linkOpeners = new ArrayList<ILinkOpener>();
            this.processLinkOpeners();
        }
        return this.linkOpeners.toArray(new ILinkOpener[this.linkOpeners.size()]);
    }

    private void processLinkOpeners() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(this.getBundle().getSymbolicName()) + ".linkOpener");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] iConfigurationElementArray = extensions[i].getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ces = iConfigurationElementArray[n2];
                String name = ces.getName();
                if ("linkOpener".equals(name)) {
                    try {
                        ILinkOpener linkOpener = (ILinkOpener)ces.createExecutableExtension("linkOpenerClass");
                        this.linkOpeners.add(linkOpener);
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            ++i;
        }
    }
}

