/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.lib;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.ranfa.lib.LimitedLog;
import com.ranfa.lib.Song;
import com.ranfa.lib.SongJSONProperty;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class Scraping {
    private static final String URI = "https://imascg-slstage-wiki.gamerch.com/%E6%A5%BD%E6%9B%B2%E8%A9%B3%E7%B4%B0%E4%B8%80%E8%A6%A7";
    private static final String DBPATH = "database.json";
    public static final String NONSELECTED = "\u6307\u5b9a\u306a\u3057";
    public static final String ALL = "\u5168\u30bf\u30a4\u30d7";
    public static final String CUTE = "\u30ad\u30e5\u30fc\u30c8";
    public static final String COOL = "\u30af\u30fc\u30eb";
    public static final String PASSION = "\u30d1\u30c3\u30b7\u30e7\u30f3";
    public static final String DEBUT = "DEBUT";
    public static final String REGULAR = "REGULAR";
    public static final String PRO = "PRO";
    public static final String MASTER = "MASTER";
    public static final String MASTERPLUS = "MASTER+";
    public static final String LEGACYMASTERPLUS = "\u24c1MASTER+";
    public static final String LIGHT = "LIGHT";
    public static final String TRICK = "TRICK";
    public static final String PIANO = "PIANO";
    public static final String FORTE = "FORTE";
    public static final String WITCH = "WITCH";

    public static boolean databaseExists() {
        Path path = Paths.get(DBPATH, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    public static String getDBPath() {
        return DBPATH;
    }

    public static ArrayList<Song> getWholeData() {
        long time = System.currentTimeMillis();
        ArrayList<Song> res = new ArrayList<Song>();
        try {
            Document document = Jsoup.connect((String)URI).userAgent("Java/DeresteRandomSelector  More information is available at https://github.com/hizumiaoba/DeresteRandomSelector/").maxBodySize(0).timeout(0).get();
            Elements rows = ((Element)document.getElementsByTag("tbody").get(0)).select("tr");
            int i = 0;
            while (i < rows.size()) {
                String attribute = ((Element)((Element)rows.get(i)).select("td").get(0)).text();
                String name = ((Element)((Element)rows.get(i)).select("td").get(1)).text();
                String difficulty = ((Element)((Element)rows.get(i)).select("td").get(2)).text();
                int level = Integer.parseInt(((Element)((Element)rows.get(i)).select("td").get(3)).text());
                int notes = 0;
                if (((Element)((Element)rows.get(i)).select("td").get(5)).text().indexOf(",") == -1) {
                    notes = Integer.parseInt(((Element)((Element)rows.get(i)).select("td").get(5)).text());
                } else {
                    String temp = ((Element)((Element)rows.get(i)).select("td").get(5)).text();
                    String first = temp.substring(0, temp.indexOf(","));
                    String end = temp.substring(temp.indexOf(",") + 1);
                    notes = Integer.parseInt(String.valueOf(first) + end);
                }
                Song tmp = new Song();
                tmp.setAttribute(attribute);
                tmp.setName(name);
                tmp.setDifficulty(difficulty);
                tmp.setLevel(level);
                tmp.setNotes(notes);
                res.add(tmp);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LimitedLog.println(Scraping.class + ":[INFO]: scraping compeleted in " + (System.currentTimeMillis() - time) + "ms");
        return res;
    }

    public static ArrayList<Song> getSpecificAttributeSongs(ArrayList<Song> data, String attribute) {
        if (!(attribute.equals(ALL) || attribute.equals(CUTE) || attribute.equals(COOL) || attribute.equals(PASSION) || attribute.equals(NONSELECTED))) {
            throw new IllegalArgumentException("Illegal attribute value: " + attribute);
        }
        if (data.isEmpty()) {
            JOptionPane.showMessageDialog(null, "\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027\u306e\u66f2\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\n\u6761\u4ef6\u3092\u5909\u3048\u3066\u307f\u3066\u304f\u3060\u3055\u3044");
            throw new IllegalArgumentException("ArrayList must not empty.");
        }
        ArrayList<Song> res = new ArrayList();
        if (attribute.equals(NONSELECTED)) {
            res = data;
        } else {
            int i = 0;
            while (i < data.size()) {
                if (data.get(i).getAttribute().equals(attribute)) {
                    res.add(data.get(i));
                }
                ++i;
            }
        }
        return res;
    }

    public static ArrayList<Song> getSpecificDifficultySongs(ArrayList<Song> data, String difficulty) {
        if (!(difficulty.equals(DEBUT) || difficulty.equals(REGULAR) || difficulty.equals(PRO) || difficulty.equals(MASTER) || difficulty.equals(MASTERPLUS) || difficulty.equals(LEGACYMASTERPLUS) || difficulty.equals(LIGHT) || difficulty.equals(TRICK) || difficulty.equals(PIANO) || difficulty.equals(FORTE) || difficulty.equals(WITCH) || difficulty.equals(NONSELECTED))) {
            throw new IllegalArgumentException("Illegal difficulty value.");
        }
        if (data.isEmpty()) {
            throw new IllegalArgumentException("ArrayList must not empty.");
        }
        ArrayList<Song> res = new ArrayList();
        if (difficulty.equals(NONSELECTED)) {
            res = data;
        } else {
            int i = 0;
            while (i < data.size()) {
                if (data.get(i).getDifficulty().equals(difficulty)) {
                    res.add(data.get(i));
                }
                ++i;
            }
        }
        return res;
    }

    public static ArrayList<Song> getSpecificLevelSongs(ArrayList<Song> data, int level, boolean isLess, boolean isMore) {
        ArrayList<Song> res;
        block9: {
            block8: {
                if (level <= 0) {
                    throw new IllegalArgumentException("Level must not negative.");
                }
                if (data.isEmpty()) {
                    throw new IllegalArgumentException("ArrayList must not empty.");
                }
                if (!isLess && !isMore) {
                    throw new IllegalArgumentException("Illegal boolean value.");
                }
                if (isLess && isMore) {
                    return Scraping.getOnlyLevelSongs(data, level);
                }
                res = new ArrayList<Song>();
                if (!isLess) break block8;
                int i = 0;
                while (i < data.size()) {
                    if (data.get(i).getLevel() < level) {
                        res.add(data.get(i));
                    }
                    ++i;
                }
                break block9;
            }
            if (!isMore) break block9;
            int i = 0;
            while (i < data.size()) {
                if (data.get(i).getLevel() > level) {
                    res.add(data.get(i));
                }
                ++i;
            }
        }
        return res;
    }

    private static ArrayList<Song> getOnlyLevelSongs(ArrayList<Song> data, int level) {
        ArrayList<Song> res = new ArrayList<Song>();
        int i = 0;
        while (i < data.size()) {
            if (data.get(i).getLevel() == level) {
                res.add(data.get(i));
            }
            ++i;
        }
        return res;
    }

    public static ArrayList<Song> getFromJson() {
        long time = System.currentTimeMillis();
        SongJSONProperty property = null;
        try {
            property = (SongJSONProperty)new ObjectMapper().readValue(new File(DBPATH), SongJSONProperty.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<Song> res = new ArrayList<Song>();
        res.addAll(property.getList());
        LimitedLog.println(Scraping.class + ":[INFO]: JSON reading compeleted in " + (System.currentTimeMillis() - time) + "ms");
        return res;
    }

    public static boolean writeToJson(ArrayList<Song> list) {
        boolean res = true;
        SongJSONProperty property = new SongJSONProperty();
        property.setList(list);
        ObjectWriter writer = new ObjectMapper().writer((PrettyPrinter)new DefaultPrettyPrinter());
        try {
            writer.writeValue(Paths.get(DBPATH, new String[0]).toFile(), (Object)property);
        }
        catch (IOException e) {
            res = false;
        }
        return res;
    }
}

