/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;

public final class XMLUtil {
    private XMLUtil() {
    }

    public static SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        return XMLUtil.newSAXParser(true, false, false);
    }

    public static SAXParser newSAXParser(boolean bl, boolean bl2, boolean bl3) throws ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(bl);
        sAXParserFactory.setValidating(bl2);
        sAXParserFactory.setXIncludeAware(bl3);
        try {
            sAXParserFactory.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sAXParserFactory.newSAXParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadXML(File file, String[] stringArray) throws IOException {
        String string = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            string = XMLUtil.loadXML(fileInputStream, stringArray);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadXML(URL uRL, String[] stringArray) throws IOException {
        String string = null;
        URLConnection uRLConnection = URLUtil.openConnectionNoCache(uRL);
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            string = XMLUtil.loadXML(inputStream, stringArray);
        }
        finally {
            inputStream.close();
        }
        return string;
    }

    public static String loadXML(InputStream inputStream, String[] stringArray) throws IOException {
        Reader reader = XMLUtil.createXMLReader(inputStream, stringArray);
        return XMLUtil.loadChars(reader);
    }

    public static String loadChars(Reader reader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[65536];
        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
            if (n <= 0) continue;
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public static Reader createXMLReader(InputStream inputStream, String[] stringArray) throws IOException {
        byte[] byArray = new byte[1024];
        int n = -1;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, byArray.length);
        try {
            int n2 = pushbackInputStream.read(byArray, 0, byArray.length);
            if (n2 > 0) {
                pushbackInputStream.unread(byArray, 0, n2);
            }
            n = n2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = null;
        if (n > 0) {
            Pattern pattern;
            Matcher matcher;
            String string2;
            if (n >= 2) {
                int n3 = byArray[0] & 0xFF;
                int n4 = byArray[1] & 0xFF;
                switch (n3 << 8 | n4) {
                    case 65279: {
                        string = "UTF-16BE";
                        pushbackInputStream.skip(2L);
                        break;
                    }
                    case 65534: {
                        string = "UTF-16LE";
                        pushbackInputStream.skip(2L);
                        break;
                    }
                    case 61371: {
                        if (n < 3 || (byArray[2] & 0xFF) != 191) break;
                        string = "UTF-8";
                        pushbackInputStream.skip(3L);
                    }
                }
            }
            if (string == null && (string2 = new String(byArray, 0, n, "US-ASCII")).startsWith("<?xml") && (matcher = (pattern = Pattern.compile("encoding\\s*=\\s*['\"]([^'\"]+)")).matcher(string2)).find()) {
                string = matcher.group(1);
            }
        }
        if (string != null) {
            if (stringArray != null) {
                stringArray[0] = string;
            }
            try {
                return new InputStreamReader((InputStream)pushbackInputStream, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (stringArray != null) {
            stringArray[0] = "UTF-8";
        }
        return new InputStreamReader((InputStream)pushbackInputStream, "UTF-8");
    }
}

