/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import java.util.StringTokenizer;

public final class XMLText {
    private XMLText() {
    }

    public static boolean isXMLSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean isXMLSpace(String string) {
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isXMLChar(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': {
                return true;
            }
        }
        return c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
    }

    public static boolean checkText(String string) {
        boolean bl = false;
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block3;
                }
                default: {
                    if (c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') continue block3;
                    bl = true;
                }
            }
        }
        return !bl;
    }

    public static String filterText(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        block4: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\t': 
                case '\n': {
                    cArray[n++] = c;
                    continue block4;
                }
                case '\r': {
                    if (i + 1 < cArray.length && cArray[i + 1] == '\n') {
                        ++i;
                    }
                    cArray[n++] = 10;
                    continue block4;
                }
                default: {
                    if ((c < ' ' || c > '\ud7ff') && (c < '\ue000' || c > '\ufffd')) continue block4;
                    cArray[n++] = c;
                }
            }
        }
        return new String(cArray, 0, n);
    }

    public static boolean isNCNameStartChar(char c) {
        switch (c) {
            case '_': 
            case '\u0386': 
            case '\u038c': 
            case '\u03da': 
            case '\u03dc': 
            case '\u03de': 
            case '\u03e0': 
            case '\u0559': 
            case '\u06d5': 
            case '\u093d': 
            case '\u09b2': 
            case '\u0a5e': 
            case '\u0a8d': 
            case '\u0abd': 
            case '\u0ae0': 
            case '\u0b3d': 
            case '\u0b9c': 
            case '\u0cde': 
            case '\u0e30': 
            case '\u0e84': 
            case '\u0e8a': 
            case '\u0e8d': 
            case '\u0ea5': 
            case '\u0ea7': 
            case '\u0eb0': 
            case '\u0ebd': 
            case '\u1100': 
            case '\u1109': 
            case '\u113c': 
            case '\u113e': 
            case '\u1140': 
            case '\u114c': 
            case '\u114e': 
            case '\u1150': 
            case '\u1159': 
            case '\u1163': 
            case '\u1165': 
            case '\u1167': 
            case '\u1169': 
            case '\u1175': 
            case '\u119e': 
            case '\u11a8': 
            case '\u11ab': 
            case '\u11ba': 
            case '\u11eb': 
            case '\u11f0': 
            case '\u11f9': 
            case '\u1f59': 
            case '\u1f5b': 
            case '\u1f5d': 
            case '\u1fbe': 
            case '\u2126': 
            case '\u212e': 
            case '\u3007': {
                return true;
            }
        }
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u00ff' || c >= '\u0100' && c <= '\u0131' || c >= '\u0134' && c <= '\u013e' || c >= '\u0141' && c <= '\u0148' || c >= '\u014a' && c <= '\u017e' || c >= '\u0180' && c <= '\u01c3' || c >= '\u01cd' && c <= '\u01f0' || c >= '\u01f4' && c <= '\u01f5' || c >= '\u01fa' && c <= '\u0217' || c >= '\u0250' && c <= '\u02a8' || c >= '\u02bb' && c <= '\u02c1' || c >= '\u0388' && c <= '\u038a' || c >= '\u038e' && c <= '\u03a1' || c >= '\u03a3' && c <= '\u03ce' || c >= '\u03d0' && c <= '\u03d6' || c >= '\u03e2' && c <= '\u03f3' || c >= '\u0401' && c <= '\u040c' || c >= '\u040e' && c <= '\u044f' || c >= '\u0451' && c <= '\u045c' || c >= '\u045e' && c <= '\u0481' || c >= '\u0490' && c <= '\u04c4' || c >= '\u04c7' && c <= '\u04c8' || c >= '\u04cb' && c <= '\u04cc' || c >= '\u04d0' && c <= '\u04eb' || c >= '\u04ee' && c <= '\u04f5' || c >= '\u04f8' && c <= '\u04f9' || c >= '\u0531' && c <= '\u0556' || c >= '\u0561' && c <= '\u0586' || c >= '\u05d0' && c <= '\u05ea' || c >= '\u05f0' && c <= '\u05f2' || c >= '\u0621' && c <= '\u063a' || c >= '\u0641' && c <= '\u064a' || c >= '\u0671' && c <= '\u06b7' || c >= '\u06ba' && c <= '\u06be' || c >= '\u06c0' && c <= '\u06ce' || c >= '\u06d0' && c <= '\u06d3' || c >= '\u06e5' && c <= '\u06e6' || c >= '\u0905' && c <= '\u0939' || c >= '\u0958' && c <= '\u0961' || c >= '\u0985' && c <= '\u098c' || c >= '\u098f' && c <= '\u0990' || c >= '\u0993' && c <= '\u09a8' || c >= '\u09aa' && c <= '\u09b0' || c >= '\u09b6' && c <= '\u09b9' || c >= '\u09dc' && c <= '\u09dd' || c >= '\u09df' && c <= '\u09e1' || c >= '\u09f0' && c <= '\u09f1' || c >= '\u0a05' && c <= '\u0a0a' || c >= '\u0a0f' && c <= '\u0a10' || c >= '\u0a13' && c <= '\u0a28' || c >= '\u0a2a' && c <= '\u0a30' || c >= '\u0a32' && c <= '\u0a33' || c >= '\u0a35' && c <= '\u0a36' || c >= '\u0a38' && c <= '\u0a39' || c >= '\u0a59' && c <= '\u0a5c' || c >= '\u0a72' && c <= '\u0a74' || c >= '\u0a85' && c <= '\u0a8b' || c >= '\u0a8f' && c <= '\u0a91' || c >= '\u0a93' && c <= '\u0aa8' || c >= '\u0aaa' && c <= '\u0ab0' || c >= '\u0ab2' && c <= '\u0ab3' || c >= '\u0ab5' && c <= '\u0ab9' || c >= '\u0b05' && c <= '\u0b0c' || c >= '\u0b0f' && c <= '\u0b10' || c >= '\u0b13' && c <= '\u0b28' || c >= '\u0b2a' && c <= '\u0b30' || c >= '\u0b32' && c <= '\u0b33' || c >= '\u0b36' && c <= '\u0b39' || c >= '\u0b5c' && c <= '\u0b5d' || c >= '\u0b5f' && c <= '\u0b61' || c >= '\u0b85' && c <= '\u0b8a' || c >= '\u0b8e' && c <= '\u0b90' || c >= '\u0b92' && c <= '\u0b95' || c >= '\u0b99' && c <= '\u0b9a' || c >= '\u0b9e' && c <= '\u0b9f' || c >= '\u0ba3' && c <= '\u0ba4' || c >= '\u0ba8' && c <= '\u0baa' || c >= '\u0bae' && c <= '\u0bb5' || c >= '\u0bb7' && c <= '\u0bb9' || c >= '\u0c05' && c <= '\u0c0c' || c >= '\u0c0e' && c <= '\u0c10' || c >= '\u0c12' && c <= '\u0c28' || c >= '\u0c2a' && c <= '\u0c33' || c >= '\u0c35' && c <= '\u0c39' || c >= '\u0c60' && c <= '\u0c61' || c >= '\u0c85' && c <= '\u0c8c' || c >= '\u0c8e' && c <= '\u0c90' || c >= '\u0c92' && c <= '\u0ca8' || c >= '\u0caa' && c <= '\u0cb3' || c >= '\u0cb5' && c <= '\u0cb9' || c >= '\u0ce0' && c <= '\u0ce1' || c >= '\u0d05' && c <= '\u0d0c' || c >= '\u0d0e' && c <= '\u0d10' || c >= '\u0d12' && c <= '\u0d28' || c >= '\u0d2a' && c <= '\u0d39' || c >= '\u0d60' && c <= '\u0d61' || c >= '\u0e01' && c <= '\u0e2e' || c >= '\u0e32' && c <= '\u0e33' || c >= '\u0e40' && c <= '\u0e45' || c >= '\u0e81' && c <= '\u0e82' || c >= '\u0e87' && c <= '\u0e88' || c >= '\u0e94' && c <= '\u0e97' || c >= '\u0e99' && c <= '\u0e9f' || c >= '\u0ea1' && c <= '\u0ea3' || c >= '\u0eaa' && c <= '\u0eab' || c >= '\u0ead' && c <= '\u0eae' || c >= '\u0eb2' && c <= '\u0eb3' || c >= '\u0ec0' && c <= '\u0ec4' || c >= '\u0f40' && c <= '\u0f47' || c >= '\u0f49' && c <= '\u0f69' || c >= '\u10a0' && c <= '\u10c5' || c >= '\u10d0' && c <= '\u10f6' || c >= '\u1102' && c <= '\u1103' || c >= '\u1105' && c <= '\u1107' || c >= '\u110b' && c <= '\u110c' || c >= '\u110e' && c <= '\u1112' || c >= '\u1154' && c <= '\u1155' || c >= '\u115f' && c <= '\u1161' || c >= '\u116d' && c <= '\u116e' || c >= '\u1172' && c <= '\u1173' || c >= '\u11ae' && c <= '\u11af' || c >= '\u11b7' && c <= '\u11b8' || c >= '\u11bc' && c <= '\u11c2' || c >= '\u1e00' && c <= '\u1e9b' || c >= '\u1ea0' && c <= '\u1ef9' || c >= '\u1f00' && c <= '\u1f15' || c >= '\u1f18' && c <= '\u1f1d' || c >= '\u1f20' && c <= '\u1f45' || c >= '\u1f48' && c <= '\u1f4d' || c >= '\u1f50' && c <= '\u1f57' || c >= '\u1f5f' && c <= '\u1f7d' || c >= '\u1f80' && c <= '\u1fb4' || c >= '\u1fb6' && c <= '\u1fbc' || c >= '\u1fc2' && c <= '\u1fc4' || c >= '\u1fc6' && c <= '\u1fcc' || c >= '\u1fd0' && c <= '\u1fd3' || c >= '\u1fd6' && c <= '\u1fdb' || c >= '\u1fe0' && c <= '\u1fec' || c >= '\u1ff2' && c <= '\u1ff4' || c >= '\u1ff6' && c <= '\u1ffc' || c >= '\u212a' && c <= '\u212b' || c >= '\u2180' && c <= '\u2182' || c >= '\u3041' && c <= '\u3094' || c >= '\u30a1' && c <= '\u30fa' || c >= '\u3105' && c <= '\u312c' || c >= '\uac00' && c <= '\ud7a3' || c >= '\u4e00' && c <= '\u9fa5' || c >= '\u3021' && c <= '\u3029';
    }

    public static boolean isNCNameOtherChar(char c) {
        switch (c) {
            case '-': 
            case '.': 
            case '\u00b7': 
            case '\u02d0': 
            case '\u02d1': 
            case '\u0387': 
            case '\u05bf': 
            case '\u05c4': 
            case '\u0640': 
            case '\u0670': 
            case '\u093c': 
            case '\u094d': 
            case '\u09bc': 
            case '\u09be': 
            case '\u09bf': 
            case '\u09d7': 
            case '\u0a02': 
            case '\u0a3c': 
            case '\u0a3e': 
            case '\u0a3f': 
            case '\u0abc': 
            case '\u0b3c': 
            case '\u0bd7': 
            case '\u0d57': 
            case '\u0e31': 
            case '\u0e46': 
            case '\u0eb1': 
            case '\u0ec6': 
            case '\u0f35': 
            case '\u0f37': 
            case '\u0f39': 
            case '\u0f3e': 
            case '\u0f3f': 
            case '\u0f97': 
            case '\u0fb9': 
            case '\u20e1': 
            case '\u3005': 
            case '\u3099': 
            case '\u309a': {
                return true;
            }
        }
        return c >= '\u0300' && c <= '\u0345' || c >= '\u0360' && c <= '\u0361' || c >= '\u0483' && c <= '\u0486' || c >= '\u0591' && c <= '\u05a1' || c >= '\u05a3' && c <= '\u05b9' || c >= '\u05bb' && c <= '\u05bd' || c >= '\u05c1' && c <= '\u05c2' || c >= '\u064b' && c <= '\u0652' || c >= '\u06d6' && c <= '\u06dc' || c >= '\u06dd' && c <= '\u06df' || c >= '\u06e0' && c <= '\u06e4' || c >= '\u06e7' && c <= '\u06e8' || c >= '\u06ea' && c <= '\u06ed' || c >= '\u0901' && c <= '\u0903' || c >= '\u093e' && c <= '\u094c' || c >= '\u0951' && c <= '\u0954' || c >= '\u0962' && c <= '\u0963' || c >= '\u0981' && c <= '\u0983' || c >= '\u09c0' && c <= '\u09c4' || c >= '\u09c7' && c <= '\u09c8' || c >= '\u09cb' && c <= '\u09cd' || c >= '\u09e2' && c <= '\u09e3' || c >= '\u0a40' && c <= '\u0a42' || c >= '\u0a47' && c <= '\u0a48' || c >= '\u0a4b' && c <= '\u0a4d' || c >= '\u0a70' && c <= '\u0a71' || c >= '\u0a81' && c <= '\u0a83' || c >= '\u0abe' && c <= '\u0ac5' || c >= '\u0ac7' && c <= '\u0ac9' || c >= '\u0acb' && c <= '\u0acd' || c >= '\u0b01' && c <= '\u0b03' || c >= '\u0b3e' && c <= '\u0b43' || c >= '\u0b47' && c <= '\u0b48' || c >= '\u0b4b' && c <= '\u0b4d' || c >= '\u0b56' && c <= '\u0b57' || c >= '\u0b82' && c <= '\u0b83' || c >= '\u0bbe' && c <= '\u0bc2' || c >= '\u0bc6' && c <= '\u0bc8' || c >= '\u0bca' && c <= '\u0bcd' || c >= '\u0c01' && c <= '\u0c03' || c >= '\u0c3e' && c <= '\u0c44' || c >= '\u0c46' && c <= '\u0c48' || c >= '\u0c4a' && c <= '\u0c4d' || c >= '\u0c55' && c <= '\u0c56' || c >= '\u0c82' && c <= '\u0c83' || c >= '\u0cbe' && c <= '\u0cc4' || c >= '\u0cc6' && c <= '\u0cc8' || c >= '\u0cca' && c <= '\u0ccd' || c >= '\u0cd5' && c <= '\u0cd6' || c >= '\u0d02' && c <= '\u0d03' || c >= '\u0d3e' && c <= '\u0d43' || c >= '\u0d46' && c <= '\u0d48' || c >= '\u0d4a' && c <= '\u0d4d' || c >= '\u0e34' && c <= '\u0e3a' || c >= '\u0e47' && c <= '\u0e4e' || c >= '\u0eb4' && c <= '\u0eb9' || c >= '\u0ebb' && c <= '\u0ebc' || c >= '\u0ec8' && c <= '\u0ecd' || c >= '\u0f18' && c <= '\u0f19' || c >= '\u0f71' && c <= '\u0f84' || c >= '\u0f86' && c <= '\u0f8b' || c >= '\u0f90' && c <= '\u0f95' || c >= '\u0f99' && c <= '\u0fad' || c >= '\u0fb1' && c <= '\u0fb7' || c >= '\u20d0' && c <= '\u20dc' || c >= '\u302a' && c <= '\u302f' || c >= '0' && c <= '9' || c >= '\u0660' && c <= '\u0669' || c >= '\u06f0' && c <= '\u06f9' || c >= '\u0966' && c <= '\u096f' || c >= '\u09e6' && c <= '\u09ef' || c >= '\u0a66' && c <= '\u0a6f' || c >= '\u0ae6' && c <= '\u0aef' || c >= '\u0b66' && c <= '\u0b6f' || c >= '\u0be7' && c <= '\u0bef' || c >= '\u0c66' && c <= '\u0c6f' || c >= '\u0ce6' && c <= '\u0cef' || c >= '\u0d66' && c <= '\u0d6f' || c >= '\u0e50' && c <= '\u0e59' || c >= '\u0ed0' && c <= '\u0ed9' || c >= '\u0f20' && c <= '\u0f29' || c >= '\u3031' && c <= '\u3035' || c >= '\u309d' && c <= '\u309e' || c >= '\u30fc' && c <= '\u30fe';
    }

    public static boolean isNCNameChar(char c) {
        return XMLText.isNCNameStartChar(c) || XMLText.isNCNameOtherChar(c);
    }

    public static boolean isNCName(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!XMLText.isNCNameStartChar(c)) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if (XMLText.isNCNameChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNameStartChar(char c) {
        if (c == ':') {
            return true;
        }
        return XMLText.isNCNameStartChar(c);
    }

    public static boolean isNameOtherChar(char c) {
        if (c == ':') {
            return true;
        }
        return XMLText.isNCNameOtherChar(c);
    }

    public static boolean isNameChar(char c) {
        return XMLText.isNameStartChar(c) || XMLText.isNameOtherChar(c);
    }

    public static boolean isName(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!XMLText.isNameStartChar(c)) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if (XMLText.isNameChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNmtoken(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (XMLText.isNameChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPITarget(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return XMLText.isName(string) && !string.regionMatches(true, 0, "xml", 0, 3);
    }

    public static String collapseWhiteSpace(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        XMLText.compressWhiteSpace(string, stringBuilder);
        int n = stringBuilder.length() - 1;
        if (n >= 0) {
            if (stringBuilder.charAt(n) == ' ') {
                stringBuilder.deleteCharAt(n);
                --n;
            }
            if (n >= 0 && stringBuilder.charAt(0) == ' ') {
                stringBuilder.deleteCharAt(0);
            }
        }
        return stringBuilder.toString();
    }

    public static String compressWhiteSpace(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        XMLText.compressWhiteSpace(string, stringBuilder);
        return stringBuilder.toString();
    }

    private static void compressWhiteSpace(String string, StringBuilder stringBuilder) {
        int n = string.length();
        int n2 = 63;
        for (int i = 0; i < n; ++i) {
            int n3 = string.charAt(i);
            switch (n3) {
                case 9: 
                case 10: 
                case 13: {
                    n3 = 32;
                }
            }
            if (n3 == 32) {
                if (n2 == 32) continue;
                stringBuilder.append((char)n3);
                n2 = n3;
                continue;
            }
            stringBuilder.append((char)n3);
            n2 = n3;
        }
    }

    public static String replaceWhiteSpace(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        int n2 = 63;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\r': {
                    stringBuilder.append(' ');
                    break;
                }
                case '\n': {
                    if (n2 == 13) break;
                    stringBuilder.append(' ');
                    break;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
            n2 = c;
        }
        return stringBuilder.toString();
    }

    public static String[] splitList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String quoteXML(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        XMLText.quoteXML(string, stringBuilder);
        return stringBuilder.toString();
    }

    public static void quoteXML(String string, StringBuilder stringBuilder) {
        stringBuilder.append('\"');
        XMLText.escapeXML(string, stringBuilder);
        stringBuilder.append('\"');
    }

    public static String escapeXML(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        XMLText.escapeXML(string, stringBuilder);
        return stringBuilder.toString();
    }

    public static void escapeXML(String string, StringBuilder stringBuilder) {
        char[] cArray = string.toCharArray();
        XMLText.escapeXML(cArray, 0, cArray.length, stringBuilder);
    }

    public static void escapeXML(char[] cArray, int n, int n2, StringBuilder stringBuilder) {
        XMLText.escapeXML(cArray, n, n2, stringBuilder, Integer.MAX_VALUE);
    }

    public static void escapeXML(char[] cArray, int n, int n2, StringBuilder stringBuilder, int n3) {
        int n4 = n + n2;
        block7: for (int i = n; i < n4; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\'': {
                    stringBuilder.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&#34;");
                    continue block7;
                }
                case '<': {
                    stringBuilder.append("&#60;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&#62;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&#38;");
                    continue block7;
                }
                default: {
                    if (c > n3) {
                        stringBuilder.append("&#");
                        stringBuilder.append(Integer.toString(c));
                        stringBuilder.append(';');
                        continue block7;
                    }
                    stringBuilder.append(c);
                }
            }
        }
    }

    public static String unescapeXML(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        XMLText.unescapeXML(string, 0, string.length(), stringBuilder);
        return stringBuilder.toString();
    }

    public static void unescapeXML(String string, int n, int n2, StringBuilder stringBuilder) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                StringBuilder stringBuilder2 = new StringBuilder();
                ++i;
                while (i < n3 && (c = string.charAt(i)) != ';') {
                    stringBuilder2.append(c);
                    ++i;
                }
                c = XMLText.parseCharRef(stringBuilder2.toString());
            }
            stringBuilder.append(c);
        }
    }

    private static char parseCharRef(String string) {
        if (string.length() >= 2 && string.charAt(0) == '#') {
            int n;
            try {
                n = string.charAt(1) == 'x' ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (n < 0 || n > 65535) {
                return '?';
            }
            return (char)n;
        }
        if (string.equals("amp")) {
            return '&';
        }
        if (string.equals("apos")) {
            return '\'';
        }
        if (string.equals("quot")) {
            return '\"';
        }
        if (string.equals("lt")) {
            return '<';
        }
        if (string.equals("gt")) {
            return '>';
        }
        return '?';
    }
}

