/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.KeyValuePair;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearHashtable<K, V>
implements Cloneable,
Serializable {
    protected transient Object[] table;
    private static final long serialVersionUID = -8580213005877781060L;

    public LinearHashtable() {
        this(3);
    }

    public LinearHashtable(int n) {
        this.table = new Object[2 * n];
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this.table.length; i += 2) {
            if (this.table[i] == null) continue;
            ++n;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(V v) {
        for (int i = 1; i < this.table.length; i += 2) {
            Object object = this.table[i];
            if (!(v == null ? object == null : v.equals(object))) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(K k) {
        return this.get(k) != null;
    }

    public V get(K k) {
        int n = LinearHashtable.indexOf(this.table, k);
        return (V)(n < 0 ? null : this.table[n + 1]);
    }

    private static int indexOf(Object[] objectArray, Object object) {
        int n;
        assert (object != null);
        int n2 = object.hashCode();
        if (n2 < 0) {
            n2 = -n2;
        }
        int n3 = n = 2 * (n2 % (objectArray.length / 2));
        do {
            Object object2;
            if ((object2 = objectArray[n3]) == null || object2.equals(object)) {
                return n3;
            }
            if ((n3 += 2) != objectArray.length) continue;
            n3 = 0;
        } while (n3 != n);
        return -1;
    }

    public V put(K k, V v) {
        Object[] objectArray;
        int n = LinearHashtable.indexOf(this.table, k);
        if (n < 0) {
            objectArray = new Object[2 * this.table.length];
            for (int i = 0; i < this.table.length; i += 2) {
                Object object = this.table[i];
                if (object == null) continue;
                int n2 = LinearHashtable.indexOf(objectArray, object);
                objectArray[n2] = object;
                objectArray[n2 + 1] = this.table[i + 1];
            }
            this.table = objectArray;
            n = LinearHashtable.indexOf(this.table, k);
        }
        objectArray = this.table[n + 1];
        this.table[n] = k;
        this.table[n + 1] = v;
        return (V)objectArray;
    }

    public V remove(K k) {
        int n = LinearHashtable.indexOf(this.table, k);
        if (n < 0 || this.table[n] == null) {
            return null;
        }
        Object object = this.table[n + 1];
        this.table[n] = null;
        this.table[n + 1] = null;
        while (true) {
            if ((n += 2) == this.table.length) {
                n = 0;
            }
            if (this.table[n] == null) break;
            Object object2 = this.table[n];
            int n2 = LinearHashtable.indexOf(this.table, object2);
            if (this.table[n2] != null) continue;
            this.table[n2] = object2;
            this.table[n2 + 1] = this.table[n + 1];
            this.table[n] = null;
            this.table[n + 1] = null;
        }
        return (V)object;
    }

    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
    }

    public Object clone() {
        LinearHashtable linearHashtable;
        try {
            linearHashtable = (LinearHashtable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
        linearHashtable.table = new Object[this.table.length];
        System.arraycopy(this.table, 0, linearHashtable.table, 0, this.table.length);
        return linearHashtable;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('[');
        boolean bl = true;
        for (int i = 0; i < this.table.length; i += 2) {
            if (this.table[i] == null) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.table[i]);
            stringBuilder.append('=');
            stringBuilder.append(this.table[i + 1]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public void copyKeysInto(K[] KArray) {
        int n = 0;
        for (int i = 0; i < this.table.length; i += 2) {
            if (this.table[i] == null) continue;
            KArray[n++] = this.table[i];
        }
    }

    public void copyElementsInto(V[] VArray) {
        int n = 0;
        for (int i = 0; i < this.table.length; i += 2) {
            if (this.table[i] == null) continue;
            VArray[n++] = this.table[i + 1];
        }
    }

    public Iterator<K> keys() {
        return new KeyIterator();
    }

    public Iterator<V> elements() {
        return new ValueIterator();
    }

    public Iterator<KeyValuePair<K, V>> entries() {
        return new EntryIterator();
    }

    public Object[] getKeyValueTable() {
        return this.table;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.table.length;
        objectOutputStream.writeInt(n);
        objectOutputStream.writeInt(2 * this.size());
        for (int i = 0; i < n; i += 2) {
            if (this.table[i] == null) continue;
            objectOutputStream.writeObject(this.table[i]);
            objectOutputStream.writeObject(this.table[i + 1]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.table = new Object[objectInputStream.readInt()];
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; i += 2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            int n2 = LinearHashtable.indexOf(this.table, object);
            this.table[n2] = object;
            this.table[n2 + 1] = object2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class EntryIterator<K, V>
    implements Iterator<KeyValuePair<K, V>> {
        private int index = 0;
        private KeyValuePair<K, V> entry = new KeyValuePair();

        public EntryIterator() {
            this.moveToNext();
        }

        private void moveToNext() {
            while (this.index < LinearHashtable.this.table.length && LinearHashtable.this.table[this.index] == null) {
                this.index += 2;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < LinearHashtable.this.table.length;
        }

        @Override
        public KeyValuePair<K, V> next() {
            if (this.index < LinearHashtable.this.table.length) {
                this.entry.key = LinearHashtable.this.table[this.index];
                this.entry.value = LinearHashtable.this.table[this.index + 1];
                this.index += 2;
                this.moveToNext();
                return this.entry;
            }
            this.entry.key = null;
            this.entry.value = null;
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ValueIterator<V>
    implements Iterator {
        private int index = 0;

        public ValueIterator() {
            this.moveToNext();
        }

        private void moveToNext() {
            while (this.index < LinearHashtable.this.table.length && LinearHashtable.this.table[this.index] == null) {
                this.index += 2;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < LinearHashtable.this.table.length;
        }

        public V next() {
            Object object;
            if (this.index < LinearHashtable.this.table.length) {
                object = LinearHashtable.this.table[this.index + 1];
                this.index += 2;
                this.moveToNext();
            } else {
                object = null;
            }
            return (V)object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class KeyIterator<K>
    implements Iterator {
        private int index = 0;

        public KeyIterator() {
            this.moveToNext();
        }

        private void moveToNext() {
            while (this.index < LinearHashtable.this.table.length && LinearHashtable.this.table[this.index] == null) {
                this.index += 2;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < LinearHashtable.this.table.length;
        }

        public K next() {
            Object object;
            if (this.index < LinearHashtable.this.table.length) {
                object = LinearHashtable.this.table[this.index];
                this.index += 2;
                this.moveToNext();
            } else {
                object = null;
            }
            return (K)object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

