/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.netutil;

import com.xmlmind.netutil.FileContent;
import com.xmlmind.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;

public class MultipartWriter {
    public static final String NEWLINE = "\r\n";
    public static final String BOUNDARY_PREFIX = "--";
    protected HttpURLConnection connection;
    protected String boundary;
    protected OutputStream out;

    public MultipartWriter(HttpURLConnection httpURLConnection) throws IOException {
        this.connection = httpURLConnection;
        this.boundary = "--------------------" + Long.toString(System.currentTimeMillis(), 36);
        httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.out = httpURLConnection.getOutputStream();
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void writePart(String string, String string2, String string3) throws IOException {
        this.writeBoundary();
        this.writeBytes("Content-Disposition: form-data; name=" + MultipartWriter.quoteText(string));
        this.writeBytes(NEWLINE);
        if (string3 == null) {
            string3 = "UTF-8";
        }
        this.writeBytes("Content-Type: text/plain; charset=" + string3);
        this.writeBytes(NEWLINE);
        this.writeBytes("Content-Transfer-Encoding: binary");
        this.writeBytes(NEWLINE);
        this.writeBytes(NEWLINE);
        this.writeBytes(string2, string3);
        this.writeBytes(NEWLINE);
        this.out.flush();
    }

    public static String quoteText(String string) {
        byte[] byArray = null;
        if (!MultipartWriter.isQtext(string)) {
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray == null) {
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
        } else {
            stringBuffer.append("=?utf-8?b?");
            stringBuffer.append(Base64.encode(byArray));
            stringBuffer.append("?=");
        }
        return stringBuffer.toString();
    }

    public static boolean isQtext(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': 
                case '\"': 
                case '\\': {
                    return false;
                }
            }
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePart(String string, FileContent fileContent) throws IOException {
        this.writeBoundary();
        String string2 = fileContent.getName();
        if (string2 == null) {
            string2 = "";
        }
        this.writeBytes("Content-Disposition: form-data; name=" + MultipartWriter.quoteText(string) + "; filename=" + MultipartWriter.quoteText(string2));
        this.writeBytes(NEWLINE);
        String string3 = fileContent.getContentType();
        if (string3 == null) {
            string3 = "application/octet-stream";
        }
        this.writeBytes("Content-Type: " + string3);
        this.writeBytes(NEWLINE);
        this.writeBytes("Content-Length: " + fileContent.getSize());
        this.writeBytes(NEWLINE);
        this.writeBytes("Content-Transfer-Encoding: binary");
        this.writeBytes(NEWLINE);
        this.writeBytes(NEWLINE);
        InputStream inputStream = fileContent.getInputStream();
        try {
            MultipartWriter.copyBytes(inputStream, this.out);
        }
        finally {
            inputStream.close();
        }
        this.writeBytes(NEWLINE);
        this.out.flush();
    }

    public static final void copyBytes(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public void writeBoundary() throws IOException {
        this.writeBytes(BOUNDARY_PREFIX);
        this.writeBytes(this.boundary);
        this.writeBytes(NEWLINE);
    }

    public void writeBytes(String string) throws IOException {
        this.writeBytes(string, "US-ASCII");
    }

    public void writeBytes(String string, String string2) throws IOException {
        this.out.write(string.getBytes(string2));
    }

    public void writeEndOfParts() throws IOException {
        this.writeBytes(BOUNDARY_PREFIX);
        this.writeBytes(this.boundary);
        this.writeBytes(BOUNDARY_PREFIX);
        this.writeBytes(NEWLINE);
    }
}

