/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.api.QizxException;
import com.qizx.xdm.BaseNodeFilter;
import com.qizx.xdm.CorePushBuilder;
import com.qizx.xdm.IQName;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.ArraySequence;
import com.qizx.xquery.dt.SingleNode;
import com.qizx.xquery.dt.SingleQName;
import com.qizx.xquery.dt.SingleString;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.LocalVariable;

public class TryCatchExpr
extends Expression {
    protected Expression caught;
    protected Catch[] catches;
    protected boolean compatibility;

    public TryCatchExpr(Expression expression, Catch catch_) {
        this.caught = expression;
        this.catches = new Catch[]{catch_};
    }

    public TryCatchExpr(Expression expression, QName qName, Expression expression2) {
        this.compatibility = true;
        this.caught = expression;
        Catch catch_ = new Catch(null);
        this.catches = new Catch[]{catch_};
        catch_.handler = expression2;
        catch_.valueVarName = qName;
    }

    public void addCatch(Catch catch_) {
        Catch[] catchArray = this.catches;
        this.catches = new Catch[catchArray.length + 1];
        System.arraycopy(catchArray, 0, this.catches, 0, catchArray.length);
        this.catches[catchArray.length] = catch_;
    }

    public Expression child(int n) {
        return --n < 0 ? this.caught : (n < this.catches.length ? this.catches[n] : null);
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.child("caught", this.caught);
        exprDisplay.children("catches", this.catches);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        this.caught = moduleContext.staticCheck(this.caught, 0);
        this.type = this.caught.getType();
        for (int i = 0; i < this.catches.length; ++i) {
            Catch catch_ = this.catches[i];
            LocalVariable localVariable = moduleContext.latestLocalVariable();
            if (catch_.codeVarName != null) {
                catch_.codeVar = moduleContext.defineLocalVariable(catch_.codeVarName, XQType.QNAME, this);
                catch_.codeVar.storageType(XQType.QNAME, moduleContext);
            }
            if (catch_.descVarName != null) {
                catch_.descVar = moduleContext.defineLocalVariable(catch_.descVarName, XQType.STRING, this);
                catch_.descVar.storageType(XQType.STRING, moduleContext);
            }
            if (catch_.valueVarName != null) {
                catch_.valueVar = moduleContext.defineLocalVariable(catch_.valueVarName, XQType.ANY, this);
                catch_.valueVar.storageType(XQType.ANY, moduleContext);
            }
            catch_.handler = moduleContext.staticCheck(catch_.handler, 0);
            moduleContext.popLocalVariables(localVariable);
            this.type = this.type.unionWith(catch_.handler.getType(), true);
        }
        return this;
    }

    public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
        evalContext.at(this);
        try {
            XQValue xQValue = this.caught.eval(focus, evalContext);
            ArraySequence arraySequence = new ArraySequence(4, xQValue);
            while (xQValue.next()) {
                arraySequence.addItem(xQValue.getItem());
            }
            return arraySequence;
        }
        catch (EvaluationException evaluationException) {
            Catch catch_ = null;
            for (int i = 0; i < this.catches.length; ++i) {
                if (!this.catches[i].catches(evaluationException.getErrorCode())) continue;
                catch_ = this.catches[i];
                break;
            }
            if (catch_ == null) {
                throw evaluationException;
            }
            if (this.compatibility) {
                CorePushBuilder corePushBuilder = new CorePushBuilder("");
                IQName iQName = IQName.get(evaluationException.getErrorCode());
                try {
                    corePushBuilder.putElementStart(iQName);
                    corePushBuilder.putText(evaluationException.getMessage());
                    corePushBuilder.putElementEnd(iQName);
                }
                catch (QizxException qizxException) {
                    // empty catch block
                }
                evalContext.storeLocal(catch_.valueVar.address, new SingleNode(corePushBuilder.harvest()), false, null);
            } else {
                if (catch_.codeVar != null) {
                    evalContext.storeLocal(catch_.codeVar.address, new SingleQName(evaluationException.getErrorCode()), false, null);
                }
                if (catch_.descVar != null) {
                    evalContext.storeLocal(catch_.descVar.address, new SingleString(evaluationException.getMessage()), false, null);
                }
                if (catch_.valueVar != null) {
                    XQValue xQValue = evaluationException.getValue();
                    if (xQValue == null) {
                        xQValue = XQValue.empty;
                    }
                    evalContext.storeLocal(catch_.valueVar.address, xQValue, false, null);
                }
            }
            return catch_.handler.eval(focus, evalContext);
        }
    }

    public static class Catch
    extends Expression {
        public BaseNodeFilter[] names;
        public QName codeVarName;
        public LocalVariable codeVar;
        public QName descVarName;
        public LocalVariable descVar;
        public QName valueVarName;
        public LocalVariable valueVar;
        public Expression handler;

        public Catch(BaseNodeFilter baseNodeFilter) {
            if (baseNodeFilter != null) {
                this.names = new BaseNodeFilter[]{baseNodeFilter};
            }
        }

        public void addTest(BaseNodeFilter baseNodeFilter) {
            BaseNodeFilter[] baseNodeFilterArray = this.names;
            this.names = new BaseNodeFilter[baseNodeFilterArray.length + 1];
            System.arraycopy(baseNodeFilterArray, 0, this.names, 0, baseNodeFilterArray.length);
            this.names[baseNodeFilterArray.length] = baseNodeFilter;
        }

        public Expression child(int n) {
            return n == 0 ? this.handler : null;
        }

        public boolean catches(QName qName) {
            if (this.names == null) {
                return true;
            }
            int n = this.names.length;
            while (--n >= 0) {
                if (!this.names[n].accepts(2, qName)) continue;
                return true;
            }
            return false;
        }
    }
}

