/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.api.Item;
import com.qizx.xdm.XMLPushStreamBase;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.GenericValue;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.UpdatingExpr;

public class SequenceExpr
extends Expression {
    Expression[] exprs = new Expression[0];
    boolean updating;

    public void addExpr(Expression expression) {
        this.exprs = SequenceExpr.addExpr(this.exprs, expression);
    }

    Expression getExpr(int n) {
        return n < 0 || n >= this.exprs.length ? null : this.exprs[n];
    }

    public Expression child(int n) {
        return n < this.exprs.length ? this.exprs[n] : null;
    }

    public int getFlags() {
        return this.updating ? 128 : 0;
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.children("exprs", this.exprs);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        int n2 = 0;
        this.type = this.exprs.length == 0 ? XQType.NONE.opt : null;
        int n3 = this.exprs.length;
        for (int i = 0; i < n3; ++i) {
            Expression expression = this.exprs[i] = moduleContext.simpleStaticCheck(this.exprs[i], 0);
            this.type = this.type == null ? expression.getType() : this.type.unionWith(expression.getType(), false);
            if (this.type == null) {
                moduleContext.error("(BUG)", expression, "no union type found");
            }
            if (UpdatingExpr.isUpdating(expression)) {
                this.updating = true;
                continue;
            }
            if (UpdatingExpr.isVacuous(expression)) continue;
            ++n2;
        }
        if (this.updating && n2 > 0) {
            moduleContext.error("XUST0001", (Expression)this, "mix of updating and non-updating expressions in Comma expression");
        }
        return this;
    }

    public boolean isVacuous() {
        if (this.exprs == null || this.exprs.length == 0) {
            return true;
        }
        int n = this.exprs.length;
        for (int i = 0; i < n; ++i) {
            if (UpdatingExpr.isVacuous(this.exprs[i])) continue;
            return false;
        }
        return true;
    }

    public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
        return new Sequence(focus, evalContext);
    }

    public void evalAsEvents(XMLPushStreamBase xMLPushStreamBase, Focus focus, EvalContext evalContext) throws EvaluationException {
        evalContext.at(this);
        int n = this.exprs.length;
        for (int i = 0; i < n; ++i) {
            this.exprs[i].evalAsEvents(xMLPushStreamBase, focus, evalContext);
        }
    }

    public class Sequence
    extends GenericValue {
        Focus focus;
        EvalContext context;
        XQValue curComp;
        int index;

        Sequence(Focus focus, EvalContext evalContext) {
            this.focus = focus;
            this.context = evalContext;
            this.curComp = XQValue.empty;
            this.index = -1;
        }

        public boolean next() throws EvaluationException {
            while (true) {
                if (this.curComp.next()) {
                    this.item = this.curComp.getItem();
                    return true;
                }
                if (++this.index >= SequenceExpr.this.exprs.length) {
                    return false;
                }
                this.curComp = SequenceExpr.this.getExpr(this.index).eval(this.focus, this.context);
            }
        }

        public boolean nextCollection() throws EvaluationException {
            while (true) {
                if (this.curComp.nextCollection()) {
                    this.item = this.curComp.getItem();
                    return true;
                }
                if (++this.index >= SequenceExpr.this.exprs.length) {
                    return false;
                }
                this.curComp = SequenceExpr.this.getExpr(this.index).eval(this.focus, this.context);
            }
        }

        public XQValue bornAgain() {
            return new Sequence(this.focus, this.context);
        }

        public double getFulltextScore(Item item) throws EvaluationException {
            if (item == null) {
                item = this.getNode();
            }
            return this.curComp.getFulltextScore(item);
        }
    }
}

