/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.api.util.time.Duration;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.SingleDecimal;
import com.qizx.xquery.dt.SingleDouble;
import com.qizx.xquery.dt.SingleDuration;
import com.qizx.xquery.dt.SingleFloat;
import com.qizx.xquery.dt.SingleInteger;
import com.qizx.xquery.dt.SingleMoment;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.NumericOp;

public class PlusOp
extends NumericOp {
    public PlusOp(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Prototype[] getProtos() {
        return null;
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.child("expr1", this.operands[0]);
        exprDisplay.child("expr2", this.operands[1]);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        Expression expression = null;
        switch (this.combinedArgTypes(moduleContext)) {
            case 17: {
                expression = this.transfer(new ExecInt(), this.operands);
                break;
            }
            case 20: 
            case 36: 
            case 52: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                expression = this.transfer(new ExecDouble(), this.operands);
                break;
            }
            default: {
                expression = this.transfer(new ExecAny(), this.operands);
            }
        }
        if (this.operands[0].isConstant() && this.operands[1].isConstant()) {
            return moduleContext.evalConstantExpr(expression);
        }
        return expression;
    }

    public static class ExecAny
    extends Function.NumericCall {
        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            evalContext.at(this);
            XQItem xQItem = this.args[0].evalAsOptItem(focus, evalContext);
            XQItem xQItem2 = this.args[1].evalAsOptItem(focus, evalContext);
            if (xQItem == null || xQItem2 == null) {
                return XQValue.empty;
            }
            try {
                switch (NumericOp.combinedArgTypes(xQItem, xQItem2)) {
                    case 17: {
                        long l = xQItem.getInteger();
                        long l2 = xQItem2.getInteger();
                        if (!Conversion.isIntegerRange((double)l + (double)l2)) {
                            evalContext.error("FOAR0002", (Expression)this, "integer overflow");
                        }
                        return new SingleInteger(l + l2);
                    }
                    case 18: 
                    case 33: 
                    case 34: {
                        return new SingleDecimal(xQItem.getDecimal().add(xQItem2.getDecimal()));
                    }
                    case 19: 
                    case 35: 
                    case 49: 
                    case 50: 
                    case 51: {
                        return new SingleFloat(xQItem.getFloat() + xQItem2.getFloat());
                    }
                    case 20: 
                    case 36: 
                    case 52: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: {
                        return new SingleDouble(xQItem.getDouble() + xQItem2.getDouble());
                    }
                    case 170: {
                        return SingleDuration.newYM(Duration.newYearMonth(xQItem.getDuration().getTotalMonths() + xQItem2.getDuration().getTotalMonths()));
                    }
                    case 187: {
                        return SingleDuration.newDT(Duration.newDayTime(xQItem.getDuration().getTotalSeconds() + xQItem2.getDuration().getTotalSeconds()));
                    }
                    case 138: 
                    case 139: {
                        return SingleMoment.dateTime(xQItem.getMoment().add(xQItem2.getDuration()));
                    }
                    case 168: 
                    case 184: {
                        return SingleMoment.dateTime(xQItem2.getMoment().add(xQItem.getDuration()));
                    }
                    case 129: 
                    case 132: {
                        return SingleMoment.dateTime(xQItem.getMoment().add(xQItem2.getDouble()));
                    }
                    case 154: 
                    case 155: {
                        return SingleMoment.date(xQItem.getMoment().add(xQItem2.getDuration()));
                    }
                    case 169: 
                    case 185: {
                        return SingleMoment.date(xQItem2.getMoment().add(xQItem.getDuration()));
                    }
                    case 145: {
                        return SingleMoment.date(xQItem.getMoment().add(86400L * xQItem2.getInteger()));
                    }
                    case 123: {
                        return SingleMoment.time(xQItem.getMoment().add(xQItem2.getDuration()));
                    }
                    case 183: {
                        return SingleMoment.time(xQItem2.getMoment().add(xQItem.getDuration()));
                    }
                }
                evalContext.error("XPTY0004", (Expression)this, "invalid types for operator +");
            }
            catch (DateTimeException dateTimeException) {
                evalContext.error("XPTY0004", (Expression)this, "should not happen: " + dateTimeException);
            }
            return null;
        }
    }

    public static class ExecDouble
    extends Function.OptDoubleCall {
        public double evalAsOptDouble(Focus focus, EvalContext evalContext) throws EvaluationException {
            double d = this.args[0].evalAsOptDouble(focus, evalContext);
            double d2 = this.args[1].evalAsOptDouble(focus, evalContext);
            evalContext.at(this);
            return d + d2;
        }
    }

    public static class ExecInt
    extends Function.OptIntegerCall {
        public long evalAsOptInteger(Focus focus, EvalContext evalContext) throws EvaluationException {
            long l = this.args[0].evalAsOptInteger(focus, evalContext);
            long l2 = this.args[1].evalAsOptInteger(focus, evalContext);
            evalContext.at(this);
            return l + l2;
        }
    }
}

