/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.api.Item;
import com.qizx.api.QName;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.LocalVariable;
import com.qizx.xquery.op.VarClause;

public class ForClause
extends VarClause {
    public QName position;
    public LocalVariable posDecl;
    public QName score;
    public LocalVariable scoreDecl;

    public ForClause(QName qName) {
        super(qName);
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.property("variable", "$" + this.variable + " as " + this.declaredType + (exprDisplay.isPretty() ? "" : " addr " + this.varDecl.address));
        if (this.position != null) {
            exprDisplay.property("position", this.position + " addr " + this.posDecl.address);
        }
        if (this.score != null) {
            exprDisplay.property("score", this.score + " addr " + this.scoreDecl.address);
        }
        exprDisplay.child("expr", this.expr);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        if (this.checked) {
            return this;
        }
        this.checked = true;
        this.expr = moduleContext.staticCheck(this.expr, 0);
        if (this.declaredType != null && this.declaredType.getOccurrence() != 1) {
            this.module.warning("XPTY0004", this.offset, "improper type occurrence for variable $" + this.variable + ": must be one");
        }
        this.type = this.declaredType;
        if (this.type == null) {
            this.type = this.expr.getType().itemType();
        }
        this.varDecl = moduleContext.defineLocalVariable(this.variable, this.declaredType, this);
        this.varDecl.offset = this.offset;
        if (this.declaredType != null) {
            this.varDecl.address = -1;
        } else {
            this.varDecl.storageType(this.type, moduleContext);
        }
        if (this.position != null) {
            if (this.position == this.variable) {
                this.module.error("XQST0089", (Expression)this, "duplicate local variable " + this.position);
            }
            this.posDecl = moduleContext.defineLocalVariable(this.position, XQType.INTEGER, this);
            this.posDecl.storageType(XQType.INTEGER, moduleContext);
        }
        if (this.score != null) {
            if (this.score == this.position || this.score == this.variable) {
                this.module.error("XQST0089", (Expression)this, "duplicate local variable " + this.score);
            }
            this.scoreDecl = moduleContext.defineLocalVariable(this.score, XQType.INTEGER, this);
            this.scoreDecl.storageType(XQType.DOUBLE, moduleContext);
        }
        return this;
    }

    public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
        return new Sequence(focus, evalContext);
    }

    public class Sequence
    extends VarClause.SingleDummy {
        XQValue current;
        int curPos;

        Sequence(Focus focus, EvalContext evalContext) {
            super(focus, evalContext);
            this.current = XQValue.empty;
        }

        public boolean next() throws EvaluationException {
            while (true) {
                if (this.current.next()) {
                    this.doNext();
                    return true;
                }
                if (!this.source.next()) {
                    return false;
                }
                this.current = ForClause.this.expr.eval(this.focus, this.context);
                this.curPos = 0;
            }
        }

        public boolean nextCollection() throws EvaluationException {
            while (true) {
                if (this.current.nextCollection()) {
                    this.doNext();
                    return true;
                }
                if (!this.source.next()) {
                    return false;
                }
                this.current = ForClause.this.expr.eval(this.focus, this.context);
                this.curPos = 0;
            }
        }

        private void doNext() throws EvaluationException {
            try {
                this.context.storeLocal(ForClause.this.varDecl.address, this.current, true, ForClause.this.declaredType);
            }
            catch (XQTypeException xQTypeException) {
                this.context.error("XPTY0004", (Expression)ForClause.this, "dynamic type mismatch on 'for' variable $" + ForClause.this.varDecl.name + ": expecting " + ForClause.this.declaredType);
            }
            ++this.curPos;
            if (ForClause.this.position != null) {
                this.context.storeLocalInteger(ForClause.this.posDecl.address, this.curPos);
            }
            if (ForClause.this.scoreDecl != null) {
                this.context.storeScore(ForClause.this.scoreDecl.address, this.current.getFulltextScore(null));
            }
        }

        public XQValue bornAgain() {
            Sequence sequence = new Sequence(this.focus, this.context);
            sequence.setSource(this.source.bornAgain());
            return sequence;
        }

        public double getFulltextScore(Item item) throws EvaluationException {
            if (item == null && this.isNode()) {
                item = this.getNode();
            }
            if (ForClause.this.scoreDecl != null) {
                return this.context.loadLocalDouble(ForClause.this.scoreDecl.address);
            }
            return this.current.getFulltextScore(item);
        }
    }
}

