/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.api.QizxException;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.XMLPushStreamBase;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.BooleanValue;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.impl.EmptyException;
import java.lang.reflect.Array;
import java.math.BigDecimal;

public abstract class Expression {
    public static final String ERRC_BADTYPE = "XPTY0004";
    public static final int WITHIN_SUBTREE = 1;
    public static final int WITHIN_NODE = 2;
    public static final int SAME_DEPTH = 4;
    public static final int DOCUMENT_ORDER = 8;
    public static final int UNORDERED = 16;
    public static final int CONSTANT = 32;
    public static final int NUMERIC = 64;
    public static final int UPDATING = 128;
    private static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    public ModuleContext module;
    public int offset;
    protected XQType type = XQType.ANY;

    public void dump(ExprDisplay exprDisplay) {
        Expression expression;
        exprDisplay.header(this);
        int n = 0;
        while ((expression = this.child(n)) != null) {
            exprDisplay.child(expression);
            ++n;
        }
    }

    public Expression atSamePlaceAs(Expression expression) {
        this.module = expression.module;
        this.offset = expression.offset;
        return this;
    }

    public static Expression[] addExpr(Expression[] expressionArray, Expression expression) {
        Expression[] expressionArray2 = (Expression[])Array.newInstance(expressionArray.getClass().getComponentType(), expressionArray.length + 1);
        System.arraycopy(expressionArray, 0, expressionArray2, 0, expressionArray.length);
        expressionArray2[expressionArray.length] = expression;
        return expressionArray2;
    }

    public Expression addChild(Expression expression, QName qName) {
        System.err.println("addChild not implemented in " + this.getClass());
        return null;
    }

    public void addAttribute(QName qName, String string) {
        System.err.println("addAttribute no implemented in " + this.getClass());
    }

    public void putCharacters(char[] cArray, int n, int n2) {
        int n3 = n2;
        while (--n3 >= 0 && XMLUtil.isXMLSpace(cArray[n + n3])) {
        }
        if (n3 < 0) {
            return;
        }
        System.err.println("putCharacters no implemented in " + this.getClass() + " |" + new String(cArray, n, n2) + "|");
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        return this;
    }

    public XQType getType() {
        return this.type;
    }

    public void setType(XQType xQType) {
        this.type = xQType;
    }

    public static final int combinedTypes(int n, int n2) {
        return (n << 4) + n2;
    }

    public static final int combinedTypes(XQItemType xQItemType, XQItemType xQItemType2) {
        return Expression.combinedTypes(xQItemType.quickCode(), xQItemType2.quickCode());
    }

    public Expression transfer(Function.Call call, Expression[] expressionArray) {
        call.args = expressionArray;
        call.module = this.module;
        call.offset = this.offset;
        return call;
    }

    public int getFlags() {
        return 0;
    }

    public boolean isConstant() {
        return (this.getFlags() & 0x20) != 0;
    }

    public boolean isUpdating() {
        return (this.getFlags() & 0x80) != 0;
    }

    public boolean isVacuous() {
        return false;
    }

    protected XQItem checkFocus(Focus focus, EvalContext evalContext) throws EvaluationException {
        if (focus == null || focus.currentItem() == null) {
            evalContext.error("XPDY0002", this, "no context item");
            return null;
        }
        return focus.currentItem();
    }

    public abstract Expression child(int var1);

    public Expression findSubExpression(Class clazz) {
        Finder finder = new Finder(clazz);
        finder.visit(this);
        return finder.found;
    }

    protected XQValue errorEmpty(EvalContext evalContext) throws EvaluationException {
        return evalContext.error(ERRC_BADTYPE, this, "empty sequence not allowed");
    }

    protected XQValue errorMoreThanOne(EvalContext evalContext) throws EvaluationException {
        return evalContext.error(ERRC_BADTYPE, this, "more than one item is not allowed");
    }

    protected XQValue dmError(EvalContext evalContext, DataModelException dataModelException) throws EvaluationException {
        evalContext.error(dataModelException.getErrorCode(), this, "Data model error: " + dataModelException.getMessage(), dataModelException);
        return null;
    }

    public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
        throw new EvaluationException(this.getClass() + " evaluation not implemented");
    }

    public boolean evalAsBoolean(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            XQValue xQValue = this.eval(focus, evalContext);
            if (!xQValue.next()) {
                this.errorEmpty(evalContext);
            }
            boolean bl = xQValue.getBoolean();
            if (xQValue.next()) {
                this.errorMoreThanOne(evalContext);
            }
            return bl;
        }
        catch (EmptyException emptyException) {
            this.errorEmpty(evalContext);
            return false;
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(this, xQTypeException);
            return false;
        }
    }

    public boolean evalEffectiveBooleanValue(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            XQValue xQValue = this.eval(focus, evalContext);
            if (!xQValue.next()) {
                return false;
            }
            XQItem xQItem = xQValue.getItem();
            if (xQItem.isNode()) {
                return true;
            }
            int n = xQItem.getItemType().quickCode();
            boolean bl = false;
            switch (n) {
                case 13: {
                    bl = xQItem.getBoolean();
                    break;
                }
                case 5: 
                case 6: 
                case 14: {
                    bl = !"".equals(xQItem.getString());
                    break;
                }
                case 3: 
                case 4: {
                    double d = xQItem.getDouble();
                    bl = d == d && d != 0.0;
                    break;
                }
                case 1: {
                    bl = xQItem.getInteger() != 0L;
                    break;
                }
                case 2: {
                    bl = xQItem.getDecimal().compareTo(ZERO) != 0;
                    break;
                }
                default: {
                    evalContext.error(Function.ERR_ARGTYPE, this, "invalid type for condition");
                }
            }
            if (xQValue.next()) {
                evalContext.error(Function.ERR_ARGTYPE, this, "several items in condition");
            }
            return bl;
        }
        catch (EmptyException emptyException) {
            return false;
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(this, xQTypeException);
            return false;
        }
    }

    public XQItem evalForPredicate(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            XQValue xQValue = this.eval(focus, evalContext);
            if (!xQValue.next()) {
                return null;
            }
            XQItem xQItem = xQValue.getItem();
            if (xQItem.isNode()) {
                return BooleanValue.TRUE;
            }
            int n = xQItem.getItemType().quickCode();
            switch (n) {
                case 13: {
                    break;
                }
                case 5: 
                case 6: 
                case 14: {
                    xQItem = "".equals(xQItem.getString()) ? null : BooleanValue.TRUE;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    evalContext.error(Function.ERR_ARGTYPE, this, "invalid type for condition");
                }
            }
            if (xQValue.next()) {
                evalContext.error(Function.ERR_ARGTYPE, this, "several items in condition");
            }
            return xQItem;
        }
        catch (EmptyException emptyException) {
            return null;
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(this, xQTypeException);
            return null;
        }
    }

    public long evalAsInteger(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            int n;
            XQValue xQValue = this.eval(focus, evalContext);
            if (!xQValue.next()) {
                this.errorEmpty(evalContext);
            }
            if ((n = xQValue.getItemType().quickCode()) != 1 && n != 5) {
                throw new XQTypeException(ERRC_BADTYPE, "expecting integer value");
            }
            long l = xQValue.getInteger();
            if (xQValue.next()) {
                this.errorMoreThanOne(evalContext);
            }
            return l;
        }
        catch (EmptyException emptyException) {
            this.errorEmpty(evalContext);
            return 0L;
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(this, xQTypeException);
            return 0L;
        }
    }

    public long evalAsOptInteger(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            XQValue xQValue = this.eval(focus, evalContext);
            if (!xQValue.next()) {
                throw EmptyException.instance();
            }
            int n = xQValue.getItemType().quickCode();
            if (n != 1 && n != 5) {
                throw new XQTypeException(ERRC_BADTYPE, "expecting integer value");
            }
            long l = xQValue.getInteger();
            if (xQValue.next()) {
                this.errorMoreThanOne(evalContext);
            }
            return l;
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(this, xQTypeException);
            return 0L;
        }
    }

    public float evalAsFloat(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            XQValue xQValue = this.eval(focus, evalContext);
            if (!xQValue.next()) {
                this.errorEmpty(evalContext);
            }
            float f = xQValue.getFloat();
            if (xQValue.next()) {
                this.errorMoreThanOne(evalContext);
            }
            return f;
        }
        catch (EmptyException emptyException) {
            this.errorEmpty(evalContext);
            return 0.0f;
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(this, xQTypeException);
            return 0.0f;
        }
    }

    public float evalAsOptFloat(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            XQValue xQValue = this.eval(focus, evalContext);
            if (!xQValue.next()) {
                throw EmptyException.instance();
            }
            float f = xQValue.getFloat();
            if (xQValue.next()) {
                this.errorMoreThanOne(evalContext);
            }
            return f;
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(this, xQTypeException);
            return 0.0f;
        }
    }

    public double evalAsDouble(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            XQValue xQValue = this.eval(focus, evalContext);
            if (!xQValue.next()) {
                this.errorEmpty(evalContext);
            }
            double d = xQValue.getDouble();
            if (xQValue.next()) {
                this.errorMoreThanOne(evalContext);
            }
            return d;
        }
        catch (EmptyException emptyException) {
            this.errorEmpty(evalContext);
            return 0.0;
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(this, xQTypeException);
            return 0.0;
        }
    }

    public double evalAsOptDouble(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            XQValue xQValue = this.eval(focus, evalContext);
            if (!xQValue.next()) {
                throw EmptyException.instance();
            }
            double d = xQValue.getDouble();
            if (xQValue.next()) {
                this.errorMoreThanOne(evalContext);
            }
            return d;
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(this, xQTypeException);
            return 0.0;
        }
    }

    public String evalAsString(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            int n;
            XQValue xQValue = this.eval(focus, evalContext);
            if (!xQValue.next()) {
                this.errorEmpty(evalContext);
            }
            if ((n = xQValue.getItemType().quickCode()) != 6 && n != 5) {
                throw new XQTypeException(ERRC_BADTYPE, "expecting string value");
            }
            String string = xQValue.getString();
            if (xQValue.next()) {
                this.errorMoreThanOne(evalContext);
            }
            return string;
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(xQTypeException.getErrorCode(), this, xQTypeException.getMessage());
            return null;
        }
    }

    public String evalAsOptString(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            XQValue xQValue = this.eval(focus, evalContext);
            if (!xQValue.next()) {
                return null;
            }
            int n = xQValue.getItemType().quickCode();
            if (n != 6 && n != 5 && n != 14) {
                throw new XQTypeException(ERRC_BADTYPE, "expecting string value");
            }
            String string = xQValue.getString();
            if (xQValue.next()) {
                this.errorMoreThanOne(evalContext);
            }
            return string;
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(xQTypeException.getErrorCode(), this, xQTypeException.getMessage());
            return null;
        }
    }

    public BasicNode evalAsNode(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            XQValue xQValue = this.eval(focus, evalContext);
            if (!xQValue.next()) {
                this.errorEmpty(evalContext);
            }
            BasicNode basicNode = xQValue.basicNode();
            if (xQValue.next()) {
                this.errorMoreThanOne(evalContext);
            }
            return basicNode;
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(this, xQTypeException);
            return null;
        }
    }

    public BasicNode evalAsOptNode(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            XQValue xQValue = this.eval(focus, evalContext);
            if (!xQValue.next()) {
                return null;
            }
            BasicNode basicNode = xQValue.basicNode();
            if (xQValue.next()) {
                this.errorMoreThanOne(evalContext);
            }
            return basicNode;
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(this, xQTypeException);
            return null;
        }
    }

    public XQItem evalAsItem(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            XQValue xQValue = this.eval(focus, evalContext);
            if (!xQValue.next()) {
                this.errorEmpty(evalContext);
            }
            XQItem xQItem = xQValue.getItem();
            if (xQValue.next()) {
                this.errorMoreThanOne(evalContext);
            }
            return xQItem;
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(this, xQTypeException);
            return null;
        }
    }

    public XQItem evalAsOptItem(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            XQValue xQValue = this.eval(focus, evalContext);
            if (!xQValue.next()) {
                return null;
            }
            XQItem xQItem = xQValue.getItem();
            if (xQValue.next()) {
                this.errorMoreThanOne(evalContext);
            }
            return xQItem;
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(this, xQTypeException);
            return null;
        }
    }

    public void evalAsEvents(XMLPushStreamBase xMLPushStreamBase, Focus focus, EvalContext evalContext) throws EvaluationException {
        XQValue xQValue = this.eval(focus, evalContext);
        try {
            while (xQValue.next()) {
                if (xQValue.isNode()) {
                    BasicNode basicNode = xQValue.basicNode();
                    xMLPushStreamBase.putNodeCopy(basicNode, evalContext.getStaticContext().getCopyNSMode());
                    continue;
                }
                xMLPushStreamBase.putAtomText(xQValue.getString());
            }
        }
        catch (QizxException qizxException) {
            evalContext.error(qizxException.getErrorCode(), this, "error in constructor: " + qizxException.getMessage());
        }
    }

    private static class Finder
    extends Visitor {
        Class searched;
        Expression found = null;

        Finder(Class clazz) {
            this.searched = clazz;
        }

        public boolean preTest(Expression expression) {
            if (expression.getClass().isAssignableFrom(this.searched)) {
                this.found = expression;
                return false;
            }
            return true;
        }
    }

    public static abstract class Visitor {
        Expression[] context = new Expression[16];
        int ctxPtr = 0;

        public abstract boolean preTest(Expression var1);

        public boolean postTest(Expression expression) {
            return true;
        }

        public boolean visit(Expression expression) {
            Object object;
            if (!this.preTest(expression)) {
                return false;
            }
            if (this.ctxPtr >= this.context.length) {
                object = this.context;
                this.context = new Expression[((Expression[])object).length * 2];
                System.arraycopy(object, 0, this.context, 0, ((Expression[])object).length);
            }
            this.context[this.ctxPtr++] = expression;
            object = null;
            int n = 0;
            while ((object = expression.child(n)) != null) {
                if (!this.visit((Expression)object)) {
                    --this.ctxPtr;
                    return false;
                }
                ++n;
            }
            --this.ctxPtr;
            return this.postTest(expression);
        }
    }
}

