/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.util.basic.Check;
import com.qizx.xdm.IQName;
import com.qizx.xquery.fn.Last;
import com.qizx.xquery.fn.Position;
import com.qizx.xquery.op.BasicStep;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.FilterExpr;
import com.qizx.xquery.op.ForClause;
import com.qizx.xquery.op.LocalVariable;
import com.qizx.xquery.op.NodeSortExpr;
import com.qizx.xquery.op.PathExpr;
import com.qizx.xquery.op.SelfStep;
import com.qizx.xquery.op.VarReference;

public abstract class Expr
extends Expression {
    public static boolean isDot(Expression expression) {
        if (expression instanceof SelfStep && ((SelfStep)expression).nodeTest == null) {
            return true;
        }
        return expression instanceof VarReference.Local && ((VarReference.Local)expression).decl == null;
    }

    public static boolean pathLike(Expression expression) {
        return expression instanceof PathExpr || expression instanceof FilterExpr || expression instanceof BasicStep || Expr.isDot(expression);
    }

    public static boolean positionalPredicate(Expression expression) {
        Check.nonNull(expression, "predicate");
        return expression instanceof FilterExpr.PosTest || expression.findSubExpression(Position.Exec.class) != null || expression.findSubExpression(Last.Exec.class) != null || expression.findSubExpression(SelfStep.class) != null;
    }

    static Expression addPredicate(Expression expression, Expression expression2) {
        if (expression instanceof NodeSortExpr) {
            NodeSortExpr nodeSortExpr = (NodeSortExpr)expression;
            nodeSortExpr.expr = Expr.addPredicate(nodeSortExpr.expr, expression2);
        } else if (expression instanceof PathExpr) {
            PathExpr pathExpr = (PathExpr)expression;
            int n = pathExpr.steps.length - 1;
            pathExpr.steps[n] = Expr.addPredicate(pathExpr.steps[n], expression2);
        } else {
            FilterExpr filterExpr = new FilterExpr(expression);
            filterExpr.addPredicate(expression2);
            expression = filterExpr;
        }
        return expression;
    }

    static boolean depends(Expression expression, LocalVariable localVariable) {
        return !new VarDependence(localVariable).visit(expression);
    }

    public static class VarReplacer
    extends Expression.Visitor {
        LocalVariable replaced;
        LocalVariable replacing;

        VarReplacer(LocalVariable localVariable, LocalVariable localVariable2) {
            this.replaced = localVariable;
            this.replacing = localVariable2;
        }

        public boolean preTest(Expression expression) {
            if (!(expression instanceof VarReference.Local)) {
                return true;
            }
            VarReference.Local local = (VarReference.Local)expression;
            if (local.decl == this.replaced) {
                local.decl = this.replacing;
                local.name = this.replacing != null ? this.replacing.name : IQName.get(".");
            }
            return true;
        }
    }

    public static class DottingVarFinder
    extends Expression.Visitor {
        LocalVariable var;
        boolean OK = false;

        DottingVarFinder(LocalVariable localVariable) {
            this.var = localVariable;
        }

        public boolean preTest(Expression expression) {
            if (!(expression instanceof VarReference.Local)) {
                return true;
            }
            VarReference.Local local = (VarReference.Local)expression;
            if (local.decl != this.var) {
                return true;
            }
            int n = this.ctxPtr;
            while (--n >= 0) {
                if (!(this.context[n] instanceof FilterExpr)) continue;
                this.OK = false;
                return false;
            }
            this.OK = true;
            return true;
        }
    }

    public static class VarDependence
    extends Expression.Visitor {
        LocalVariable var;

        VarDependence(LocalVariable localVariable) {
            this.var = localVariable;
        }

        public boolean preTest(Expression expression) {
            if (!(expression instanceof VarReference.Local)) {
                return true;
            }
            VarReference.Local local = (VarReference.Local)expression;
            return local.decl != this.var;
        }
    }

    public static class ForVarCollector
    extends Expression.Visitor {
        LocalVariable found;
        LocalVariable found2;

        public void reset() {
            this.found2 = null;
            this.found = null;
        }

        public boolean preTest(Expression expression) {
            if (!(expression instanceof VarReference.Local)) {
                return true;
            }
            VarReference.Local local = (VarReference.Local)expression;
            Expression expression2 = local.decl.owner;
            if (!(expression2 instanceof ForClause)) {
                return true;
            }
            if (this.found == null || this.found == local.decl) {
                this.found = local.decl;
                return true;
            }
            this.found2 = local.decl;
            return false;
        }
    }
}

