/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.SequenceType;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.op.Expression;

public class CastExpr
extends Expression {
    public Expression expr;
    public XQItemType targetType;
    protected boolean isOptional;

    public CastExpr(Expression expression, XQType xQType) {
        this.expr = expression;
        this.targetType = xQType.itemType();
        this.isOptional = xQType instanceof SequenceType;
    }

    public Expression child(int n) {
        return n == 0 ? this.expr : null;
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.property("targetType", this.targetType);
        exprDisplay.child("expr", this.expr);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        this.expr = moduleContext.staticCheck(this.expr, 0);
        if (this.targetType == XQType.ITEM || this.targetType == XQType.ATOM || this.targetType == XQType.NOTATION) {
            moduleContext.error("XPST0080", (Expression)this, "invalid cast target type");
        }
        this.type = this.targetType;
        return this;
    }

    public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
        XQValue xQValue;
        XQValue xQValue2 = this.expr.eval(focus, evalContext);
        if (!xQValue2.next()) {
            if (!this.isOptional) {
                evalContext.error("XPTY0004", (Expression)this, "empty sequence cannot be cast to type " + this.targetType);
            } else {
                return XQValue.empty;
            }
        }
        try {
            xQValue = this.targetType.cast(xQValue2, evalContext);
        }
        catch (XQTypeException xQTypeException) {
            return evalContext.error(this, xQTypeException);
        }
        if (xQValue2.next()) {
            evalContext.error("XPTY0004", (Expression)this, "singleton expected in cast");
        }
        return xQValue;
    }
}

