/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.CoreDataModel;
import com.qizx.xdm.IQName;
import com.qizx.xdm.XMLPushStreamBase;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQType;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.NamedConstructor;

public class AttributeConstructor
extends NamedConstructor {
    static final QName XMLNS = IQName.get("xmlns");
    public String value;
    public String prefix;

    public AttributeConstructor(Expression expression) {
        super(expression);
        this.type = XQType.ATTRIBUTE;
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.child("name", this.name);
        exprDisplay.children(this.contents);
    }

    public BasicNode evalAsNode(Focus focus, EvalContext evalContext) throws EvaluationException {
        QName qName = this.evalName(null, focus, evalContext);
        if (qName == XMLNS) {
            evalContext.error("XQDY0044", (Expression)this, "invalid name 'xmlns' for attribute");
        }
        CoreDataModel coreDataModel = new CoreDataModel(evalContext.getStaticContext().getBaseURI());
        CoreDataModel.Attribute attribute = coreDataModel.newAttribute(qName);
        this.evalContents(attribute, focus, evalContext);
        return attribute;
    }

    public void evalAsEvents(XMLPushStreamBase xMLPushStreamBase, Focus focus, EvalContext evalContext) throws EvaluationException {
        evalContext.at(this);
        QName qName = this.evalName(xMLPushStreamBase, focus, evalContext);
        if (qName == XMLNS) {
            evalContext.error("XQDY0044", (Expression)this, "invalid name 'xmlns' for attribute");
        }
        try {
            xMLPushStreamBase.putAttribute(qName, this.evalContents(focus, evalContext), null);
        }
        catch (DataModelException dataModelException) {
            this.dmError(evalContext, dataModelException);
        }
    }
}

