/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.impl;

import com.qizx.api.CompilationException;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xquery.ModuleContext;

public class NewLexer {
    public static final String ERR_SYNTAX = "XPST0003";
    public static final int INTEGER_LITERAL = 1;
    public static final int DECIMAL_LITERAL = 2;
    public static final int DOUBLE_LITERAL = 3;
    public static int debug = 0;
    protected ModuleContext currentModule;
    protected String source;
    protected int inputLength;
    protected char curChar;
    protected int curPtr;
    protected boolean allowComments;
    protected int tokenStart;
    protected int tokenEnd;
    protected int prevTokenLoc;
    private int lookaheadPos;
    private boolean skipSpace;
    protected StringBuilder saveBuffer = new StringBuilder();
    protected String savedPrefix;
    protected String savedName;
    protected int numberToken;
    protected boolean whiteSpace;

    public void startLexer(String string) {
        this.source = string;
        this.inputLength = string.length();
        this.tokenEnd = 0;
        this.next();
        if (debug > 0) {
            System.err.println("===== Start lexer");
        }
        this.skipSpace = true;
        this.allowComments = true;
    }

    protected void want(String string) throws CompilationException {
        if (!this.eat(string)) {
            this.errorExpect(string);
        }
    }

    protected boolean eat(String string) throws CompilationException {
        this.eatSpace();
        return this.eatNoSkip(string);
    }

    protected boolean eatNoSkip(String string) throws CompilationException {
        if (debug >= 2) {
            System.err.println("try pattern |" + string + "| at " + this.curPtr + " char " + this.curChar);
        }
        int n = this.curPtr - 1;
        if (!this.lookFor(string)) {
            this.curPtr = n;
            this.next();
            return false;
        }
        this.prevTokenLoc = this.tokenStart;
        this.tokenStart = n;
        this.tokenEnd = this.curPtr - 1;
        if (this.lookaheadPos >= 0) {
            this.tokenEnd = this.curPtr = this.lookaheadPos;
            this.next();
        }
        if (debug >= 1) {
            System.err.println("matched pattern |" + string + "| at " + this.tokenStart + "-" + this.tokenEnd);
        }
        return true;
    }

    protected boolean see(String string) throws CompilationException {
        int n = this.curPtr - 1;
        boolean bl = this.lookFor(string);
        this.curPtr = n;
        this.next();
        return bl;
    }

    private boolean lookFor(String string) throws CompilationException {
        this.lookaheadPos = -1;
        int n = 0;
        int n2 = string.length();
        block8: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (this.isKeyLetter((char)n) && this.isNameChar(this.curChar)) {
                    return false;
                }
                n = 32;
                this.eatSpace();
                continue;
            }
            if (c != '%') {
                if (c != this.curChar) {
                    if (debug >= 2) {
                        System.err.println(" fail at " + i + " on " + this.curChar);
                    }
                    return false;
                }
                n = c;
                this.next();
                continue;
            }
            c = string.charAt(++i);
            n = 32;
            switch (c) {
                case 'N': {
                    if (this.pickName()) continue block8;
                    return false;
                }
                case 'Q': {
                    if (this.eatQName()) continue block8;
                    return false;
                }
                case 'S': {
                    if (this.eatStringLiteral()) continue block8;
                    return false;
                }
                case 'u': {
                    if (this.eatNumber()) continue block8;
                    return false;
                }
                case '%': {
                    if (this.pick('%')) continue block8;
                    return false;
                }
                case '?': {
                    this.lookaheadPos = this.curPtr - 1;
                    continue block8;
                }
                default: {
                    this.lexicalError("bad lex metachar " + c);
                }
            }
        }
        return !this.isKeyLetter((char)n) || !this.isNameChar(this.curChar);
    }

    protected boolean eatXmlChars(char c) throws CompilationException {
        this.whiteSpace = true;
        this.saveBuffer.setLength(0);
        while (this.curChar != '\u0000' && this.curChar != '<' && this.curChar != '&' && this.curChar != c) {
            if (this.curChar == '{') {
                if (!this.eatRaw("{{")) break;
                this.save('{');
                this.whiteSpace = false;
                continue;
            }
            if (this.curChar == '}') {
                this.save('}');
                if (!this.eatRaw("}}")) {
                    this.syntax("'}' must be escaped by '}}'");
                }
                this.whiteSpace = false;
                continue;
            }
            if (this.whiteSpace && !Character.isWhitespace(this.curChar)) {
                this.whiteSpace = false;
            }
            this.save(this.curChar);
            this.next();
        }
        return this.saveBuffer.length() > 0;
    }

    protected boolean eatStringLiteral() throws CompilationException {
        if (this.curChar != '\"' && this.curChar != '\'') {
            return false;
        }
        this.saveBuffer.setLength(0);
        char c = this.curChar;
        this.next();
        while (true) {
            if (this.curChar == '\u0000') {
                this.lexicalError("unclosed string literal");
                return true;
            }
            if (this.curChar == c) {
                this.next();
                if (this.curChar != c) break;
                this.save(c);
            } else {
                if (this.curChar == '&') {
                    this.eatCharRef();
                    continue;
                }
                this.save(this.curChar);
            }
            this.next();
        }
        if (debug >= 1) {
            System.err.println("string literal |" + this.saveBuffer + "|");
        }
        return true;
    }

    protected void eatSpace() throws CompilationException {
        while (this.curPtr <= this.inputLength) {
            while (Character.isWhitespace(this.curChar)) {
                this.next();
            }
            if (!this.eatRaw("(:")) break;
            if (!this.allowComments) {
                this.lexicalError("comment not allowed here");
            }
            this.eatCommentTail();
        }
    }

    protected boolean eatCharRef() throws CompilationException {
        if (!this.pick('&')) {
            return false;
        }
        if (this.pick('#')) {
            int n = 0;
            if (this.pick('x')) {
                int n2;
                while ((n2 = Character.digit(this.curChar, 16)) >= 0) {
                    n = 16 * n + n2;
                    this.next();
                }
            } else {
                int n3;
                while ((n3 = Character.digit(this.curChar, 10)) >= 0) {
                    n = 10 * n + Character.digit(this.curChar, 10);
                    this.next();
                }
            }
            if (n > 0 && n < 65534) {
                this.save((char)n);
            } else if (XMLUtil.isSupplementalChar(n)) {
                this.save(XMLUtil.highSurrogate(n));
                this.save(XMLUtil.lowSurrogate(n));
            } else {
                this.lexicalError("invalid character reference #" + n);
            }
            if (!this.pick(';')) {
                this.lexicalError("character reference not terminated by semicolon");
            }
        } else if (this.eatRaw("lt;")) {
            this.save('<');
        } else if (this.eatRaw("gt;")) {
            this.save('>');
        } else if (this.eatRaw("amp;")) {
            this.save('&');
        } else if (this.eatRaw("quot;")) {
            this.save('\"');
        } else if (this.eatRaw("apos;")) {
            this.save('\'');
        } else {
            this.lexicalError("invalid character reference");
        }
        return true;
    }

    protected boolean eatNumber() throws CompilationException {
        this.saveBuffer.setLength(0);
        this.numberToken = 1;
        while (Character.isDigit(this.curChar)) {
            this.save(this.curChar);
            this.next();
        }
        if (this.curChar == '.') {
            this.save(this.curChar);
            this.next();
            while (Character.isDigit(this.curChar)) {
                this.save(this.curChar);
                this.next();
            }
            if (this.saveBuffer.length() == 1) {
                return false;
            }
            this.numberToken = 2;
        }
        if (this.saveBuffer.length() == 0) {
            return false;
        }
        if (this.curChar == 'e' || this.curChar == 'E') {
            this.save(this.curChar);
            this.next();
            if (this.curChar == '+' || this.curChar == '-') {
                this.save(this.curChar);
                this.next();
            }
            if (!Character.isDigit(this.curChar)) {
                this.lexicalError("expecting digits in exponent");
            }
            while (Character.isDigit(this.curChar)) {
                this.save(this.curChar);
                this.next();
            }
            this.numberToken = 3;
        }
        if (Character.isLetter(this.curChar)) {
            this.lexicalError("numeric literal must not be followed by name");
        }
        if (this.saveBuffer.length() == 1 && this.saveBuffer.charAt(0) == '.') {
            return false;
        }
        if (debug >= 1) {
            System.err.println("Lexer: number literal " + this.saveBuffer);
        }
        return true;
    }

    protected boolean eatPragma() throws CompilationException {
        this.eatSpace();
        if (!this.eatRaw("(#")) {
            return false;
        }
        while (Character.isWhitespace(this.curChar)) {
            this.next();
        }
        if (!this.eatQName()) {
            this.lexicalError("pragma should begin with a QName");
        }
        this.saveBuffer.setLength(0);
        while (true) {
            if (this.curChar == '\u0000') {
                this.lexicalError("unclosed pragma");
            } else if (this.eatRaw("#)")) break;
            this.save(this.curChar);
            this.next();
        }
        if (this.saveBuffer.length() > 0 && !Character.isWhitespace(this.saveBuffer.charAt(0))) {
            this.lexicalError("whitespace required before pragma content");
        }
        return true;
    }

    protected boolean eatPI() throws CompilationException {
        if (!this.eatRaw("<?")) {
            return false;
        }
        this.saveBuffer.setLength(0);
        while (true) {
            if (this.curChar != '?' && this.curChar != '\u0000') {
                this.save(this.curChar);
                this.next();
                continue;
            }
            if (this.curChar == '\u0000') {
                this.lexicalError("unterminated processing instruction");
            }
            if (this.eatRaw("?>")) break;
            this.save(this.curChar);
            this.next();
        }
        return true;
    }

    protected boolean eatXmlComment() throws CompilationException {
        if (!this.eatRaw("<!--")) {
            return false;
        }
        this.saveBuffer.setLength(0);
        while (true) {
            if (this.curChar != '-' && this.curChar != '\u0000') {
                this.save(this.curChar);
                this.next();
                continue;
            }
            if (this.curChar == '\u0000') {
                this.lexicalError("unterminated XML comment");
            }
            if (this.eatRaw("-->")) break;
            this.save(this.curChar);
            this.next();
        }
        return true;
    }

    protected boolean eatCDATASection() throws CompilationException {
        if (!this.eatRaw("<![CDATA[")) {
            return false;
        }
        this.saveBuffer.setLength(0);
        while (true) {
            if (this.curChar == '\u0000') {
                this.lexicalError("unclosed CDATA section");
            } else if (this.eatRaw("]]>")) break;
            this.save(this.curChar);
            this.next();
        }
        return true;
    }

    private void eatCommentTail() throws CompilationException {
        while (true) {
            if (this.curChar == '\u0000') {
                this.lexicalError("unclosed comment");
                continue;
            }
            if (this.eatRaw(":)")) break;
            if (this.eatRaw("(:")) {
                this.eatCommentTail();
                continue;
            }
            this.next();
        }
    }

    protected String extractStringToken() {
        return this.saveBuffer.toString();
    }

    protected String lastToken() {
        if (this.tokenStart >= this.inputLength) {
            return "end";
        }
        return this.source.substring(this.tokenStart, this.tokenEnd);
    }

    protected boolean eatQName() {
        if (!this.pickName()) {
            return false;
        }
        this.savedPrefix = "";
        if (this.pick(':')) {
            this.savedPrefix = this.savedName;
            if (!this.pickName()) {
                this.backChar();
                this.savedName = this.savedPrefix;
                this.savedPrefix = "";
                return true;
            }
        }
        if (debug >= 1) {
            System.err.println("QName " + this.savedPrefix + " : " + this.savedName);
        }
        return true;
    }

    private boolean pickName() {
        if (!this.isNameStart(this.curChar)) {
            return false;
        }
        this.saveBuffer.setLength(0);
        do {
            this.save(this.curChar);
            this.next();
        } while (this.curChar > ' ' && this.isNameChar(this.curChar));
        this.savedName = this.saveBuffer.toString();
        return true;
    }

    private boolean pick(char c) {
        if (this.curChar != c) {
            return false;
        }
        this.next();
        return true;
    }

    protected boolean eatRaw(String string) {
        if (this.curChar != string.charAt(0) || this.curPtr + string.length() - 1 > this.inputLength) {
            return false;
        }
        int n = this.curPtr;
        int n2 = string.length();
        while (--n2 >= 1) {
            if (this.source.charAt(this.curPtr + n2 - 1) == string.charAt(n2)) continue;
            this.curPtr = n - 1;
            this.next();
            return false;
        }
        this.curPtr += string.length() - 1;
        this.next();
        return true;
    }

    protected void setSkipSpace(boolean bl) {
        this.skipSpace = bl;
    }

    protected boolean atEndOfInput() throws CompilationException {
        if (this.curPtr <= this.inputLength) {
            this.eatSpace();
        }
        return this.curPtr >= this.inputLength && this.curChar == '\u0000';
    }

    private boolean isNameStart(char c) {
        return c == '_' || Character.isLetter(c);
    }

    private boolean isNameChar(char c) {
        return c == '.' || c == '-' || c != '\u0000' && Character.isUnicodeIdentifierPart(c);
    }

    private boolean isKeyLetter(char c) {
        return c >= 'a' && c <= 'z';
    }

    private int next() {
        if (this.curPtr < this.inputLength) {
            this.curChar = this.source.charAt(this.curPtr++);
        } else {
            this.curChar = '\u0000';
            this.curPtr = this.inputLength + 1;
        }
        return this.curChar;
    }

    protected int currentPos() {
        return this.curPtr - 1;
    }

    void backChar() {
        --this.curPtr;
        this.curChar = (char)(this.curPtr == 0 ? 10 : (int)this.source.charAt(this.curPtr - 1));
    }

    private void save(char c) {
        this.saveBuffer.append(c);
    }

    protected void errorExpect(String string) throws CompilationException {
        this.syntax("expecting " + string);
    }

    protected void syntax(String string) throws CompilationException {
        this.currentModule.error(ERR_SYNTAX, this.currentPos(), "syntax error, near '" + this.lastToken() + "' : " + string);
        throw new CompilationException("syntax error, " + string);
    }

    private boolean lexicalError(String string) throws CompilationException {
        String string2;
        String string3 = this.curChar == '\u0000' ? "<end-of-text>" : (string2 = this.curChar <= ' ' ? "#" + this.curChar : "'" + this.curChar + "'");
        if (this.currentModule != null) {
            this.currentModule.error(ERR_SYNTAX, this.curPtr - 1, "lexical error on character " + string2 + ": " + string);
        }
        throw new CompilationException(string + " " + string2);
    }
}

