/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.fn;

import com.qizx.api.EvaluationException;
import com.qizx.api.util.time.DateTime;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.impl.EmptyException;

public class MinutesFromDateTime
extends Function {
    static Prototype[] protos = new Prototype[]{Prototype.fn("minutes-from-dateTime", XQType.INTEGER.opt, Exec.class).arg("op", (XQType)XQType.DATE_TIME.opt)};

    public Prototype[] getProtos() {
        return protos;
    }

    public static class Exec
    extends Function.IntegerCall {
        public long evalAsInteger(Focus focus, EvalContext evalContext) throws EvaluationException {
            evalContext.at(this);
            XQItem xQItem = this.args[0].evalAsOptItem(focus, evalContext);
            if (xQItem == null) {
                throw EmptyException.instance();
            }
            switch (xQItem.getItemType().quickCode()) {
                case 8: {
                    return xQItem.getMoment().getMinute();
                }
                case 5: {
                    try {
                        DateTime dateTime = DateTime.parseDateTime(xQItem.getString());
                        return dateTime.getMinute();
                    }
                    catch (DateTimeException dateTimeException) {
                        evalContext.error(Conversion.ERR_CAST, this.args[0], "cannot cast to xs:dateTime: " + dateTimeException.getMessage());
                        return 0L;
                    }
                }
            }
            evalContext.invalidArgType(this.args[0], 0, xQItem.getType(), "dateTime");
            return 0L;
        }
    }
}

