/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.fn;

import com.qizx.api.CompilationException;
import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.util.basic.Util;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.CorePushBuilder;
import com.qizx.xdm.IQName;
import com.qizx.xdm.XMLPushStreamBase;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.SingleBoolean;
import com.qizx.xquery.dt.SingleDouble;
import com.qizx.xquery.dt.SingleFloat;
import com.qizx.xquery.dt.SingleInteger;
import com.qizx.xquery.dt.SingleNode;
import com.qizx.xquery.dt.SingleString;
import com.qizx.xquery.dt.WrappedObjectValue;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.impl.EmptyException;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.FunctionCall;
import java.text.Collator;

public abstract class Function {
    public static String ERR_ARGTYPE = "FORG0006";

    public Expression staticCheck(QName qName, ModuleContext moduleContext, Expression[] expressionArray, Expression expression) {
        return moduleContext.resolve(qName, this.getProtos(), expressionArray, expression);
    }

    public QName getName() {
        return this.getProtos()[0].qname;
    }

    public abstract Prototype[] getProtos();

    public static abstract class TreeCall
    extends Call {
        protected TreeCall() {
            this.type = XQType.NODE;
        }

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            BasicNode basicNode = this.evaluateAsNode(focus, evalContext);
            return basicNode == null ? XQValue.empty : new SingleNode(basicNode);
        }

        public BasicNode evaluateAsNode(Focus focus, EvalContext evalContext) throws EvaluationException {
            CorePushBuilder corePushBuilder = new CorePushBuilder(evalContext.getStaticContext().getBaseURI());
            this.evalAsEvents(corePushBuilder, focus, evalContext);
            return corePushBuilder.harvest();
        }

        public abstract void evalAsEvents(XMLPushStreamBase var1, Focus var2, EvalContext var3) throws EvaluationException;
    }

    public static abstract class OptStringCall
    extends Call {
        protected OptStringCall() {
            this.type = XQType.STRING.opt;
        }

        public abstract String evalAsOptString(Focus var1, EvalContext var2) throws EvaluationException;

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            String string = this.evalAsOptString(focus, evalContext);
            return string == null ? XQValue.empty : new SingleString(string);
        }

        public String evalAsString(Focus focus, EvalContext evalContext) throws EvaluationException {
            String string = this.evalAsOptString(focus, evalContext);
            if (string == null) {
                this.errorEmpty(evalContext);
            }
            return string;
        }
    }

    public static abstract class StringCall
    extends Call {
        protected StringCall() {
            this.type = XQType.STRING;
        }

        public abstract String evalAsString(Focus var1, EvalContext var2) throws EvaluationException;

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            return new SingleString(this.evalAsString(focus, evalContext));
        }
    }

    public static abstract class OptDoubleCall
    extends Call {
        protected OptDoubleCall() {
            this.type = XQType.DOUBLE.opt;
        }

        public abstract double evalAsOptDouble(Focus var1, EvalContext var2) throws EvaluationException;

        public double evalAsDouble(Focus focus, EvalContext evalContext) throws EvaluationException {
            try {
                return this.evalAsOptDouble(focus, evalContext);
            }
            catch (EmptyException emptyException) {
                this.errorEmpty(evalContext);
                return 0.0;
            }
        }

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            try {
                return new SingleDouble(this.evalAsOptDouble(focus, evalContext));
            }
            catch (EmptyException emptyException) {
                return XQValue.empty;
            }
        }
    }

    public static abstract class DoubleCall
    extends Call {
        protected DoubleCall() {
            this.type = XQType.DOUBLE;
        }

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            return new SingleDouble(this.evalAsDouble(focus, evalContext));
        }

        public abstract double evalAsDouble(Focus var1, EvalContext var2) throws EvaluationException;
    }

    public static abstract class OptFloatCall
    extends Call {
        public OptFloatCall() {
            this.type = XQType.FLOAT.opt;
        }

        public abstract float evalAsOptFloat(Focus var1, EvalContext var2) throws EvaluationException;

        public float evalAsFloat(Focus focus, EvalContext evalContext) throws EvaluationException {
            try {
                return this.evalAsOptFloat(focus, evalContext);
            }
            catch (EmptyException emptyException) {
                this.errorEmpty(evalContext);
                return 0.0f;
            }
        }

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            try {
                return new SingleFloat(this.evalAsFloat(focus, evalContext));
            }
            catch (EmptyException emptyException) {
                return XQValue.empty;
            }
        }
    }

    public static abstract class FloatCall
    extends Call {
        public FloatCall() {
            this.type = XQType.FLOAT.opt;
        }

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            return new SingleFloat(this.evalAsFloat(focus, evalContext));
        }

        public abstract float evalAsFloat(Focus var1, EvalContext var2) throws EvaluationException;
    }

    public static abstract class OptIntegerCall
    extends Call {
        public OptIntegerCall() {
            this.type = XQType.INTEGER.opt;
        }

        public abstract long evalAsOptInteger(Focus var1, EvalContext var2) throws EvaluationException;

        public long evalAsInteger(Focus focus, EvalContext evalContext) throws EvaluationException {
            try {
                return this.evalAsOptInteger(focus, evalContext);
            }
            catch (EmptyException emptyException) {
                this.errorEmpty(evalContext);
                return 0L;
            }
        }

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            try {
                return new SingleInteger(this.evalAsInteger(focus, evalContext));
            }
            catch (EmptyException emptyException) {
                return XQValue.empty;
            }
        }
    }

    public static abstract class IntegerCall
    extends Call {
        protected IntegerCall() {
            this.type = XQType.INTEGER;
        }

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            return new SingleInteger(this.evalAsInteger(focus, evalContext));
        }

        public abstract long evalAsInteger(Focus var1, EvalContext var2) throws EvaluationException;
    }

    public static abstract class NumericCall
    extends Call {
        public NumericCall() {
            this.type = XQType.NUMERIC.opt;
        }
    }

    public static abstract class BoolCall
    extends Call {
        protected BoolCall() {
            this.type = XQType.BOOLEAN;
        }

        public abstract boolean evalAsBoolean(Focus var1, EvalContext var2) throws EvaluationException;

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            return new SingleBoolean(this.evalAsBoolean(focus, evalContext));
        }

        public boolean evalAsEffectiveBoolean(Focus focus, EvalContext evalContext) throws EvaluationException {
            return this.evalAsBoolean(focus, evalContext);
        }
    }

    public static abstract class Call
    extends Expression {
        public Expression[] args;
        public Prototype prototype;

        public Expression child(int n) {
            return n < this.args.length ? this.args[n] : null;
        }

        public void dump(ExprDisplay exprDisplay) {
            if (this.prototype != null) {
                exprDisplay.header("function");
                exprDisplay.property("signature", this.prototype.toString(null));
            } else {
                exprDisplay.header("operator");
            }
            exprDisplay.property("rt", Util.shortClassName(this.getClass()));
            exprDisplay.headerInfo(this);
            exprDisplay.children(this.args);
        }

        public void compilationHook() {
        }

        public Object objArg(Expression[] expressionArray, int n, Class clazz, Focus focus, EvalContext evalContext) throws EvaluationException {
            try {
                XQItem xQItem = expressionArray[n].evalAsItem(focus, evalContext);
                Object object = null;
                if (!(xQItem instanceof WrappedObjectValue) || !clazz.isAssignableFrom((object = ((WrappedObjectValue)xQItem).getObject()).getClass())) {
                    String string = clazz.getName();
                    evalContext.error("XPTY0004", (Expression)this, "bad type for argument " + (n + 1) + ": expecting " + string.substring(string.lastIndexOf(46) + 1));
                }
                return object;
            }
            catch (EvaluationException evaluationException) {
                evalContext.error("XPTY0004", expressionArray[n], new EvaluationException("error on argument " + (n + 1) + ": " + evaluationException.getMessage(), evaluationException));
                return null;
            }
        }

        public Collator getCollator(Expression expression, Focus focus, EvalContext evalContext) throws EvaluationException {
            if (expression == null) {
                return evalContext.getCollator();
            }
            String string = expression.evalAsString(focus, evalContext);
            Collator collator = evalContext.getCollator(string);
            if (collator == null) {
                evalContext.error("FOCH0002", expression, "unknown collation: " + string);
            }
            return collator;
        }

        public static IQName toQName(String string, Node node, EvalContext evalContext) throws DataModelException {
            String string2 = IQName.extractPrefix(string);
            String string3 = IQName.extractLocalName(string);
            String string4 = node.getNamespaceUri(string2);
            if (string4 == null) {
                if (string2.length() == 0) {
                    string4 = "";
                } else if (evalContext != null && evalContext.getStaticContext() != null) {
                    string4 = evalContext.getStaticContext().getInScopeNS().getNamespaceURI(string2);
                }
            }
            if (string4 == null) {
                throw new DataModelException("undefined namespace prefix: " + string2);
            }
            return IQName.get(string4, string3);
        }

        protected Expression checkFunction(QName qName, Expression[] expressionArray, EvalContext evalContext) throws CompilationException {
            FunctionCall functionCall = new FunctionCall(qName, expressionArray);
            return evalContext.dynamicContext().checkExpression(functionCall);
        }
    }
}

