/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.ext;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.EvaluationStackTrace;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.util.XMLSerializer;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.CorePushBuilder;
import com.qizx.xdm.IQName;
import com.qizx.xdm.XMLPushStreamBase;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExpressionImpl;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.ArraySequence;
import com.qizx.xquery.ext.ExtensionFunction;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.op.Expression;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class XfnInteractiveEval
extends ExtensionFunction {
    static QName LENGTH_LIMIT = IQName.get("LENGTH_LIMIT");
    static QName SIZE_LIMIT = IQName.get("SIZE_LIMIT");
    static QName qfname = IQName.get(EXTENSION_NS, "interactive-eval");
    static Prototype[] protos = new Prototype[]{new Prototype(qfname, XQType.NODE.star, Exec.class).arg("query", (XQType)XQType.STRING).arg("options", (XQType)XQType.NODE.star), new Prototype(qfname, XQType.NODE.star, Exec.class).arg("query", (XQType)XQType.STRING)};

    public Prototype[] getProtos() {
        return protos;
    }

    private static String trimString(StringBuffer stringBuffer) {
        int n = 0;
        int n2 = stringBuffer.length();
        for (int i = 0; i < n2; ++i) {
            if (stringBuffer.charAt(i) == '\r') continue;
            stringBuffer.setCharAt(n++, stringBuffer.charAt(i));
        }
        return stringBuffer.substring(0, n);
    }

    public static class Exec
    extends Function.Call {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            Object object;
            Object object2;
            evalContext.at(this);
            String string = this.args[0].evalAsString(focus, evalContext);
            string = string.replace('\r', ' ');
            BasicNode basicNode = this.args.length < 2 ? null : this.args[1].evalAsOptNode(focus, evalContext);
            IQName iQName = IQName.get("pre");
            IQName iQName2 = IQName.get("pre");
            IQName iQName3 = IQName.get("class");
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            boolean bl = true;
            boolean bl2 = false;
            Node[] nodeArray = null;
            try {
                if (basicNode != null && (nodeArray = basicNode.getAttributes()) != null) {
                    for (int i = 0; i < nodeArray.length; ++i) {
                        object2 = nodeArray[i];
                        object = object2.getNodeName().getLocalPart();
                        if (((String)object).equals("escaped")) {
                            bl = object2.getStringValue().equals("true");
                            continue;
                        }
                        if (((String)object).equals("output-max")) {
                            n3 = Integer.parseInt(object2.getStringValue());
                            continue;
                        }
                        if (((String)object).equals("time-max")) {
                            n = Integer.parseInt(object2.getStringValue());
                            continue;
                        }
                        if (((String)object).equals("item-max")) {
                            n2 = Integer.parseInt(object2.getStringValue());
                            continue;
                        }
                        evalContext.error(Function.ERR_ARGTYPE, (Expression)this, "invalid option " + (String)object);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                evalContext.error(Function.ERR_ARGTYPE, (Expression)this, "invalid option value: " + numberFormatException.getMessage());
            }
            catch (DataModelException dataModelException) {
                evalContext.error(this, new EvaluationException(dataModelException.getMessage()));
            }
            StringWriter stringWriter = null;
            object2 = null;
            object = new CorePushBuilder(evalContext.getStaticContext().getBaseURI());
            ArraySequence arraySequence = new ArraySequence(4, null);
            try {
                stringWriter = new StringWriter();
                object2 = new PrintWriter(stringWriter);
                ExpressionImpl expressionImpl = evalContext.dynamicContext().compileExpression(string);
                if (n > 0) {
                    expressionImpl.setTimeOut(n);
                }
                if (n3 > 0) {
                    ((XMLPushStreamBase)object).setMaxVolume(n3);
                }
                try {
                    long l = System.currentTimeMillis();
                    XQValue xQValue = expressionImpl.rawEval();
                    int n4 = 0;
                    while (xQValue.next()) {
                        ++n4;
                    }
                    long l2 = System.currentTimeMillis();
                    ((CorePushBuilder)object).putElementStart(iQName);
                    ((CorePushBuilder)object).putAttribute(iQName3, "header", null);
                    ((CorePushBuilder)object).putText("Query executed in " + (l2 - l) + " milliseconds, returns ");
                    if (n4 == 0) {
                        ((CorePushBuilder)object).putText("empty sequence");
                    } else {
                        ((CorePushBuilder)object).putText(n4 + " item" + (n4 > 1 ? "s" : "") + ":");
                    }
                    ((CorePushBuilder)object).putElementEnd(iQName);
                    arraySequence.addItem(((CorePushBuilder)object).harvest());
                    XMLSerializer xMLSerializer = new XMLSerializer();
                    if (n3 > 0) {
                        xMLSerializer.setMaxVolume(n3);
                    }
                    xMLSerializer.setOption("omit-xml-declaration", "yes");
                    xMLSerializer.setOption("indent", "yes");
                    if (bl) {
                        ((CorePushBuilder)object).reset();
                        ((CorePushBuilder)object).putElementStart(iQName2);
                        ((CorePushBuilder)object).putAttribute(iQName3, "items", null);
                    }
                    xQValue = xQValue.bornAgain();
                    int n5 = 1;
                    while (xQValue.next()) {
                        if (n2 > 0 && n5 > n2) {
                            evalContext.error(LENGTH_LIMIT, (Expression)this, "too many items");
                        }
                        XQItem xQItem = xQValue.getItem();
                        Node node = null;
                        if (xQItem.isNode() && !bl && (node = xQItem.getNode()).getNodeNature() != 7) {
                            arraySequence.addItem((XQItem)((Object)node));
                        } else if (xQItem.isNode()) {
                            stringWriter = new StringWriter();
                            object2 = new PrintWriter(stringWriter);
                            xMLSerializer.setOutput((Writer)object2);
                            xMLSerializer.reset();
                            xMLSerializer.putNodeCopy(xQItem.getNode(), 0);
                            xMLSerializer.flush();
                            ((CorePushBuilder)object).putText(XfnInteractiveEval.trimString(stringWriter.getBuffer()));
                        } else {
                            ((XMLPushStreamBase)object).putAtomText(xQValue.getString());
                        }
                        ++n5;
                    }
                    if (bl) {
                        ((CorePushBuilder)object).putElementEnd(iQName2);
                        ((CorePushBuilder)object).flush();
                        arraySequence.addItem(((CorePushBuilder)object).harvest());
                    }
                }
                catch (EvaluationException evaluationException) {
                    QName qName = evaluationException.getErrorCode();
                    if (qName == EvaluationException.TIME_LIMIT || qName == LENGTH_LIMIT || qName == SIZE_LIMIT) {
                        if (bl) {
                            ((XMLPushStreamBase)object).setMaxVolume(-1);
                            arraySequence.addItem(((CorePushBuilder)object).harvest());
                        }
                        ((PrintWriter)object2).println("** limit reached: " + evaluationException.getMessage() + " **");
                    } else {
                        ((PrintWriter)object2).println("*** execution error: " + evaluationException.getMessage());
                        if (evaluationException.getCause() != null && bl2) {
                            ((PrintWriter)object2).println("  caused by: " + evaluationException.getCause());
                        }
                        EvaluationStackTrace[] evaluationStackTraceArray = evaluationException.getStack();
                        for (int i = 0; i < evaluationStackTraceArray.length; ++i) {
                            ((PrintWriter)object2).println(evaluationStackTraceArray[i].getSignature());
                        }
                    }
                    ((CorePushBuilder)object).putElementStart(iQName);
                    ((CorePushBuilder)object).putAttribute(iQName3, "runtime-error", null);
                    ((CorePushBuilder)object).putText(stringWriter.toString());
                    ((CorePushBuilder)object).putElementEnd(iQName);
                    arraySequence.addItem(((CorePushBuilder)object).harvest());
                }
            }
            catch (Exception exception) {
                try {
                    ((CorePushBuilder)object).putElementStart(iQName);
                    ((CorePushBuilder)object).putAttribute(iQName3, "error", null);
                    ((PrintWriter)object2).println("*** " + exception.getMessage());
                    ((PrintWriter)object2).flush();
                    ((CorePushBuilder)object).putText(stringWriter.toString());
                    ((CorePushBuilder)object).putElementEnd(iQName);
                    arraySequence.addItem(((CorePushBuilder)object).harvest());
                }
                catch (DataModelException dataModelException) {
                    evalContext.error("FOSE0000", (Expression)this, "serialization error: " + dataModelException.getMessage());
                }
            }
            return arraySequence;
        }
    }
}

