/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.ext;

import com.qizx.api.CompilationException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Message;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.QizxException;
import com.qizx.api.util.fulltext.FullTextSnippetExtractor;
import com.qizx.queries.FullText;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.IQName;
import com.qizx.xdm.XMLPushStreamBase;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQType;
import com.qizx.xquery.ext.ExtensionFunction;
import com.qizx.xquery.ext.FT_Contains;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.IntegerLiteral;
import com.qizx.xquery.op.NodeLiteral;
import com.qizx.xquery.op.StringLiteral;

public class FT_Snippet
extends ExtensionFunction {
    static QName qfname = IQName.get(FULLTEXT_EXT_NS, "snippet");
    static Prototype[] protos = new Prototype[]{new Prototype(qfname, XQType.NODE.opt, Exec.class).arg("node", (XQType)XQType.NODE).arg("query", (XQType)XQType.STRING).arg("options", (XQType)XQType.NODE.opt), new Prototype(qfname, XQType.BOOLEAN.opt, Exec.class).arg("node", (XQType)XQType.NODE).arg("query", (XQType)XQType.STRING)};

    public Prototype[] getProtos() {
        return protos;
    }

    public static class Exec
    extends Function.TreeCall {
        public void evalAsEvents(XMLPushStreamBase xMLPushStreamBase, Focus focus, EvalContext evalContext) throws EvaluationException {
            evalContext.at(this);
            ModuleContext moduleContext = evalContext.getStaticContext();
            FullText.Selection selection = FT_Contains.compileQueryArgument(this.args[1], focus, evalContext);
            BasicNode basicNode = this.args[0].evalAsNode(focus, evalContext);
            BasicNode basicNode2 = this.args.length < 3 ? null : this.args[2].evalAsOptNode(focus, evalContext);
            IQName iQName = IQName.get("snippet");
            IQName iQName2 = IQName.get("B");
            IQName iQName3 = null;
            String string = "fterm%";
            Expression expression = null;
            Expression[] expressionArray = null;
            FullTextSnippetExtractor fullTextSnippetExtractor = new FullTextSnippetExtractor(selection, moduleContext.getFulltextFactory());
            try {
                Object object;
                if (basicNode2 != null && (object = basicNode2.getAttributes()) != null) {
                    for (int i = 0; i < ((Node[])object).length; ++i) {
                        Node node = object[i];
                        String string2 = node.getNodeName().getLocalPart();
                        if (string2.equals("snippet")) {
                            iQName = Exec.toQName(node.getStringValue(), basicNode2, evalContext);
                            continue;
                        }
                        if (string2.equals("word-wrap")) {
                            iQName2 = Exec.toQName(node.getStringValue(), basicNode2, evalContext);
                            continue;
                        }
                        if (string2.equals("word-style")) {
                            iQName3 = Exec.toQName(node.getStringValue(), basicNode2, evalContext);
                            continue;
                        }
                        if (string2.equals("word-pattern")) {
                            string = node.getStringValue();
                            continue;
                        }
                        if (string2.equals("word-function")) {
                            IQName iQName4 = Exec.toQName(node.getStringValue(), basicNode2, evalContext);
                            expressionArray = new Expression[]{new StringLiteral("?"), new IntegerLiteral(0L), new NodeLiteral(null)};
                            expression = this.checkFunction(iQName4, expressionArray, evalContext);
                            continue;
                        }
                        if (string2.equals("length")) {
                            try {
                                int n = Integer.parseInt(node.getStringValue());
                                fullTextSnippetExtractor.setMaxSnippetSize(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                evalContext.error("XQFT0100", this.args[2], "invalid length");
                            }
                            continue;
                        }
                        if (!string2.equals("work-size")) continue;
                        try {
                            int n = Integer.parseInt(node.getStringValue());
                            fullTextSnippetExtractor.setMaxWorkSize(n);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            evalContext.error("XQFT0100", this.args[2], "invalid work-size");
                        }
                    }
                }
                fullTextSnippetExtractor.start(basicNode);
                xMLPushStreamBase.putElementStart(iQName);
                while (fullTextSnippetExtractor.moveToNextEvent() != -1) {
                    switch (fullTextSnippetExtractor.getCurrentEvent()) {
                        case 5: 
                        case 9: {
                            xMLPushStreamBase.putText(fullTextSnippetExtractor.getText());
                            break;
                        }
                        case 8: {
                            if (expression != null) {
                                expressionArray[0] = new StringLiteral(fullTextSnippetExtractor.getText());
                                expressionArray[1] = new IntegerLiteral(fullTextSnippetExtractor.getTermPosition());
                                expressionArray[2] = new NodeLiteral(fullTextSnippetExtractor.getCurrentNode());
                                basicNode = expression.evalAsOptNode(focus, evalContext);
                                xMLPushStreamBase.putNodeCopy(basicNode, 0);
                                break;
                            }
                            xMLPushStreamBase.putElementStart(iQName2);
                            if (iQName3 != null && string != null) {
                                object = Integer.toString(fullTextSnippetExtractor.getTermPosition());
                                xMLPushStreamBase.putAttribute(iQName3, string.replaceAll("%", (String)object), null);
                            }
                            xMLPushStreamBase.putText(fullTextSnippetExtractor.getText());
                            xMLPushStreamBase.putElementEnd(iQName2);
                        }
                    }
                }
                xMLPushStreamBase.putElementEnd(iQName);
            }
            catch (CompilationException compilationException) {
                Message[] messageArray = compilationException.getMessages();
                evalContext.error(compilationException.getErrorCode(), (Expression)this, "runtime eval " + messageArray[0]);
            }
            catch (QizxException qizxException) {
                evalContext.error(qizxException.getErrorCode(), (Expression)this, qizxException.getMessage());
            }
        }
    }
}

