/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.ext;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.api.fulltext.TextTokenizer;
import com.qizx.api.fulltext.Thesaurus;
import com.qizx.queries.FullText;
import com.qizx.queries.SimpleFullText;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.IQName;
import com.qizx.xquery.DynamicContext;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.SingleNode;
import com.qizx.xquery.ext.ExtensionFunction;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.FTContainsOp;

public class FT_Contains
extends ExtensionFunction {
    static QName qfname = IQName.get(FULLTEXT_EXT_NS, "contains");
    static Prototype[] protos = new Prototype[]{new Prototype(qfname, XQType.BOOLEAN.opt, Exec.class).arg("query", (XQType)XQType.STRING).arg("context", (XQType)XQType.NODE.star).arg("options", (XQType)XQType.ELEMENT), new Prototype(qfname, XQType.BOOLEAN.opt, Exec.class).arg("query", (XQType)XQType.STRING).arg("options", (XQType)XQType.ELEMENT), new Prototype(qfname, XQType.BOOLEAN.opt, Exec.class).arg("query", (XQType)XQType.STRING)};
    private static final QName FT_OPT_ERR = ModuleContext.xqueryErrorCode("FTDY0030");
    private static final QName OP_CASE = IQName.get("case");
    private static final QName OP_DIAC = IQName.get("diacritics");
    private static final QName OP_LANGUAGE = IQName.get("language");
    private static final QName OP_STEMMING = IQName.get("stemming");
    private static final QName OP_THESAURUS = IQName.get("thesaurus");
    private static final QName OP_REL = IQName.get("relationship");

    public Prototype[] getProtos() {
        return protos;
    }

    public static FullText.Selection compileQuery(String string, EvalContext evalContext) throws EvaluationException {
        DynamicContext dynamicContext = evalContext.dynamicContext();
        FullTextFactory fullTextFactory = dynamicContext.getFulltextFactory();
        FullText.MatchOptions matchOptions = dynamicContext.getDefaultFTOptions();
        TextTokenizer textTokenizer = fullTextFactory.getTokenizer(matchOptions.language);
        try {
            SimpleFullText simpleFullText = new SimpleFullText(textTokenizer);
            return simpleFullText.parseQuery(string, matchOptions);
        }
        catch (DataModelException dataModelException) {
            throw new EvaluationException(dataModelException.getErrorCode(), dataModelException.getMessage());
        }
    }

    public static void parseOptions(Focus focus, EvalContext evalContext, Expression expression, FullText.MatchOptions matchOptions) throws EvaluationException, DataModelException {
        BasicNode basicNode = expression.evalAsNode(focus, evalContext);
        FullTextFactory fullTextFactory = evalContext.dynamicContext().getFulltextFactory();
        Node[] nodeArray = basicNode.getAttributes();
        if (nodeArray != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                QName qName = nodeArray[i].getNodeName();
                String string = nodeArray[i].getStringValue();
                if (qName == OP_CASE) {
                    if ("insensitive".startsWith(string)) {
                        matchOptions.caseSensitivity = (byte)2;
                        continue;
                    }
                    if ("sensitive".startsWith(string)) {
                        matchOptions.caseSensitivity = 1;
                        continue;
                    }
                    evalContext.error(FT_OPT_ERR, expression, "invalid value of option 'case'");
                    continue;
                }
                if (qName == OP_DIAC) {
                    if ("insensitive".startsWith(string)) {
                        matchOptions.diacritics = (byte)2;
                        continue;
                    }
                    if ("sensitive".startsWith(string)) {
                        matchOptions.diacritics = 1;
                        continue;
                    }
                    evalContext.error(FT_OPT_ERR, expression, "invalid value of option 'diacritics'");
                    continue;
                }
                if (qName == OP_LANGUAGE) {
                    matchOptions.language = string;
                    continue;
                }
                if (qName == OP_STEMMING) {
                    if ("true".equalsIgnoreCase(string)) {
                        matchOptions.stemming = 1;
                        continue;
                    }
                    if ("false".equalsIgnoreCase(string)) {
                        matchOptions.stemming = (byte)2;
                        continue;
                    }
                    evalContext.error(FT_OPT_ERR, expression, "invalid value of option 'stemming'");
                    continue;
                }
                if (qName == OP_THESAURUS) {
                    Thesaurus thesaurus = fullTextFactory.getThesaurus(string, matchOptions.language, null, 0, Integer.MAX_VALUE);
                    if (thesaurus == null) {
                        evalContext.error(FT_OPT_ERR, expression, "unknown thesaurus '" + string + "'");
                    }
                    matchOptions.addThesaurus(thesaurus);
                    continue;
                }
                evalContext.error(FT_OPT_ERR, expression, "unknown option " + qName);
            }
        }
    }

    public static FullText.Selection compileQueryArgument(Expression expression, Focus focus, EvalContext evalContext) throws EvaluationException {
        ModuleContext moduleContext = evalContext.getStaticContext();
        FullText.Selection selection = null;
        if (expression instanceof FTContainsOp) {
            FTContainsOp fTContainsOp = (FTContainsOp)expression;
            selection = fTContainsOp.expandSelection(focus, evalContext, moduleContext.getDefaultFTOptions(), 1.0f);
        } else if (expression instanceof Exec) {
            Exec exec = (Exec)expression;
            String string = exec.args[0].evalAsString(focus, evalContext);
            selection = FT_Contains.compileQuery(string, evalContext);
            if (exec.args.length > 1) {
                Expression expression2 = exec.args[exec.args.length - 1];
                try {
                    FT_Contains.parseOptions(focus, evalContext, expression2, selection.getMatchOptions());
                }
                catch (DataModelException dataModelException) {
                    evalContext.error(dataModelException.getErrorCode(), expression, dataModelException.getMessage());
                }
            }
        } else if (XQType.STRING.isSuperType(expression.getType().itemType())) {
            String string = expression.evalAsString(focus, evalContext);
            selection = FT_Contains.compileQuery(string, evalContext);
        } else {
            evalContext.error("XQFT0100", expression, "expecting either operator ftcontains or function ft:contains, or string representing a simplified full-text query");
        }
        if (selection != null) {
            selection = selection.applyThesauri();
        } else {
            System.err.println("OOPS null expanded query in ftcontains");
        }
        return selection;
    }

    public static class Exec
    extends Function.BoolCall {
        boolean isConstant;
        FullText.Selection cachedQuery;

        public void compilationHook() {
            Expression expression = this.args[0];
            Expression expression2 = this.args[this.args.length - 1];
            if (expression.isConstant() && (this.args.length < 2 || expression2.isConstant())) {
                this.isConstant = true;
            }
        }

        public synchronized FullText.Selection prepareQuery(Focus focus, EvalContext evalContext) throws EvaluationException {
            if (this.cachedQuery != null) {
                return this.cachedQuery;
            }
            try {
                String string = this.args[0].evalAsString(focus, evalContext);
                FullText.Selection selection = FT_Contains.compileQuery(string, evalContext);
                if (this.args.length > 1) {
                    Expression expression = this.args[this.args.length - 1];
                    FT_Contains.parseOptions(focus, evalContext, expression, selection.getMatchOptions());
                }
                if (this.isConstant) {
                    this.cachedQuery = selection;
                }
                return selection;
            }
            catch (DataModelException dataModelException) {
                evalContext.error(dataModelException.getErrorCode(), (Expression)this, dataModelException.getMessage());
                return null;
            }
        }

        public boolean evalAsBoolean(Focus focus, EvalContext evalContext) throws EvaluationException {
            FullText.Selection selection = this.prepareQuery(focus, evalContext);
            FullTextFactory fullTextFactory = evalContext.dynamicContext().getFulltextFactory();
            try {
                if (this.args.length == 3) {
                    XQValue xQValue = this.args[1].eval(focus, evalContext);
                    return selection.matches(xQValue, null, fullTextFactory);
                }
                XQItem xQItem = this.checkFocus(focus, evalContext);
                return selection.matches(new SingleNode(xQItem.basicNode()), null, fullTextFactory);
            }
            catch (DataModelException dataModelException) {
                this.dmError(evalContext, dataModelException);
                return false;
            }
        }
    }
}

