/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.GenericValue;
import com.qizx.xquery.dt.SingleString;

public class StringArraySequence
extends GenericValue {
    protected String[] items;
    protected int size;
    protected int index = -1;

    public StringArraySequence(String[] stringArray, int n) {
        this.items = stringArray;
        this.size = n;
    }

    public boolean next() throws EvaluationException {
        if (++this.index >= this.size) {
            return false;
        }
        this.item = new SingleString(this.items[this.index]);
        return true;
    }

    public XQItem quickIndex(long l) {
        return l <= 0L || l > (long)this.size ? null : new SingleString(this.items[(int)l - 1]);
    }

    public XQValue bornAgain() {
        return new StringArraySequence(this.items, this.size);
    }

    public static String[] expand(XQValue xQValue, boolean bl) throws EvaluationException {
        String[] stringArray;
        String[] stringArray2 = new String[8];
        int n = 0;
        while (xQValue.next()) {
            int n2;
            if (n >= stringArray2.length) {
                stringArray = stringArray2;
                stringArray2 = new String[stringArray.length * 2];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            }
            if (bl && 6 != (n2 = xQValue.getItemType().quickCode()) && n2 != 5) {
                throw new XQTypeException("expecting string");
            }
            stringArray2[n++] = xQValue.getString();
        }
        stringArray = new String[n];
        System.arraycopy(stringArray2, 0, stringArray, 0, n);
        return stringArray;
    }
}

