/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.GenericValue;
import com.qizx.xquery.dt.JavaMapping;
import com.qizx.xquery.dt.WrappedObjectType;
import com.qizx.xquery.dt.WrappedObjectValue;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

public class ObjectArraySequence
extends GenericValue {
    protected Object[] items;
    protected int size;
    protected int index = -1;

    public ObjectArraySequence(Object[] objectArray, int n, XQItemType xQItemType) {
        this.items = objectArray;
        this.size = n;
        this.itemType = xQItemType;
    }

    public ObjectArraySequence(Collection collection, XQItemType xQItemType) {
        this(collection.iterator(), xQItemType);
    }

    public ObjectArraySequence(Iterator iterator, XQItemType xQItemType) {
        Object[] objectArray = new Object[4];
        int n = 0;
        while (iterator.hasNext()) {
            if (n >= objectArray.length) {
                Object[] objectArray2 = objectArray;
                objectArray = new Object[objectArray2.length + 1 + objectArray2.length / 2];
                System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            }
            objectArray[n++] = iterator.next();
        }
        this.items = objectArray;
        this.size = n;
        this.itemType = xQItemType;
    }

    public ObjectArraySequence(Enumeration enumeration, XQItemType xQItemType) {
        Object[] objectArray = new Object[4];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            if (n >= objectArray.length) {
                Object[] objectArray2 = objectArray;
                objectArray = new Object[objectArray2.length * 2];
                System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            }
            objectArray[n++] = enumeration.nextElement();
        }
        this.items = objectArray;
        this.size = n;
        this.itemType = xQItemType;
    }

    public boolean next() throws EvaluationException {
        do {
            if (++this.index >= this.size) {
                return false;
            }
            this.item = JavaMapping.convertToItem(this.items[this.index], this.itemType);
        } while (this.item == null);
        return true;
    }

    public XQValue bornAgain() {
        return new ObjectArraySequence(this.items, this.size, this.itemType);
    }

    private static Object[] newArray(Class clazz, int n) {
        return clazz == null ? new Object[n] : (Object[])Array.newInstance(clazz, n);
    }

    public static Object[] expand(XQValue xQValue, Class clazz) throws EvaluationException {
        Object[] objectArray;
        Object[] objectArray2 = ObjectArraySequence.newArray(clazz, 8);
        int n = 0;
        while (xQValue.next()) {
            if (n >= objectArray2.length) {
                objectArray = objectArray2;
                objectArray2 = ObjectArraySequence.newArray(clazz, objectArray.length * 2);
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            }
            objectArray = xQValue.getItemType();
            Object object = null;
            object = objectArray == XQType.STRING ? xQValue.getString() : (objectArray instanceof WrappedObjectType ? ((WrappedObjectValue)xQValue.getItem()).getObject() : xQValue.getItem());
            try {
                objectArray2[n++] = object;
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new XQTypeException("bad item type: " + objectArray + ", in Java array[" + clazz + "]");
            }
        }
        if (n == objectArray2.length) {
            return objectArray2;
        }
        objectArray = ObjectArraySequence.newArray(clazz, n);
        System.arraycopy(objectArray2, 0, objectArray, 0, n);
        return objectArray;
    }
}

