/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.QizxException;
import com.qizx.api.util.time.DateTimeBase;
import com.qizx.xquery.BaseValue;
import com.qizx.xquery.ComparisonContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQTypeException;

public abstract class MomentValue
extends BaseValue {
    public abstract DateTimeBase getValue();

    public XQItem getItem() {
        return this;
    }

    public String getString() throws XQTypeException {
        return this.getValue().toString();
    }

    public double getDouble() throws EvaluationException {
        DateTimeBase dateTimeBase = this.getValue();
        return (double)dateTimeBase.getMillisecondsFromEpoch() / 1000.0;
    }

    public float getFloat() throws EvaluationException {
        return (float)this.getDouble();
    }

    public DateTimeBase getMoment() throws EvaluationException {
        return this.getValue();
    }

    public Object getObject() throws QizxException {
        return this.getValue();
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MomentValue)) {
            return false;
        }
        return this.getValue().equals(((MomentValue)object).getValue());
    }

    public int compareTo(XQItem xQItem, ComparisonContext comparisonContext, int n) throws EvaluationException {
        XQItemType xQItemType = xQItem.getItemType();
        if (xQItemType.quickCode() == 5) {
            xQItem = this.getItemType().cast(xQItem, null);
        } else if (this.getType() != xQItemType) {
            return 2;
        }
        return this.getValue().compareTo(xQItem.getMoment());
    }
}

