/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.Item;
import com.qizx.api.Node;
import com.qizx.xdm.IQName;
import com.qizx.xdm.XQName;
import com.qizx.xquery.SequenceType;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.DomNodeType;
import com.qizx.xquery.dt.WrappedObjectType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class JavaMapping {
    static HashMap classToType = new HashMap();
    static ArrayList abstractTypes = new ArrayList();

    private static void classToType(Class clazz, XQType xQType) {
        classToType.put(clazz.getName(), xQType);
    }

    private static void mapAbstractClass(Class clazz, XQType xQType) {
        JavaMapping.classToType(clazz, xQType);
        abstractTypes.add(clazz);
    }

    public static XQItemType getItemType(Class clazz) {
        String string = clazz.getName();
        SequenceType sequenceType = (SequenceType)classToType.get(string);
        if (sequenceType == null) {
            return new WrappedObjectType(clazz);
        }
        return (XQItemType)sequenceType.getItemType();
    }

    public static XQItemType matchingItemType(Class clazz) {
        SequenceType sequenceType = JavaMapping.matchingType(clazz);
        if (sequenceType != null) {
            return (XQItemType)sequenceType.getItemType();
        }
        return XQType.WRAPPED_OBJECT;
    }

    public static SequenceType matchingType(Class clazz) {
        String string = clazz.getName();
        SequenceType sequenceType = (SequenceType)classToType.get(string);
        if (sequenceType == null) {
            int n = abstractTypes.size();
            for (int i = 0; i < n; ++i) {
                Class clazz2 = (Class)abstractTypes.get(i);
                if (!clazz2.isAssignableFrom(clazz)) continue;
                sequenceType = (SequenceType)classToType.get(clazz2.getName());
                break;
            }
        }
        return sequenceType;
    }

    public static SequenceType getSequenceType(Class clazz) {
        SequenceType sequenceType = JavaMapping.matchingType(clazz);
        if (sequenceType != null) {
            return sequenceType;
        }
        if (clazz.isArray()) {
            XQItemType xQItemType = JavaMapping.getItemType(clazz.getComponentType());
            if (xQItemType == null) {
                xQItemType = XQType.ITEM;
            }
            return xQItemType.star;
        }
        if (Iterator.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz) || Enumeration.class.isAssignableFrom(clazz)) {
            return XQType.ITEM.star;
        }
        return XQType.WRAPPED_OBJECT.opt;
    }

    public static XQItem convertToItem(Object object, XQItemType xQItemType) throws XQTypeException {
        if (object == null) {
            return null;
        }
        if (xQItemType == null || xQItemType.equals(XQType.ANY) || xQItemType.equals(XQType.ITEM) || xQItemType.equals(XQType.ANY_ATOMIC_TYPE)) {
            xQItemType = JavaMapping.matchingItemType(object.getClass());
        }
        return xQItemType.convertFromObject(object);
    }

    public static XQValue convertToSequence(Object object, SequenceType sequenceType) throws XQTypeException {
        if (object == null) {
            return XQValue.empty;
        }
        if (sequenceType == null) {
            sequenceType = JavaMapping.getSequenceType(object.getClass());
        }
        return sequenceType.itemType().convertFromArray(object);
    }

    public static boolean isSequence(Object object) {
        if (object == null) {
            return false;
        }
        SequenceType sequenceType = JavaMapping.getSequenceType(object.getClass());
        return sequenceType != null && XQType.isRepeatable(sequenceType.getOccurrence());
    }

    static {
        JavaMapping.classToType(Void.TYPE, XQType.NONE.opt);
        JavaMapping.classToType(String.class, XQType.STRING.opt);
        JavaMapping.classToType(Boolean.TYPE, XQType.BOOLEAN.one);
        JavaMapping.classToType(Boolean.class, XQType.BOOLEAN.one);
        JavaMapping.classToType(Double.TYPE, XQType.DOUBLE.one);
        JavaMapping.classToType(Double.class, XQType.DOUBLE.one);
        JavaMapping.classToType(Float.TYPE, XQType.FLOAT.one);
        JavaMapping.classToType(Float.class, XQType.FLOAT.one);
        JavaMapping.classToType(BigDecimal.class, XQType.DECIMAL.opt);
        JavaMapping.classToType(BigInteger.class, XQType.DECIMAL.opt);
        JavaMapping.classToType(Long.TYPE, XQType.INTEGER.one);
        JavaMapping.classToType(Long.class, XQType.INTEGER.one);
        JavaMapping.classToType(Integer.class, XQType.INT.one);
        JavaMapping.classToType(Integer.TYPE, XQType.INT.one);
        JavaMapping.classToType(Short.TYPE, XQType.SHORT.one);
        JavaMapping.classToType(Short.class, XQType.SHORT.one);
        JavaMapping.classToType(Byte.TYPE, XQType.BYTE.one);
        JavaMapping.classToType(Byte.class, XQType.BYTE.one);
        JavaMapping.classToType(Character.TYPE, XQType.CHAR.one);
        JavaMapping.classToType(Character.class, XQType.CHAR.one);
        JavaMapping.classToType(Date.class, XQType.DATE_TIME.opt);
        JavaMapping.classToType(Calendar.class, XQType.DATE_TIME.opt);
        JavaMapping.classToType(IQName.class, XQType.QNAME.one);
        JavaMapping.classToType(XQName.class, XQType.QNAME.one);
        JavaMapping.mapAbstractClass(Node.class, XQType.NODE.opt);
        JavaMapping.mapAbstractClass(XQValue.class, XQType.ANY);
        DomNodeType domNodeType = new DomNodeType(null);
        JavaMapping.mapAbstractClass(org.w3c.dom.Node.class, new SequenceType(domNodeType, 0));
        JavaMapping.classToType(String[].class, XQType.STRING.star);
        JavaMapping.classToType(Item[].class, XQType.ITEM.star);
        JavaMapping.classToType(boolean[].class, XQType.BOOLEAN.star);
        JavaMapping.classToType(double[].class, XQType.DOUBLE.star);
        JavaMapping.classToType(float[].class, XQType.FLOAT.star);
        JavaMapping.classToType(long[].class, XQType.INTEGER.star);
        JavaMapping.classToType(int[].class, XQType.INT.star);
        JavaMapping.classToType(short[].class, XQType.SHORT.star);
        JavaMapping.classToType(byte[].class, XQType.BYTE.star);
        JavaMapping.classToType(char[].class, XQType.INTEGER.star);
        JavaMapping.mapAbstractClass(Node[].class, XQType.NODE.star);
        JavaMapping.mapAbstractClass(org.w3c.dom.Node[].class, new SequenceType(domNodeType, 2));
        JavaMapping.mapAbstractClass(Collection.class, XQType.ITEM.star);
        JavaMapping.mapAbstractClass(Iterator.class, XQType.ITEM.star);
        JavaMapping.mapAbstractClass(Enumeration.class, XQType.ITEM.star);
        JavaMapping.mapAbstractClass(Vector.class, XQType.ITEM.star);
        JavaMapping.mapAbstractClass(ArrayList.class, XQType.ITEM.star);
    }
}

