/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.QizxException;
import com.qizx.util.basic.Util;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.BaseValue;
import com.qizx.xquery.ComparisonContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.dt.IntegerType;
import com.qizx.xquery.dt.SingleInteger;
import java.math.BigDecimal;

public abstract class IntegerValue
extends BaseValue {
    public IntegerValue() {
        this.itemType = XQType.INTEGER;
    }

    public XQItem getItem() {
        return new SingleInteger(this.getValue(), this.itemType);
    }

    protected abstract long getValue();

    public boolean getBoolean() throws EvaluationException {
        return this.getInteger() != 0L;
    }

    public double getDouble() throws EvaluationException {
        return this.getInteger();
    }

    public float getFloat() throws EvaluationException {
        return this.getInteger();
    }

    public String getString() throws EvaluationException {
        return Conversion.toString(this.getInteger());
    }

    public Object getObject() throws QizxException {
        return ((IntegerType)this.itemType).convertToObject(this.getValue());
    }

    public boolean equals(Object object) {
        if (!(object instanceof XQItem)) {
            return false;
        }
        try {
            return this.getInteger() == ((XQItem)object).getInteger();
        }
        catch (EvaluationException evaluationException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return Util.hashDouble(this.getInteger());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int compareTo(XQItem xQItem, ComparisonContext comparisonContext, int n) throws EvaluationException {
        switch (xQItem.getItemType().quickCode()) {
            case 5: {
                if ((n & 2) != 0) {
                    return 2;
                }
            }
            case 3: 
            case 4: {
                if (comparisonContext == null || (n & 2) != 0) {
                    return IntegerValue.compare(this.getDouble(), xQItem.getDouble());
                }
                return IntegerValue.compare(this.getDouble(), xQItem.getDouble(), comparisonContext.emptyGreatest());
            }
            case 2: {
                return BigDecimal.valueOf(this.getInteger()).compareTo(xQItem.getDecimal());
            }
            case 1: {
                return IntegerValue.compare(this.getInteger(), xQItem.getInteger());
            }
        }
        return 2;
    }
}

