/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.GenericValue;
import com.qizx.xquery.dt.SingleFloat;

public class FloatArraySequence
extends GenericValue {
    protected float[] items;
    protected int size;
    protected int index = -1;

    public FloatArraySequence(float[] fArray, int n) {
        this.items = fArray;
        this.size = n;
    }

    public boolean next() throws EvaluationException {
        if (++this.index >= this.size) {
            return false;
        }
        this.item = new SingleFloat(this.items[this.index]);
        return true;
    }

    public XQItem quickIndex(long l) {
        return l <= 0L || l > (long)this.size ? null : new SingleFloat(this.items[(int)l - 1]);
    }

    public XQValue bornAgain() {
        return new FloatArraySequence(this.items, this.size);
    }

    static float[] unroll(XQValue xQValue) throws EvaluationException {
        float[] fArray = new float[8];
        int n = 1;
        while (xQValue.next()) {
            if (n >= fArray.length) {
                float[] fArray2 = fArray;
                fArray = new float[fArray2.length * 2];
                System.arraycopy(fArray2, 0, fArray, 0, fArray2.length);
            }
            fArray[n++] = xQValue.getFloat();
        }
        fArray[0] = n - 1;
        return fArray;
    }

    public static float[] expandFloats(XQValue xQValue) throws EvaluationException {
        float[] fArray = FloatArraySequence.unroll(xQValue);
        int n = (int)fArray[0];
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray2[i] = fArray[i + 1];
        }
        return fArray2;
    }
}

