/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.api.util.time.Duration;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.AtomicType;
import com.qizx.xquery.dt.SingleDuration;
import com.qizx.xquery.dt.StringType;

public class DurationType
extends AtomicType {
    public String getShortName() {
        return "duration";
    }

    public int quickCode() {
        return 12;
    }

    public XQValue cast(XQItem xQItem, EvalContext evalContext) throws EvaluationException {
        XQItemType xQItemType = xQItem.getItemType();
        Duration duration = null;
        try {
            if (xQItemType instanceof StringType) {
                duration = Duration.parseDuration(xQItem.getString().trim());
            } else if (xQItemType instanceof DurationType) {
                duration = xQItem.getDuration();
            } else {
                this.invalidCast(xQItemType);
            }
        }
        catch (DateTimeException dateTimeException) {
            this.castException(dateTimeException);
        }
        return new SingleDuration(duration, XQType.DURATION);
    }
}

