/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.DecimalValue;
import com.qizx.xquery.dt.NumericType;
import com.qizx.xquery.dt.SingleDecimal;
import com.qizx.xquery.op.Expression;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DecimalType
extends NumericType {
    public String getShortName() {
        return "decimal";
    }

    public int quickCode() {
        return 2;
    }

    public XQValue cast(XQItem xQItem, EvalContext evalContext) throws EvaluationException {
        XQItemType xQItemType = xQItem.getItemType();
        BigDecimal bigDecimal = null;
        switch (xQItemType.quickCode()) {
            case 5: 
            case 6: {
                bigDecimal = Conversion.toDecimal(xQItem.getString().trim(), false);
                break;
            }
            case 2: {
                bigDecimal = xQItem.getDecimal();
                break;
            }
            case 1: {
                bigDecimal = BigDecimal.valueOf(xQItem.getInteger());
                break;
            }
            case 3: 
            case 4: {
                double d = xQItem.getDouble();
                if (d != d || Double.isInfinite(d)) {
                    throw new XQTypeException("infinite or NaN value");
                }
                bigDecimal = new BigDecimal(d);
                break;
            }
            case 13: {
                bigDecimal = BigDecimal.valueOf(xQItem.getBoolean() ? 1L : 0L);
                break;
            }
            case 10: 
            case 11: {
                if (!evalContext.sObs()) {
                    bigDecimal = xQItem.getDecimal();
                    break;
                }
            }
            default: {
                this.invalidCast(xQItemType);
                return null;
            }
        }
        if (bigDecimal.scale() < 1) {
            bigDecimal = bigDecimal.setScale(1);
        }
        return new SingleDecimal(bigDecimal);
    }

    public XQValue convertFromObject(Object object) throws XQTypeException {
        if (object instanceof BigInteger) {
            object = new BigDecimal((BigInteger)object);
        } else if (object instanceof String) {
            object = Conversion.toDecimal((String)object, true);
        }
        return new SingleDecimal((BigDecimal)object);
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws EvaluationException {
        XQItem xQItem = expression.evalAsItem(focus, evalContext);
        BigDecimal bigDecimal = ((DecimalValue)xQItem).getValue();
        return bigDecimal;
    }
}

