/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.api.util.time.Duration;
import com.qizx.util.NamespaceContext;
import com.qizx.xdm.IQName;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.DurationType;
import com.qizx.xquery.dt.SingleDuration;

public class DayTimeDurationType
extends DurationType {
    public QName getName() {
        return IQName.get(NamespaceContext.XSD, this.getShortName());
    }

    public String toString() {
        return "xs:dayTimeDuration";
    }

    public String getShortName() {
        return "dayTimeDuration";
    }

    public int quickCode() {
        return 11;
    }

    public XQValue cast(XQItem xQItem, EvalContext evalContext) throws EvaluationException {
        XQItemType xQItemType = xQItem.getItemType();
        try {
            switch (xQItemType.quickCode()) {
                case 5: 
                case 6: {
                    return SingleDuration.newDT(Duration.parseDuration(xQItem.getString().trim()));
                }
                case 10: 
                case 12: {
                    double d = xQItem.getDuration().getTotalSeconds();
                    return SingleDuration.newDT(Duration.newDayTime(d));
                }
                case 11: {
                    return SingleDuration.newDT(xQItem.getDuration().copy());
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (evalContext == null || evalContext.sObs()) break;
                    return SingleDuration.newDT(new Duration(0, xQItem.getDouble()));
                }
            }
            this.invalidCast(xQItemType);
        }
        catch (DateTimeException dateTimeException) {
            this.castException(dateTimeException);
        }
        return null;
    }
}

