/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.IntegerArraySequence;
import com.qizx.xquery.dt.ShortType;
import com.qizx.xquery.op.Expression;

public class ByteType
extends ShortType {
    public String getShortName() {
        return "byte";
    }

    public long upperBound() {
        return 127L;
    }

    public long lowerBound() {
        return -128L;
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws EvaluationException {
        return new Byte((byte)expression.evalAsInteger(focus, evalContext));
    }

    protected Object convertToObject(long l) {
        return new Byte((byte)l);
    }

    public XQValue convertFromArray(Object object) {
        byte[] byArray = (byte[])object;
        return new IntegerArraySequence(byArray, byArray.length);
    }

    public Object convertToArray(XQValue xQValue) throws EvaluationException {
        return IntegerArraySequence.expandBytes(xQValue);
    }
}

