/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery;

import com.qizx.api.DataModelException;
import com.qizx.api.QName;
import com.qizx.api.XMLPushStream;
import com.qizx.api.util.XMLSerializer;
import com.qizx.util.basic.Util;
import com.qizx.xdm.IQName;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.XQType;
import com.qizx.xquery.op.Expression;
import java.io.PrintWriter;
import java.util.ArrayList;

public class XMLExprDisplay
extends ExprDisplay {
    private XMLPushStream out;
    private ArrayList nameStack = new ArrayList();
    private boolean displayTypes = true;
    private boolean displayFlags = true;

    public XMLExprDisplay(XMLPushStream xMLPushStream) {
        this.out = xMLPushStream;
    }

    public XMLExprDisplay() {
        XMLSerializer xMLSerializer = new XMLSerializer(new PrintWriter(System.err, true));
        xMLSerializer.setIndent(2);
        this.out = xMLSerializer;
    }

    public void header(QName qName) {
        this.nameStack.add(qName);
        try {
            this.out.putElementStart(qName);
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
        }
    }

    public void header(String string) {
        this.header(IQName.get(string));
    }

    public void header(Expression expression) {
        IQName iQName = IQName.get(Util.shortClassName(expression.getClass()));
        this.header(iQName);
        this.headerInfo(expression);
    }

    public void headerInfo(Expression expression) {
        if (this.displayTypes) {
            this.property("type", expression.getType());
        }
        int n = expression.getFlags();
        if (this.displayFlags && n != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            if ((n & 0x10) != 0) {
                stringBuffer.append("Un,");
            }
            if ((n & 8) != 0) {
                stringBuffer.append("DO,");
            }
            if ((n & 4) != 0) {
                stringBuffer.append("=D,");
            }
            if ((n & 0x20) != 0) {
                stringBuffer.append("Cst,");
            }
            if ((n & 0x40) != 0) {
                stringBuffer.append("Nu,");
            }
            if ((n & 0x80) != 0) {
                stringBuffer.append("Up,");
            }
            if ((n & 2) != 0) {
                stringBuffer.append("inN,");
            }
            if ((n & 1) != 0) {
                stringBuffer.append("inT,");
            }
            this.property("flags", stringBuffer.toString());
        }
    }

    public void end() {
        QName qName = (QName)this.nameStack.remove(this.nameStack.size() - 1);
        try {
            this.out.putElementEnd(qName);
        }
        catch (DataModelException dataModelException) {
            this.reportError(dataModelException);
        }
    }

    public void property(String string, String string2) {
        try {
            if (string2 == null) {
                string2 = "<null>";
            }
            this.out.putAttribute(IQName.get(string), string2, null);
        }
        catch (DataModelException dataModelException) {
            this.reportError(dataModelException);
        }
    }

    public void property(String string, XQType xQType) {
        if (xQType != null) {
            this.property(string, xQType.toString());
        }
    }

    public void child(String string, Expression expression) {
        IQName iQName = IQName.get(string);
        try {
            this.out.putElementStart(iQName);
            this.child(expression);
            this.out.putElementEnd(iQName);
        }
        catch (DataModelException dataModelException) {
            this.reportError(dataModelException);
        }
    }

    public void children(String string, Expression[] expressionArray) {
        IQName iQName = IQName.get(string);
        try {
            this.out.putElementStart(iQName);
            this.children(expressionArray);
            this.out.putElementEnd(iQName);
        }
        catch (DataModelException dataModelException) {
            this.reportError(dataModelException);
        }
    }

    public void child(String string, String string2) {
        IQName iQName = IQName.get(string);
        try {
            this.out.putElementStart(iQName);
            this.out.putText(string2);
            this.out.putElementEnd(iQName);
        }
        catch (DataModelException dataModelException) {
            this.reportError(dataModelException);
        }
    }

    private void reportError(DataModelException dataModelException) {
        dataModelException.printStackTrace();
    }

    public XMLPushStream getOutput() {
        return this.out;
    }

    public void setOutput(XMLPushStream xMLPushStream) {
        this.out = xMLPushStream;
    }

    public void flush() throws DataModelException {
        this.out.flush();
    }
}

