/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Item;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.XMLPushStream;
import com.qizx.util.NamespaceContext;
import com.qizx.util.basic.HTable;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.CoreDataModel;
import com.qizx.xdm.CorePushBuilder;
import com.qizx.xdm.FONIDataModel;
import com.qizx.xdm.IDocument;
import com.qizx.xdm.IQName;
import com.qizx.xdm.XMLPushStreamBase;
import com.qizx.xdm.XQName;
import com.qizx.xquery.DynamicContext;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.UpdaterFactory;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.ArraySequence;
import com.qizx.xquery.op.DeleteExpr;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.InsertExpr;
import com.qizx.xquery.op.RenameExpr;
import com.qizx.xquery.op.ReplaceExpr;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Updates {
    private DynamicContext dynamicContext;
    private int nsCopyMode;
    private UpdaterFactory updaterFactory;
    private EvalContext transformContext;
    private Updates enclosing;
    private HTable nodeUpdates;
    private NodeUpdates probe;
    private HashMap<String, Node> putMap;
    private HashMap<Node, String> revPutMap;
    private HashSet<FONIDataModel> docs;
    private Node[] roots;
    private ArrayList<Node> otherNodes = new ArrayList();
    private CoreDataModel coreBuilder = new CoreDataModel("");
    private NamespaceContext tmpNS = new NamespaceContext();
    private int trace = 0;
    private boolean pedantic;
    private boolean nsInherit;

    public Updates(DynamicContext dynamicContext, Updates updates) {
        this.enclosing = updates;
        this.init(dynamicContext);
    }

    public Updates getEnclosing() {
        return this.enclosing;
    }

    public void addRoot(Node node) {
        if (this.roots == null) {
            this.roots = new Node[]{node};
        } else {
            Node[] nodeArray = this.roots;
            this.roots = new Node[nodeArray.length + 1];
            System.arraycopy(nodeArray, 0, this.roots, 0, nodeArray.length);
            this.roots[nodeArray.length] = node;
        }
    }

    public void insertNodes(InsertExpr insertExpr, Focus focus, EvalContext evalContext) throws EvaluationException, DataModelException {
        boolean bl = insertExpr.mode == 4 || insertExpr.mode == 5;
        Node node = this.evalSingleNode(insertExpr.where, focus, evalContext, bl ? "XUDY0009" : null, "XUTY0005");
        int n = node.getNodeNature();
        if (bl) {
            if (n == 3 || n == 1) {
                evalContext.error("XUTY0006", insertExpr.where);
            }
        } else if (n != 2 && n != 1) {
            evalContext.error("XUTY0005", insertExpr.where);
        }
        NodeUpdates nodeUpdates = this.getNodeUpdates(node, evalContext, insertExpr);
        XQValue xQValue = insertExpr.what.eval(focus, evalContext);
        this.otherNodes.clear();
        boolean bl2 = true;
        StringBuffer stringBuffer = null;
        while (xQValue.next()) {
            if (!xQValue.isNode()) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(xQValue.getString());
                    continue;
                }
                stringBuffer.append(' ');
                stringBuffer.append(xQValue.getString());
                continue;
            }
            if (stringBuffer != null) {
                this.addTextNode(stringBuffer);
                stringBuffer = null;
            }
            Node node2 = xQValue.getNode();
            QName qName = node2.getNodeName();
            if (node2.getNodeNature() == 3) {
                ArrayList<Node> arrayList;
                if (n == 1) {
                    evalContext.error("XUTY0022", insertExpr);
                } else if (bl && node.getParent() != null && node.getParent().getNodeNature() != 2) {
                    evalContext.error("XUDY0030", insertExpr);
                }
                if (!bl2) {
                    evalContext.error("XUTY0004", insertExpr);
                }
                if (bl) {
                    NodeUpdates nodeUpdates2 = this.getNodeUpdates(node.getParent(), evalContext, insertExpr);
                    arrayList = nodeUpdates2.insertedAttrs = this.addNode(node2, nodeUpdates2.insertedAttrs);
                } else {
                    arrayList = nodeUpdates.insertedAttrs = this.addNode(node2, nodeUpdates.insertedAttrs);
                }
                if (qName.getPrefix() == null) continue;
                this.checkPrefixClash(qName, node, evalContext, insertExpr);
                continue;
            }
            bl2 = false;
            this.otherNodes.add(node2);
        }
        if (stringBuffer != null) {
            this.addTextNode(stringBuffer);
        }
        evalContext.at(insertExpr);
        switch (insertExpr.mode) {
            case 4: {
                nodeUpdates.insertedBefore = this.addNodes(nodeUpdates.insertedBefore);
                break;
            }
            case 2: {
                nodeUpdates.insertedFirst = this.addNodes(nodeUpdates.insertedFirst);
                break;
            }
            case 1: {
                nodeUpdates.insertedInto = this.addNodes(nodeUpdates.insertedInto);
                break;
            }
            case 3: {
                nodeUpdates.insertedLast = this.addNodes(nodeUpdates.insertedLast);
                break;
            }
            case 5: {
                nodeUpdates.insertedAfter = this.addNodes(nodeUpdates.insertedAfter);
            }
        }
    }

    private void addTextNode(StringBuffer stringBuffer) {
        this.otherNodes.add(this.coreBuilder.newTextNode(stringBuffer.toString()));
    }

    private ArrayList<Node> addNode(Node node, ArrayList<Node> arrayList) throws EvaluationException {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        arrayList.add(node);
        return arrayList;
    }

    private ArrayList<Node> addNodes(ArrayList<Node> arrayList) throws EvaluationException {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        arrayList.addAll(this.otherNodes);
        return arrayList;
    }

    private void checkPrefixClash(QName qName, Node node, EvalContext evalContext, Expression expression) throws DataModelException, EvaluationException {
        this.tmpNS.clear();
        ((BasicNode)node).addInScopeNamespacesTo(this.tmpNS);
        String string = qName.getPrefix();
        String string2 = this.tmpNS.getNamespaceURI(string);
        if (string2 != null && !string2.equals(qName.getNamespaceURI())) {
            evalContext.error("XUDY0023", expression);
        }
    }

    public void deleteNodes(DeleteExpr deleteExpr, Focus focus, EvalContext evalContext) throws EvaluationException {
        XQValue xQValue = deleteExpr.where.eval(focus, evalContext);
        evalContext.at(deleteExpr);
        while (xQValue.next()) {
            if (!xQValue.isNode()) {
                evalContext.error("XUTY0007", deleteExpr);
            }
            Node node = xQValue.getNode();
            NodeUpdates nodeUpdates = this.getNodeUpdates(node, evalContext, deleteExpr);
            nodeUpdates.deleted = true;
        }
    }

    public void renameNode(RenameExpr renameExpr, Focus focus, EvalContext evalContext) throws EvaluationException, DataModelException {
        Node node = this.evalSingleNode(renameExpr.where, focus, evalContext, null, "XUTY0008");
        int n = node.getNodeNature();
        if (n == 1 || n >= 6) {
            evalContext.error("XUDY0015", renameExpr);
        }
        QName qName = this.computeName(renameExpr.what, focus, evalContext);
        evalContext.at(renameExpr);
        if (qName.getPrefix() != null) {
            this.checkPrefixClash(qName, node, evalContext, renameExpr);
        }
        NodeUpdates nodeUpdates = this.getNodeUpdates(node, evalContext, renameExpr);
        if (nodeUpdates.newName != null) {
            evalContext.error("XUDY0015", renameExpr);
        }
        nodeUpdates.newName = qName;
    }

    public void replaceNodes(ReplaceExpr replaceExpr, Focus focus, EvalContext evalContext) throws EvaluationException, DataModelException {
        Node node = this.evalSingleNode(replaceExpr.where, focus, evalContext, null, "XUTY0012");
        int n = node.getNodeNature();
        XQValue xQValue = replaceExpr.what.eval(focus, evalContext);
        evalContext.at(replaceExpr);
        NodeUpdates nodeUpdates = this.getNodeUpdates(node, evalContext, replaceExpr);
        if (replaceExpr.mode == 1) {
            if (nodeUpdates.replacedValue != null) {
                evalContext.error("XUDY0017", replaceExpr);
            }
            nodeUpdates.replacedValue = this.buildText(xQValue);
            if (n == 1) {
                evalContext.error("XUTY0008", replaceExpr.where, "replace value of document is not allowed");
            }
            if (n == 6 && !XMLUtil.checkComment(nodeUpdates.replacedValue)) {
                evalContext.error("XQDY0072", replaceExpr);
            } else if (n == 5 && nodeUpdates.replacedValue != null && nodeUpdates.replacedValue.indexOf("?>") >= 0) {
                evalContext.error("XQDY0026", replaceExpr);
            }
        } else {
            if (nodeUpdates.replacement != null) {
                evalContext.error("XUDY0016", replaceExpr);
            }
            if (node.getParent() == null) {
                evalContext.error("XUDY0009", replaceExpr);
            }
            nodeUpdates.replacement = ArraySequence.expand(xQValue);
            Item[] itemArray = nodeUpdates.replacement;
            try {
                boolean bl = n == 3;
                int n2 = 0;
                int n3 = itemArray.length;
                for (int i = 0; i < n3; ++i) {
                    Object object;
                    Node node2;
                    boolean bl2 = false;
                    if (itemArray[i].isNode()) {
                        node2 = itemArray[i].getNode();
                        bl2 = node2.getNodeNature() == 3;
                        object = node2.getNodeName();
                        if (object != null && object.getPrefix() != null) {
                            this.checkPrefixClash((QName)object, node, evalContext, replaceExpr);
                        }
                    } else {
                        object = new StringBuffer(itemArray[i].getString());
                        while (i + 1 < n3 && !itemArray[i + 1].isNode()) {
                            ((StringBuffer)object).append(' ');
                            ((StringBuffer)object).append(itemArray[i + 1].getString());
                            ++i;
                        }
                        node2 = this.coreBuilder.newTextNode(((StringBuffer)object).toString());
                    }
                    if (bl2 != bl) {
                        evalContext.error(bl ? "XUTY0011" : "XUTY0010", replaceExpr.what);
                    }
                    itemArray[n2++] = node2;
                }
                if (n2 != itemArray.length) {
                    Item[] itemArray2 = itemArray;
                    itemArray = new Item[n2];
                    System.arraycopy(itemArray2, 0, itemArray, 0, n2);
                }
                nodeUpdates.replacement = itemArray;
            }
            catch (DataModelException dataModelException) {
                evalContext.error(dataModelException.getErrorCode(), replaceExpr.what, dataModelException.getMessage());
            }
        }
    }

    private Node evalSingleNode(Expression expression, Focus focus, EvalContext evalContext, String string, String string2) throws EvaluationException, DataModelException {
        Node node;
        XQValue xQValue = expression.eval(focus, evalContext);
        if (!xQValue.next()) {
            evalContext.error("XUDY0027", expression);
        }
        if (!xQValue.isNode()) {
            evalContext.error(string2, expression);
        }
        Node node2 = xQValue.getNode();
        if (xQValue.next()) {
            evalContext.error(string2, expression);
        }
        if (string != null && (node = node2.getParent()) == null) {
            evalContext.error(string, expression);
        }
        return node2;
    }

    private QName computeName(Expression expression, Focus focus, EvalContext evalContext) throws EvaluationException {
        XQItem xQItem = expression.evalAsItem(focus, evalContext);
        BasicNode basicNode = null;
        int n = xQItem.getItemType().quickCode();
        if (xQItem.isNode()) {
            basicNode = xQItem.basicNode();
            n = 5;
        }
        evalContext.at(expression);
        switch (n) {
            case 5: 
            case 6: {
                try {
                    String string = xQItem.getString();
                    String string2 = IQName.extractPrefix(string);
                    String string3 = IQName.extractLocalName(string);
                    if (string2.length() == 0) {
                        return XQName.get("", string3, "");
                    }
                    QName qName = null;
                    String string4 = null;
                    if (basicNode != null) {
                        string4 = basicNode.getNamespaceUri(string2);
                    }
                    if ((qName = string4 != null ? XQName.get(string4, string3, string2) : evalContext.getInScopeNS().expandName(string)) == null) {
                        evalContext.error("XQDY0074", expression, "no namespace found for prefix " + string2);
                    }
                    return qName;
                }
                catch (Exception exception) {
                    evalContext.error("XQDY0074", expression, "error converting string to QName: " + exception.getMessage());
                    return null;
                }
            }
            case 15: {
                return xQItem.getQName();
            }
        }
        evalContext.badTypeForArg(xQItem.getItemType(), expression, 0, "QName or string");
        return null;
    }

    public Node applyTransformUpdates(int n) throws EvaluationException {
        Node node = this.roots[n];
        CorePushBuilder corePushBuilder = new CorePushBuilder("");
        try {
            this.rebuild(node, corePushBuilder);
        }
        catch (DataModelException dataModelException) {
            throw BasicNode.wrapDMException(dataModelException);
        }
        return corePushBuilder.harvest();
    }

    public void addPut(String string, Node node, Expression expression, EvalContext evalContext) throws DataModelException, EvaluationException {
        if (node.getNodeNature() != 1 && node.getNodeNature() != 2) {
            evalContext.error("FOUP0001", expression, "first operand of fn:put is not a proper node");
        }
        if ((string = Updates.validatedURI(string)) == null) {
            evalContext.error("FOUP0002", expression);
        }
        if (this.putMap != null && this.putMap.get(string) != null) {
            evalContext.error("XUDY0031", expression, "put URI " + string + " has already been used in this snapshot");
        }
        if (this.putMap == null) {
            this.putMap = new HashMap();
            this.revPutMap = new HashMap();
        }
        this.putMap.put(string, node);
        this.revPutMap.put(node, string);
    }

    private void doActualPut(Node node, String string) throws DataModelException, EvaluationException {
        throw new EvaluationException("fn:put() supported only on XML Libraries");
    }

    static String validatedURI(String string) throws DataModelException {
        try {
            URI uRI = new URI(string);
            if (uRI.getScheme() != null || uRI.getAuthority() != null) {
                throw new DataModelException("invalid document path: " + string);
            }
            return uRI.getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public void apply() throws EvaluationException {
        if (this.trace > 0) {
            System.err.println("=== Updates.apply ===");
            NodeUpdates[] nodeUpdatesArray = (NodeUpdates[])this.nodeUpdates.getKeys(new NodeUpdates[this.nodeUpdates.getSize()]);
            if (this.trace >= 2) {
                for (int i = 0; i < nodeUpdatesArray.length; ++i) {
                    System.err.println(" " + nodeUpdatesArray[i]);
                }
                System.err.println("Updated docs: " + this.docs);
            }
        }
        try {
            Object object;
            for (FONIDataModel fONIDataModel : this.docs) {
                object = fONIDataModel.getDom();
                BasicNode basicNode = fONIDataModel.getDocumentNode();
                if (!(object instanceof IDocument)) continue;
                IDocument iDocument = (IDocument)object;
                XMLPushStreamBase xMLPushStreamBase = this.updaterFactory.newParsedDocument(iDocument.getBaseURI());
                xMLPushStreamBase.setCheckNS(true);
                this.rebuild(basicNode, xMLPushStreamBase);
                this.updaterFactory.endParsedDocument();
            }
            if (this.putMap != null) {
                for (String string : this.putMap.keySet()) {
                    object = this.putMap.get(string);
                    this.doActualPut((Node)object, string);
                }
            }
        }
        catch (DataModelException dataModelException) {
            throw BasicNode.wrapDMException(dataModelException);
        }
    }

    private void rebuild(Node node, XMLPushStream xMLPushStream) throws DataModelException, EvaluationException {
        NodeUpdates nodeUpdates = this.rawNodeUpdates(node);
        boolean bl = false;
        if (nodeUpdates != null) {
            if (this.trace > 0) {
                System.err.println("Updated node " + node);
            }
            this.putNodeList(xMLPushStream, nodeUpdates.insertedBefore);
            bl = nodeUpdates.deleted;
        }
        switch (node.getNodeNature()) {
            case 1: {
                xMLPushStream.putDocumentStart();
                if (nodeUpdates != null) {
                    this.putNodeList(xMLPushStream, nodeUpdates.insertedFirst);
                }
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.rebuild(node2, xMLPushStream);
                }
                if (nodeUpdates != null) {
                    this.putNodeList(xMLPushStream, nodeUpdates.insertedInto);
                    this.putNodeList(xMLPushStream, nodeUpdates.insertedLast);
                }
                xMLPushStream.putDocumentEnd();
                break;
            }
            case 2: {
                if (!bl) {
                    QName qName;
                    QName qName2 = qName = nodeUpdates != null && nodeUpdates.newName != null ? nodeUpdates.newName : node.getNodeName();
                    if (nodeUpdates == null || nodeUpdates.replacement == null) {
                        xMLPushStream.putElementStart(qName);
                        xMLPushStream.putNamespaces(node, 0);
                        Node[] nodeArray = node.getAttributes();
                        if (nodeArray != null) {
                            for (int i = 0; i < nodeArray.length; ++i) {
                                Node node3 = nodeArray[i];
                                NodeUpdates nodeUpdates2 = this.rawNodeUpdates(node3);
                                if (nodeUpdates2 == null) {
                                    xMLPushStream.putAttribute(node3.getNodeName(), node3.getStringValue(), null);
                                    continue;
                                }
                                if (this.trace > 0) {
                                    System.err.println("Update attr " + node3);
                                }
                                this.buildAttributes(nodeUpdates2, xMLPushStream);
                            }
                        }
                        if (nodeUpdates != null) {
                            ArrayList<Node> arrayList = nodeUpdates.insertedAttrs;
                            if (arrayList != null) {
                                int n = arrayList.size();
                                for (int i = 0; i < n; ++i) {
                                    Node node4 = arrayList.get(i);
                                    if (this.trace > 0) {
                                        System.err.println("New attr " + node4);
                                    }
                                    QName qName3 = node4.getNodeName();
                                    xMLPushStream.putAttribute(qName3, node4.getStringValue(), null);
                                    if (!this.nsInherit) continue;
                                    this.ensureMapping(xMLPushStream, qName3);
                                }
                            }
                            this.putNodeList(xMLPushStream, nodeUpdates.insertedFirst);
                        }
                        if (this.nsInherit) {
                            this.ensureMapping(xMLPushStream, qName);
                        }
                        if (nodeUpdates != null && nodeUpdates.replacedValue != null) {
                            if (this.trace > 0) {
                                System.err.println("Replace node value " + node);
                            }
                            xMLPushStream.putText(nodeUpdates.replacedValue);
                        } else {
                            for (Node node5 = node.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                                this.rebuild(node5, xMLPushStream);
                            }
                        }
                        if (nodeUpdates != null) {
                            this.putNodeList(xMLPushStream, nodeUpdates.insertedInto);
                            this.putNodeList(xMLPushStream, nodeUpdates.insertedLast);
                        }
                        xMLPushStream.putElementEnd(qName);
                        break;
                    }
                    this.putNodeList(xMLPushStream, nodeUpdates.replacement);
                    break;
                }
                QName qName = nodeUpdates.checkDupAttribute(node);
                if (qName != null) {
                    throw new DataModelException("XUDY0021", "Duplicate attribute '" + qName + "'");
                }
                this.putNodeList(xMLPushStream, nodeUpdates.replacement);
                break;
            }
            case 3: {
                NodeUpdates nodeUpdates3 = this.rawNodeUpdates(node);
                if (nodeUpdates3 == null) {
                    xMLPushStream.putAttribute(node.getNodeName(), node.getStringValue(), null);
                    break;
                }
                this.buildAttributes(nodeUpdates3, xMLPushStream);
                break;
            }
            case 7: {
                if (nodeUpdates != null) {
                    if (nodeUpdates.replacement != null) {
                        this.putNodeList(xMLPushStream, nodeUpdates.replacement);
                        break;
                    }
                    if (bl) break;
                    xMLPushStream.putText(nodeUpdates.replacedValue != null ? nodeUpdates.replacedValue : node.getStringValue());
                    break;
                }
                xMLPushStream.putText(node.getStringValue());
                break;
            }
            case 6: {
                if (nodeUpdates != null) {
                    if (nodeUpdates.replacement != null) {
                        this.putNodeList(xMLPushStream, nodeUpdates.replacement);
                        break;
                    }
                    if (bl) break;
                    xMLPushStream.putComment(nodeUpdates.replacedValue != null ? nodeUpdates.replacedValue : node.getStringValue());
                    break;
                }
                xMLPushStream.putComment(node.getStringValue());
                break;
            }
            case 5: {
                if (nodeUpdates == null) {
                    xMLPushStream.putProcessingInstruction(node.getNodeName().getLocalPart(), node.getStringValue());
                    break;
                }
                if (nodeUpdates.replacement != null) {
                    this.putNodeList(xMLPushStream, nodeUpdates.replacement);
                    break;
                }
                if (bl) break;
                QName qName = nodeUpdates.newName != null ? nodeUpdates.newName : node.getNodeName();
                String string = nodeUpdates.replacedValue == null ? node.getStringValue() : nodeUpdates.replacedValue;
                xMLPushStream.putProcessingInstruction(qName.getLocalPart(), string);
            }
        }
        if (nodeUpdates != null) {
            this.putNodeList(xMLPushStream, nodeUpdates.insertedAfter);
        }
    }

    private void buildAttributes(NodeUpdates nodeUpdates, XMLPushStream xMLPushStream) throws DataModelException, EvaluationException {
        if (nodeUpdates.deleted) {
            return;
        }
        QName qName = nodeUpdates.newName == null ? nodeUpdates.node.getNodeName() : nodeUpdates.newName;
        Item[] itemArray = nodeUpdates.replacement;
        if (itemArray != null) {
            for (int i = 0; i < itemArray.length; ++i) {
                if (!itemArray[i].isNode()) continue;
                Node node = itemArray[i].getNode();
                QName qName2 = node.getNodeName();
                xMLPushStream.putAttribute(qName2, node.getStringValue(), null);
                if (!this.nsInherit) continue;
                this.ensureMapping(xMLPushStream, qName2);
            }
        } else if (nodeUpdates.replacedValue != null) {
            xMLPushStream.putAttribute(qName, nodeUpdates.replacedValue, null);
        } else {
            xMLPushStream.putAttribute(qName, nodeUpdates.node.getStringValue(), null);
            if (this.nsInherit) {
                this.ensureMapping(xMLPushStream, qName);
            }
        }
    }

    private void ensureMapping(XMLPushStream xMLPushStream, QName qName) throws DataModelException {
        if (qName == null || qName.hasNoNamespace()) {
            return;
        }
        String string = xMLPushStream.getNSPrefix(qName.getNamespaceURI());
        if (string != null) {
            return;
        }
        string = qName.getPrefix();
        if (string == null) {
            string = this.dynamicContext.getNSPrefix(qName.getNamespaceURI());
        }
        if (string != null) {
            xMLPushStream.putNamespace(string, qName.getNamespaceURI());
        }
    }

    private String buildText(XQValue xQValue) throws EvaluationException, DataModelException {
        StringBuffer stringBuffer = new StringBuffer(20);
        boolean bl = true;
        while (xQValue.next()) {
            if (!bl) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(xQValue.getString());
            bl = false;
        }
        return stringBuffer.toString();
    }

    private void putNodeList(XMLPushStream xMLPushStream, ArrayList<Node> arrayList) throws DataModelException {
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Node node = arrayList.get(i);
                xMLPushStream.putNodeCopy(node, this.nsCopyMode);
            }
        }
    }

    private void putNodeList(XMLPushStream xMLPushStream, Item[] itemArray) throws DataModelException {
        if (itemArray != null) {
            for (int i = 0; i < itemArray.length; ++i) {
                Node node = (Node)itemArray[i];
                xMLPushStream.putNodeCopy(node, this.nsCopyMode);
            }
        }
    }

    private void init(DynamicContext dynamicContext) {
        this.dynamicContext = dynamicContext;
        this.nsCopyMode = dynamicContext.mainQuery.getCopyNSMode();
        this.nsInherit = this.nsCopyMode == 1 || this.nsCopyMode == 2;
        this.nodeUpdates = new HTable();
        this.probe = new NodeUpdates(null);
        this.docs = new HashSet();
        this.updaterFactory = dynamicContext.getUpdaterFactory();
        this.pedantic = dynamicContext.mainQuery.sObs();
    }

    private NodeUpdates getNodeUpdates(Node node, EvalContext evalContext, Expression expression) throws EvaluationException {
        NodeUpdates nodeUpdates = this.rawNodeUpdates(node);
        if (nodeUpdates == null) {
            nodeUpdates = new NodeUpdates(node);
            this.nodeUpdates.directPut(nodeUpdates);
        }
        if (this.transformContext != null) {
            int n = this.roots.length;
            try {
                while (--n >= 0 && !this.roots[n].contains(node)) {
                }
            }
            catch (DataModelException dataModelException) {
                evalContext.error(dataModelException.getErrorCode(), expression, dataModelException.getMessage());
            }
            if (n < 0) {
                evalContext.error("XUDY0014", expression);
            }
        } else if (node instanceof FONIDataModel.FONINode) {
            FONIDataModel.FONINode fONINode = (FONIDataModel.FONINode)node;
            this.docs.add(fONINode.getDM());
        }
        return nodeUpdates;
    }

    private NodeUpdates rawNodeUpdates(Node node) {
        this.probe.node = node;
        NodeUpdates nodeUpdates = (NodeUpdates)this.nodeUpdates.get(this.probe);
        return nodeUpdates;
    }

    public void setTransformContext(EvalContext evalContext) {
        this.transformContext = evalContext;
    }

    private static class NodeUpdates
    extends HTable.Key {
        Node node;
        boolean deleted;
        QName newName;
        String replacedValue;
        Item[] replacement;
        ArrayList<Node> insertedBefore;
        ArrayList<Node> insertedFirst;
        ArrayList<Node> insertedInto;
        ArrayList<Node> insertedLast;
        ArrayList<Node> insertedAfter;
        ArrayList<Node> insertedAttrs;

        NodeUpdates(Node node) {
            this.node = node;
        }

        public HTable.Key duplicate() {
            return new NodeUpdates(this.node);
        }

        public String toString() {
            return "Update node=" + this.node + ": " + (this.newName != null ? "renamed " + this.newName + ", " : "") + (this.replacedValue != null ? "replaced value " + this.replacedValue + ", " : "") + (this.replacement != null ? "replaced by " + this.replacement + ", " : "") + (this.insertedBefore != null ? "ins B " + this.insertedBefore + ", " : "") + (this.insertedFirst != null ? "ins F " + this.insertedFirst + ", " : "") + (this.insertedInto != null ? "ins I " + this.insertedInto + ", " : "") + (this.insertedLast != null ? "ins L " + this.insertedLast + ", " : "") + (this.insertedAfter != null ? "ins A " + this.insertedAfter + ", " : "") + (this.insertedAttrs != null ? "ins Attr " + this.insertedAttrs + ", " : "") + (this.deleted ? "deleted" : "");
        }

        QName checkDupAttribute(Node node) throws DataModelException {
            if (this.insertedAttrs != null) {
                int n = this.insertedAttrs.size();
                while (--n >= 0) {
                    Node node2 = this.insertedAttrs.get(n);
                    QName qName = node2.getNodeName();
                    if (node != null && node.getAttribute(qName) != null) {
                        return qName;
                    }
                    int n2 = n;
                    while (--n2 >= 0) {
                        Node node3 = this.insertedAttrs.get(n2);
                        if (qName != node3.getNodeName()) continue;
                        return qName;
                    }
                }
            }
            return null;
        }

        public boolean equals(Object object) {
            if (object instanceof NodeUpdates) {
                return this.node.equals(((NodeUpdates)object).node);
            }
            return false;
        }

        public int hashCode() {
            return this.node.hashCode();
        }
    }
}

