/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery;

import com.qizx.api.CompilationException;
import com.qizx.api.ModuleResolver;
import com.qizx.api.util.DefaultModuleResolver;
import com.qizx.util.basic.FileUtil;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.impl.NewParser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

public class ModuleManager
implements ErrorListener {
    public static final String XSLT_OUTPUT_FILE = "output-file";
    private ModuleResolver resolver;
    private HashMap modules = new HashMap();
    private URL xslBaseURL;
    private TransformerFactory xsltFactory;
    private ArrayList templateCache = new ArrayList();
    private int templateCacheSize = 3;
    private StringBuffer errorMessages = new StringBuffer();

    public ModuleManager(ModuleResolver moduleResolver) {
        this.xslBaseURL = FileUtil.fileToURL("./");
        this.setResolver(moduleResolver);
    }

    public ModuleResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ModuleResolver moduleResolver) {
        this.resolver = moduleResolver;
        if (moduleResolver instanceof DefaultModuleResolver) {
            DefaultModuleResolver defaultModuleResolver = (DefaultModuleResolver)moduleResolver;
            this.xslBaseURL = defaultModuleResolver.getBase();
        }
    }

    public synchronized void unloadAllModules() {
        this.modules = new HashMap();
    }

    public synchronized boolean alreadyLoadedModule(String string) {
        return this.modules.get(string) != null;
    }

    public synchronized ModuleContext loadModule(ModuleContext moduleContext, URL uRL) throws IOException, CompilationException {
        ModuleContext moduleContext2 = (ModuleContext)this.modules.get(uRL);
        if (moduleContext2 == null) {
            String string = FileUtil.loadString(uRL);
            NewParser newParser = new NewParser(this);
            moduleContext2 = new ModuleContext(moduleContext);
            this.modules.put(uRL, moduleContext2);
            moduleContext2.setMessageTarget(moduleContext.getMessageTarget());
            newParser.parseModule(moduleContext2, string, uRL.toString());
        }
        return moduleContext2;
    }

    public void setXSLTFactory(TransformerFactory transformerFactory) {
        this.xsltFactory = transformerFactory;
    }

    public TransformerFactory getXSLTFactory() {
        if (this.xsltFactory == null) {
            try {
                Class<?> clazz = Class.forName("net.sf.saxon.TransformerFactoryImpl");
                this.xsltFactory = (TransformerFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.xsltFactory == null) {
                this.xsltFactory = TransformerFactory.newInstance();
            }
        }
        return this.xsltFactory;
    }

    public Templates loadTemplates(String string) throws TransformerException {
        ArrayList arrayList = this.templateCache;
        synchronized (arrayList) {
            try {
                this.errorMessages.setLength(0);
                return this.doLoadTemplates(string);
            }
            catch (TransformerException transformerException) {
                throw new TransformerException(transformerException.getMessage() + this.errorMessages);
            }
        }
    }

    private Templates doLoadTemplates(String string) throws TransformerException {
        long l = System.currentTimeMillis();
        CacheSlot cacheSlot = null;
        int n = this.templateCache.size();
        while (!(--n < 0 || (cacheSlot = (CacheSlot)this.templateCache.get(n)) != null && cacheSlot.path.equals(string))) {
        }
        if (n >= 0) {
            return (Templates)cacheSlot.loaded;
        }
        cacheSlot = new CacheSlot();
        cacheSlot.path = string;
        this.getXSLTFactory();
        try {
            Source source = null;
            this.xsltFactory.setErrorListener(this);
            source = this.xsltFactory.getURIResolver() != null ? this.xsltFactory.getURIResolver().resolve(string, this.xslBaseURL.toString()) : new StreamSource(new URL(this.xslBaseURL, string).toString());
            if (source == null) {
                throw new TransformerException("cannot find stylesheet " + string);
            }
            Templates templates = this.xsltFactory.newTemplates(source);
            cacheSlot.loaded = templates;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new TransformerException(transformerConfigurationException.getMessage(), transformerConfigurationException.getCause());
        }
        catch (MalformedURLException malformedURLException) {
            throw new TransformerException(malformedURLException.getMessage(), malformedURLException.getCause());
        }
        this.templateCache.add(0, cacheSlot);
        if (this.templateCache.size() > this.templateCacheSize) {
            this.templateCache.remove(this.templateCache.size() - 1);
        }
        return (Templates)cacheSlot.loaded;
    }

    public void error(TransformerException transformerException) throws TransformerException {
        this.errorMessages.append("\n" + transformerException.getMessage());
    }

    public void warning(TransformerException transformerException) {
        this.errorMessages.append("\n" + transformerException.getMessage());
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        throw transformerException;
    }

    public URL getXslBaseURL() {
        return this.xslBaseURL;
    }

    public void setXslBaseURL(URL uRL) {
        this.xslBaseURL = uRL;
    }

    static class CacheSlot {
        String path;
        Object loaded;
        long timeStamp;

        CacheSlot() {
        }
    }
}

