/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.EvaluationStackTrace;
import com.qizx.api.ItemType;
import com.qizx.api.QName;
import com.qizx.api.TraceObserver;
import com.qizx.api.util.time.DateTime;
import com.qizx.util.NamespaceContext;
import com.qizx.xdm.Conversion;
import com.qizx.xdm.IQName;
import com.qizx.xquery.ComparisonContext;
import com.qizx.xquery.DynamicContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.MainQuery;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.Updates;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.SingleDouble;
import com.qizx.xquery.dt.SingleInteger;
import com.qizx.xquery.dt.SingleItem;
import com.qizx.xquery.dt.SingleNode;
import com.qizx.xquery.dt.SingleString;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.UserFunction;
import com.qizx.xquery.impl.EmptyException;
import com.qizx.xquery.impl.ErrorValue;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.GlobalVariable;
import com.qizx.xquery.op.LocalVariable;
import com.qizx.xquery.op.PathExpr;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.Properties;

public class EvalContext
implements ComparisonContext {
    public static final int MAX_REGISTER = 4;
    public static final int INT_REGISTER = 0;
    public static final int DOUBLE_REGISTER = 4;
    public static final int STRING_REGISTER = 8;
    public static final int ITEM_REGISTER = 12;
    public static final int LAST_REGISTER = 20;
    public static final int STOP = 1;
    public static final int TIMEOUT = 2;
    public static final int SUSPEND = 3;
    public static final int TRACING = 4;
    private static final int MAX_STACK_DEPTH = 500;
    private static Properties errorCodes;
    public static final QName DM_ERRCODE;
    protected EvalContext upContext;
    protected DynamicContext dynCtx;
    protected UserFunction.Signature called;
    protected int depth;
    protected EvalContext closure;
    protected Expression point;
    private NamespaceContext constructorNS;
    private boolean traceExec;
    private Collator defaultCollator;
    protected XQValue[] locals;
    public long registerInt0;
    public long registerInt1;
    public long registerInt2;
    public long registerInt3;
    public double registerDouble0;
    public double registerDouble1;
    public double registerDouble2;
    public double registerDouble3;
    public String registerString0;
    public String registerString1;
    public String registerString2;
    public String registerString3;
    public XQItem registerItem0;
    public XQItem registerItem1;
    public XQItem registerItem2;
    public XQItem registerItem3;
    public XQItem registerItem4;
    public XQItem registerItem5;
    public XQItem registerItem6;
    public XQItem registerItem7;

    public EvalContext(DynamicContext dynamicContext) {
        this.upContext = null;
        this.dynCtx = dynamicContext;
        MainQuery mainQuery = dynamicContext.mainQuery;
        int n = mainQuery == null ? 0 : mainQuery.getLocalSize();
        this.locals = n > 0 ? new XQValue[n] : null;
        this.depth = 1;
        this.defaultCollator = mainQuery == null ? null : this.getCollator(null);
    }

    public EvalContext(int n) {
        if (n > 0) {
            this.locals = new XQValue[n];
        }
    }

    public EvalContext subContext(UserFunction.Signature signature) throws EvaluationException {
        EvalContext evalContext = new EvalContext(signature.maxStackSize);
        evalContext.upContext = this;
        evalContext.called = signature;
        evalContext.dynCtx = this.dynCtx;
        evalContext.depth = this.depth + 1;
        evalContext.traceExec = this.traceExec;
        return evalContext;
    }

    public EvalContext getCallerContext() {
        return this.upContext;
    }

    public EvalContext getClosure() {
        return this.closure;
    }

    public void setClosure(EvalContext evalContext) {
        this.closure = evalContext;
    }

    public final ModuleContext getStaticContext() {
        return this.dynCtx.mainQuery;
    }

    public XQValue error(String string, Expression expression) throws EvaluationException {
        return this.error(string, expression, EvalContext.getMessageText(string));
    }

    public XQValue error(QName qName, Expression expression, String string) throws EvaluationException {
        return this.error(qName, expression, string, null);
    }

    public XQValue error(QName qName, Expression expression, String string, Exception exception) throws EvaluationException {
        EvaluationException evaluationException = new EvaluationException(qName, string, exception);
        return this.error(expression, evaluationException);
    }

    public XQValue error(String string, Expression expression, EvaluationException evaluationException) throws EvaluationException {
        evaluationException.setErrorCode(ModuleContext.xqueryErrorCode(string));
        return this.error(expression, evaluationException);
    }

    public XQValue error(String string, Expression expression, String string2) throws EvaluationException {
        EvaluationException evaluationException = new EvaluationException(string2);
        return this.error(string, expression, evaluationException);
    }

    public XQValue error(Expression expression, EvaluationException evaluationException) throws EvaluationException {
        this.point = expression;
        this.dynCtx.lastContext = this;
        EvaluationStackTrace[] evaluationStackTraceArray = new EvaluationStackTrace[this.depth];
        EvalContext evalContext = this;
        EvalContext evalContext2 = null;
        int n = 0;
        while (evalContext != null) {
            evalContext2 = evalContext.upContext;
            evaluationStackTraceArray[n++] = this.newStackTrace(evalContext.point, evalContext2);
            evalContext = evalContext2;
        }
        evaluationException.setStack(evaluationStackTraceArray);
        throw evaluationException;
    }

    public static synchronized String getMessageText(String string) {
        if (errorCodes == null) {
            errorCodes = new Properties();
            InputStream inputStream = ModuleContext.class.getResourceAsStream("XQErrorCodes.properties");
            if (inputStream != null) {
                try {
                    errorCodes.load(inputStream);
                    inputStream.close();
                }
                catch (IOException iOException) {
                    System.err.println("*** Cannot load XQuery error codes");
                }
            } else {
                return null;
            }
        }
        return errorCodes.getProperty(string);
    }

    public EvaluationStackTrace newStackTrace(Expression expression, EvalContext evalContext) {
        if (expression == null || expression.module == null) {
            return new EvaluationStackTrace(null, "<null>", 0, "?", 0, -1);
        }
        String string = expression.module.getPhysicalURI();
        int n = expression.offset;
        String string2 = expression.module.getSource();
        int n2 = 1;
        int n3 = string2.indexOf(10);
        int n4 = 0;
        while (n3 >= 0 && n3 < n) {
            n4 = n3 + 1;
            n3 = string2.indexOf(10, n3 + 1);
            ++n2;
        }
        String string3 = string2.substring(n4, n3 < 0 ? string2.length() : n3);
        String string4 = null;
        if (evalContext != null && evalContext.point instanceof UserFunction.Call) {
            UserFunction.Call call = (UserFunction.Call)evalContext.point;
            if (call.prototype != null) {
                string4 = call.prototype.toString(this.getInScopeNS());
            }
        }
        return new EvaluationStackTrace(string4, string, n2, string3, n - n4, n);
    }

    public void checkArgType(XQItem xQItem, Expression expression, int n, ItemType itemType) throws EvaluationException {
        XQItemType xQItemType = xQItem.getItemType();
        if (xQItemType != itemType) {
            this.badTypeForArg(xQItemType, expression, n, itemType.toString());
        }
    }

    public void badTypeForArg(XQItemType xQItemType, Expression expression, int n, String string) throws EvaluationException {
        this.error("XPTY0004", expression, "invalid type " + xQItemType + " for argument" + (n < 0 ? "" : " " + (n + 1)) + " expecting " + string);
    }

    public void invalidArgType(Expression expression, int n, ItemType itemType, String string) throws EvaluationException {
        this.error(Function.ERR_ARGTYPE, expression, "invalid type " + itemType + " for argument" + (n < 0 ? "" : " " + (n + 1)) + (string == null ? "" : ", expecting " + string));
    }

    public void incompatibleType(int n, String string, Function.Call call) throws EvaluationException {
        this.error(Function.ERR_ARGTYPE, (Expression)call, "item type (rank " + n + ") incompatible with " + string);
    }

    public String getSignature() {
        return this.called == null ? null : this.called.toString(this.getStaticContext().getInScopeNS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void at(Expression expression) throws EvaluationException {
        if (expression != null) {
            this.point = expression;
        }
        if (this.dynCtx.monitorMode != 0) {
            switch (this.dynCtx.monitorMode) {
                case 1: {
                    throw new EvaluationException(EvaluationException.CANCELLED, "cancelled");
                }
                case 2: {
                    throw new EvaluationException(EvaluationException.TIME_LIMIT, "time limit reached");
                }
                case 3: {
                    this.dynCtx.lastContext = this;
                    DynamicContext dynamicContext = this.dynCtx;
                    synchronized (dynamicContext) {
                        try {
                            this.dynCtx.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        break;
                    }
                }
            }
        }
    }

    public Expression getCurrentLocation() {
        return this.point;
    }

    public XQValue loadGlobal(GlobalVariable globalVariable) throws EvaluationException {
        ModuleContext moduleContext = this.getStaticContext();
        GlobalVariable globalVariable2 = null;
        if (moduleContext == null) {
            this.error("XPDY0002", (Expression)globalVariable, "variable in constant expression");
        } else {
            globalVariable2 = moduleContext.getCurInitVar();
        }
        XQValue xQValue = (XQValue)this.dynCtx.globals.get(globalVariable);
        if (xQValue == null) {
            this.error("XPDY0002", (Expression)globalVariable, "variable $" + moduleContext.prefixedName(globalVariable.name) + " has no specified value");
            return null;
        }
        return xQValue.bornAgain();
    }

    public void setGlobal(GlobalVariable globalVariable, XQValue xQValue) {
        this.dynCtx.globals.put(globalVariable, xQValue);
    }

    public EvalContext closure(int n) throws EvaluationException {
        EvalContext evalContext = this.closure;
        for (int i = n; evalContext != null && i > 1; --i) {
            evalContext = evalContext.closure;
        }
        if (evalContext == null) {
            throw new EvaluationException("OOPS: cannot reached closure " + n);
        }
        return evalContext;
    }

    public XQValue loadLocal(int n) throws EvaluationException {
        switch (n) {
            case 0: {
                return new SingleInteger(this.registerInt0);
            }
            case 1: {
                return new SingleInteger(this.registerInt1);
            }
            case 2: {
                return new SingleInteger(this.registerInt2);
            }
            case 3: {
                return new SingleInteger(this.registerInt3);
            }
            case 4: {
                return new SingleDouble(this.registerDouble0);
            }
            case 5: {
                return new SingleDouble(this.registerDouble1);
            }
            case 6: {
                return new SingleDouble(this.registerDouble2);
            }
            case 7: {
                return new SingleDouble(this.registerDouble3);
            }
            case 8: {
                return new SingleString(this.registerString0);
            }
            case 9: {
                return new SingleString(this.registerString1);
            }
            case 10: {
                return new SingleString(this.registerString2);
            }
            case 11: {
                return new SingleString(this.registerString3);
            }
            case 12: {
                return new SingleItem(this.registerItem0);
            }
            case 13: {
                return new SingleItem(this.registerItem1);
            }
            case 14: {
                return new SingleItem(this.registerItem2);
            }
            case 15: {
                return new SingleItem(this.registerItem3);
            }
            case 16: {
                return new SingleItem(this.registerItem4);
            }
            case 17: {
                return new SingleItem(this.registerItem5);
            }
            case 18: {
                return new SingleItem(this.registerItem6);
            }
            case 19: {
                return new SingleItem(this.registerItem7);
            }
        }
        return this.locals[n - 20].bornAgain();
    }

    public long loadLocalInteger(int n) throws EvaluationException {
        switch (n) {
            case 0: {
                return this.registerInt0;
            }
            case 1: {
                return this.registerInt1;
            }
            case 2: {
                return this.registerInt2;
            }
            case 3: {
                return this.registerInt3;
            }
            case 4: {
                return (long)this.registerDouble0;
            }
            case 5: {
                return (long)this.registerDouble1;
            }
            case 6: {
                return (long)this.registerDouble2;
            }
            case 7: {
                return (long)this.registerDouble3;
            }
            case 8: {
                return Conversion.toInteger(this.registerString0);
            }
            case 9: {
                return Conversion.toInteger(this.registerString1);
            }
            case 10: {
                return Conversion.toInteger(this.registerString2);
            }
            case 11: {
                return Conversion.toInteger(this.registerString3);
            }
            case 12: {
                return this.registerItem0.getInteger();
            }
            case 13: {
                return this.registerItem1.getInteger();
            }
            case 14: {
                return this.registerItem2.getInteger();
            }
            case 15: {
                return this.registerItem3.getInteger();
            }
            case 16: {
                return this.registerItem4.getInteger();
            }
            case 17: {
                return this.registerItem5.getInteger();
            }
            case 18: {
                return this.registerItem6.getInteger();
            }
            case 19: {
                return this.registerItem7.getInteger();
            }
        }
        XQValue xQValue = this.locals[n - 20].bornAgain();
        if (!xQValue.next()) {
            throw new XQTypeException("empty sequence not allowed");
        }
        long l = xQValue.getInteger();
        if (xQValue.next()) {
            throw new XQTypeException("more than one item is not allowed");
        }
        return l;
    }

    public double loadLocalDouble(int n) throws EvaluationException {
        switch (n) {
            case 0: {
                return this.registerInt0;
            }
            case 1: {
                return this.registerInt1;
            }
            case 2: {
                return this.registerInt2;
            }
            case 3: {
                return this.registerInt3;
            }
            case 4: {
                return this.registerDouble0;
            }
            case 5: {
                return this.registerDouble1;
            }
            case 6: {
                return this.registerDouble2;
            }
            case 7: {
                return this.registerDouble3;
            }
            case 8: {
                return Conversion.toDouble(this.registerString0);
            }
            case 9: {
                return Conversion.toDouble(this.registerString1);
            }
            case 10: {
                return Conversion.toDouble(this.registerString2);
            }
            case 11: {
                return Conversion.toDouble(this.registerString3);
            }
            case 12: {
                return this.registerItem0.getDouble();
            }
            case 13: {
                return this.registerItem1.getDouble();
            }
            case 14: {
                return this.registerItem2.getDouble();
            }
            case 15: {
                return this.registerItem3.getDouble();
            }
            case 16: {
                return this.registerItem4.getDouble();
            }
            case 17: {
                return this.registerItem5.getDouble();
            }
            case 18: {
                return this.registerItem6.getDouble();
            }
            case 19: {
                return this.registerItem7.getDouble();
            }
        }
        XQValue xQValue = this.locals[n - 20].bornAgain();
        if (!xQValue.next()) {
            throw EmptyException.instance();
        }
        double d = xQValue.getDouble();
        if (xQValue.next()) {
            throw new XQTypeException("more than one item is not allowed");
        }
        return d;
    }

    public String loadLocalString(int n) throws EvaluationException {
        switch (n) {
            case 0: {
                return Conversion.toString(this.registerInt0);
            }
            case 1: {
                return Conversion.toString(this.registerInt1);
            }
            case 2: {
                return Conversion.toString(this.registerInt2);
            }
            case 3: {
                return Conversion.toString(this.registerInt3);
            }
            case 4: {
                return Conversion.toString(this.registerDouble0);
            }
            case 5: {
                return Conversion.toString(this.registerDouble1);
            }
            case 6: {
                return Conversion.toString(this.registerDouble2);
            }
            case 7: {
                return Conversion.toString(this.registerDouble3);
            }
            case 8: {
                return this.registerString0;
            }
            case 9: {
                return this.registerString1;
            }
            case 10: {
                return this.registerString2;
            }
            case 11: {
                return this.registerString3;
            }
            case 12: {
                return this.registerItem0.getString();
            }
            case 13: {
                return this.registerItem1.getString();
            }
            case 14: {
                return this.registerItem2.getString();
            }
            case 15: {
                return this.registerItem3.getString();
            }
            case 16: {
                return this.registerItem4.getString();
            }
            case 17: {
                return this.registerItem5.getString();
            }
            case 18: {
                return this.registerItem6.getString();
            }
            case 19: {
                return this.registerItem7.getString();
            }
        }
        XQValue xQValue = this.locals[n - 20].bornAgain();
        if (!xQValue.next()) {
            return null;
        }
        String string = xQValue.getString();
        if (xQValue.next()) {
            throw new XQTypeException("more than one item is not allowed");
        }
        return string;
    }

    public XQItem loadLocalItem(int n) throws EvaluationException {
        switch (n) {
            case 0: {
                return new SingleInteger(this.registerInt0);
            }
            case 1: {
                return new SingleInteger(this.registerInt1);
            }
            case 2: {
                return new SingleInteger(this.registerInt2);
            }
            case 3: {
                return new SingleInteger(this.registerInt3);
            }
            case 4: {
                return new SingleDouble(this.registerDouble0);
            }
            case 5: {
                return new SingleDouble(this.registerDouble1);
            }
            case 6: {
                return new SingleDouble(this.registerDouble2);
            }
            case 7: {
                return new SingleDouble(this.registerDouble3);
            }
            case 8: {
                return new SingleString(this.registerString0);
            }
            case 9: {
                return new SingleString(this.registerString1);
            }
            case 10: {
                return new SingleString(this.registerString2);
            }
            case 11: {
                return new SingleString(this.registerString3);
            }
            case 12: {
                return this.registerItem0;
            }
            case 13: {
                return this.registerItem1;
            }
            case 14: {
                return this.registerItem2;
            }
            case 15: {
                return this.registerItem3;
            }
            case 16: {
                return this.registerItem4;
            }
            case 17: {
                return this.registerItem5;
            }
            case 18: {
                return this.registerItem6;
            }
            case 19: {
                return this.registerItem7;
            }
        }
        XQValue xQValue = this.locals[n - 20].bornAgain();
        if (!xQValue.next()) {
            return null;
        }
        XQItem xQItem = xQValue.getItem();
        if (xQValue.next()) {
            throw new XQTypeException("more than one item is not allowed");
        }
        return xQItem;
    }

    public void storeLocal(LocalVariable localVariable, Expression expression, XQType xQType, boolean bl, Focus focus, EvalContext evalContext) throws EvaluationException {
        switch (localVariable.address) {
            case 0: {
                this.registerInt0 = expression.evalAsInteger(focus, evalContext);
                break;
            }
            case 1: {
                this.registerInt1 = expression.evalAsInteger(focus, evalContext);
                break;
            }
            case 2: {
                this.registerInt2 = expression.evalAsInteger(focus, evalContext);
                break;
            }
            case 3: {
                this.registerInt3 = expression.evalAsInteger(focus, evalContext);
                break;
            }
            case 4: {
                this.registerDouble0 = expression.evalAsDouble(focus, evalContext);
                break;
            }
            case 5: {
                this.registerDouble1 = expression.evalAsDouble(focus, evalContext);
                break;
            }
            case 6: {
                this.registerDouble2 = expression.evalAsDouble(focus, evalContext);
                break;
            }
            case 7: {
                this.registerDouble3 = expression.evalAsDouble(focus, evalContext);
                break;
            }
            case 8: {
                this.registerString0 = expression.evalAsString(focus, evalContext);
                break;
            }
            case 9: {
                this.registerString1 = expression.evalAsString(focus, evalContext);
                break;
            }
            case 10: {
                this.registerString2 = expression.evalAsString(focus, evalContext);
                break;
            }
            case 11: {
                this.registerString3 = expression.evalAsString(focus, evalContext);
                break;
            }
            case 12: {
                this.registerItem0 = expression.evalAsItem(focus, evalContext);
                break;
            }
            case 13: {
                this.registerItem1 = expression.evalAsItem(focus, evalContext);
                break;
            }
            case 14: {
                this.registerItem2 = expression.evalAsItem(focus, evalContext);
                break;
            }
            case 15: {
                this.registerItem3 = expression.evalAsItem(focus, evalContext);
                break;
            }
            case 16: {
                this.registerItem4 = expression.evalAsItem(focus, evalContext);
                break;
            }
            case 17: {
                this.registerItem5 = expression.evalAsItem(focus, evalContext);
                break;
            }
            case 18: {
                this.registerItem6 = expression.evalAsItem(focus, evalContext);
                break;
            }
            case 19: {
                this.registerItem7 = expression.evalAsItem(focus, evalContext);
                break;
            }
            default: {
                try {
                    XQValue xQValue = expression.eval(focus, evalContext);
                    if (xQType != null || localVariable.uses > 1) {
                        xQValue = xQValue.checkTypeExpand(xQType, this, bl, true);
                    }
                    if (xQValue instanceof ErrorValue) {
                        throw new XQTypeException(((ErrorValue)xQValue).getReason());
                    }
                    this.locals[localVariable.address - 20] = xQValue;
                    break;
                }
                catch (XQTypeException xQTypeException) {
                    this.error(expression, xQTypeException);
                }
            }
        }
    }

    public void storeLocal(int n, XQValue xQValue, boolean bl, XQType xQType) throws EvaluationException {
        if (n < 20 && !bl && !xQValue.next()) {
            throw new XQTypeException("empty sequence not allowed");
        }
        switch (n) {
            case 0: {
                this.registerInt0 = xQValue.getInteger();
                break;
            }
            case 1: {
                this.registerInt1 = xQValue.getInteger();
                break;
            }
            case 2: {
                this.registerInt2 = xQValue.getInteger();
                break;
            }
            case 3: {
                this.registerInt3 = xQValue.getInteger();
                break;
            }
            case 4: {
                this.registerDouble0 = xQValue.getDouble();
                break;
            }
            case 5: {
                this.registerDouble1 = xQValue.getDouble();
                break;
            }
            case 6: {
                this.registerDouble2 = xQValue.getDouble();
                break;
            }
            case 7: {
                this.registerDouble3 = xQValue.getDouble();
                break;
            }
            case 8: {
                this.registerString0 = xQValue.getString();
                break;
            }
            case 9: {
                this.registerString1 = xQValue.getString();
                break;
            }
            case 10: {
                this.registerString2 = xQValue.getString();
                break;
            }
            case 11: {
                this.registerString3 = xQValue.getString();
                break;
            }
            case 12: {
                this.registerItem0 = xQValue.getItem();
                break;
            }
            case 13: {
                this.registerItem1 = xQValue.getItem();
                break;
            }
            case 14: {
                this.registerItem2 = xQValue.getItem();
                break;
            }
            case 15: {
                this.registerItem3 = xQValue.getItem();
                break;
            }
            case 16: {
                this.registerItem4 = xQValue.getItem();
                break;
            }
            case 17: {
                this.registerItem5 = xQValue.getItem();
                break;
            }
            case 18: {
                this.registerItem6 = xQValue.getItem();
                break;
            }
            case 19: {
                this.registerItem7 = xQValue.getItem();
                break;
            }
            default: {
                if (xQType != null && !xQType.acceptsItem(xQValue)) {
                    throw new XQTypeException("invalid type");
                }
                this.locals[n - 20] = bl ? new SingleItem(xQValue.getItem()) : xQValue;
            }
        }
    }

    public void storeLocalItem(int n, XQItem xQItem) throws EvaluationException {
        switch (n) {
            case 0: {
                this.registerInt0 = xQItem.getInteger();
                break;
            }
            case 1: {
                this.registerInt1 = xQItem.getInteger();
                break;
            }
            case 2: {
                this.registerInt2 = xQItem.getInteger();
                break;
            }
            case 3: {
                this.registerInt3 = xQItem.getInteger();
                break;
            }
            case 4: {
                this.registerDouble0 = xQItem.getDouble();
                break;
            }
            case 5: {
                this.registerDouble1 = xQItem.getDouble();
                break;
            }
            case 6: {
                this.registerDouble2 = xQItem.getDouble();
                break;
            }
            case 7: {
                this.registerDouble3 = xQItem.getDouble();
                break;
            }
            case 8: {
                this.registerString0 = xQItem.getString();
                break;
            }
            case 9: {
                this.registerString1 = xQItem.getString();
                break;
            }
            case 10: {
                this.registerString2 = xQItem.getString();
                break;
            }
            case 11: {
                this.registerString3 = xQItem.getString();
                break;
            }
            case 12: {
                this.registerItem0 = xQItem;
                break;
            }
            case 13: {
                this.registerItem1 = xQItem;
                break;
            }
            case 14: {
                this.registerItem2 = xQItem;
                break;
            }
            case 15: {
                this.registerItem3 = xQItem;
                break;
            }
            case 16: {
                this.registerItem4 = xQItem;
                break;
            }
            case 17: {
                this.registerItem5 = xQItem;
                break;
            }
            case 18: {
                this.registerItem6 = xQItem;
                break;
            }
            case 19: {
                this.registerItem7 = xQItem;
                break;
            }
            default: {
                this.locals[n - 20] = new SingleItem(xQItem);
            }
        }
    }

    public void storeLocalInteger(int n, long l) {
        switch (n) {
            case 0: {
                this.registerInt0 = l;
                break;
            }
            case 1: {
                this.registerInt1 = l;
                break;
            }
            case 2: {
                this.registerInt2 = l;
                break;
            }
            case 3: {
                this.registerInt3 = l;
                break;
            }
            default: {
                this.locals[n - 20] = new SingleInteger(l);
            }
        }
    }

    public void storeScore(int n, double d) throws EvaluationException {
        if (d < 0.0) {
            d = 0.0;
        }
        switch (n) {
            case 4: {
                this.registerDouble0 = d;
                break;
            }
            case 5: {
                this.registerDouble1 = d;
                break;
            }
            case 6: {
                this.registerDouble2 = d;
                break;
            }
            case 7: {
                this.registerDouble3 = d;
                break;
            }
            default: {
                this.locals[n - 20] = new SingleDouble(d);
            }
        }
    }

    public XQValue getDocument(String string) throws EvaluationException {
        try {
            return new SingleNode(this.dynCtx.getDocument(string));
        }
        catch (DataModelException dataModelException) {
            throw new EvaluationException(dataModelException.getMessage(), dataModelException);
        }
    }

    public Collator getCollator(String string) {
        return this.dynCtx.getCollator(string);
    }

    public Collator getCollator() {
        return this.defaultCollator;
    }

    public DateTime getCurrentDate() {
        return this.dynCtx.getCurrentDate();
    }

    public int getImplicitTimezone() {
        return this.dynCtx.getImplicitTimezone();
    }

    public TraceObserver getTraceListener() {
        return this.dynCtx.traceListener;
    }

    public XQValue evalPath(PathExpr pathExpr, Focus focus) throws EvaluationException {
        return this.dynCtx.eval(pathExpr, focus, this);
    }

    public boolean emptyGreatest() {
        return this.dynCtx.mainQuery.getDefaultOrderEmptyGreatest();
    }

    public boolean sObs() {
        return this.dynCtx.mainQuery.getStrictCompliance();
    }

    public DynamicContext dynamicContext() {
        return this.dynCtx;
    }

    public Object getProperty(String string) {
        return this.dynCtx.getProperty(string);
    }

    public NamespaceContext getInScopeNS() {
        return this.constructorNS != null && this.constructorNS.size() > 0 ? this.constructorNS : this.getStaticContext().getInScopeNS();
    }

    public void setInScopeNS(NamespaceContext namespaceContext) {
        this.constructorNS = namespaceContext;
    }

    public Updates haveUpdateList() {
        return this.dynamicContext().haveUpdateList();
    }

    static {
        DM_ERRCODE = IQName.get("XQDM0001");
    }
}

