/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery;

import com.qizx.api.CompilationException;
import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Message;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.TraceObserver;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.api.fulltext.TextTokenizer;
import com.qizx.api.util.NodeSource;
import com.qizx.api.util.PushStreamToSAX;
import com.qizx.api.util.time.DateTime;
import com.qizx.queries.FullText;
import com.qizx.util.basic.FileUtil;
import com.qizx.util.basic.PlatformUtil;
import com.qizx.util.basic.Util;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.IDocument;
import com.qizx.xdm.XMLPushStreamBase;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExpressionImpl;
import com.qizx.xquery.Focus;
import com.qizx.xquery.MainQuery;
import com.qizx.xquery.ModuleManager;
import com.qizx.xquery.UpdaterFactory;
import com.qizx.xquery.Updates;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.XQuerySessionImpl;
import com.qizx.xquery.dt.ArraySequence;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.GlobalVariable;
import com.qizx.xquery.op.PathExpr;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.TimeZone;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;

public class DynamicContext
implements UpdaterFactory {
    public static final String XSLT_OUTPUT_FILE = "output-file";
    protected XQuerySessionImpl session;
    protected MainQuery mainQuery;
    protected URI baseURI;
    protected HashMap globals;
    protected HashMap<String, BasicNode> documents;
    protected XQValue defaultCollection;
    protected TraceObserver traceListener;
    protected PrintWriter compilationTrace;
    private HashMap<String, Object> propertyMap;
    protected volatile int monitorMode;
    protected EvalContext lastContext;
    protected int timeZone;
    protected TextTokenizer tokenizer;
    protected DateTime currentDate;
    protected ModuleManager moduleMan;
    protected Updates updateStack;
    protected UpdaterFactory updaterFactory = this;

    DynamicContext(MainQuery mainQuery, XQuerySessionImpl xQuerySessionImpl) {
        this.session = xQuerySessionImpl;
        this.mainQuery = mainQuery;
        this.globals = new HashMap();
        this.documents = new HashMap();
        if (xQuerySessionImpl != null) {
            this.moduleMan = xQuerySessionImpl.getModuleManager();
        }
    }

    public Collator getCollator(String string) {
        return this.mainQuery.getCollator(string);
    }

    public PrintWriter getTraceOutput() {
        return this.compilationTrace;
    }

    public Object getProperty(String string) {
        return this.propertyMap == null ? null : this.propertyMap.get(string);
    }

    public void setProperty(String string, Object object) {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap();
        }
        this.propertyMap.put(string, object);
    }

    public Object getSessionProperty(String string) {
        return this.session.getProperty(string);
    }

    public void setSessionProperty(String string, Object object) {
        this.session.setProperty(string, object);
    }

    public int getCopyNSMode() {
        return this.mainQuery.getCopyNSMode();
    }

    public FullText.MatchOptions getDefaultFTOptions() {
        return this.mainQuery.getDefaultFTOptions();
    }

    public FullTextFactory getFulltextFactory() {
        return this.session.getFullTextFactory();
    }

    public TextTokenizer getTextTokenizer() {
        if (this.tokenizer == null) {
            this.tokenizer = this.getFulltextFactory().getTokenizer(this.getDefaultFTOptions().language);
        }
        return this.tokenizer;
    }

    public XQValue getDefaultCollection() {
        if (this.defaultCollection == null) {
            return null;
        }
        return this.defaultCollection.bornAgain();
    }

    public XQValue getCollectionSequence(String string) throws DataModelException {
        return this.expandBasicCollection(string);
    }

    public XQValue expandBasicCollection(String string) throws DataModelException {
        String[] stringArray = string.split("[;,]");
        ArraySequence arraySequence = new ArraySequence(stringArray.length, null);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = FileUtil.fileBaseName(string2);
            if (string3.indexOf(42) < 0 && string3.indexOf(63) < 0) {
                arraySequence.addItem(this.getDocument(string2));
                continue;
            }
            File[] fileArray = FileUtil.expandPathPattern(new File(string2));
            for (int j = 0; j < fileArray.length; ++j) {
                arraySequence.addItem(this.getDocument(fileArray[j].getAbsolutePath()));
            }
        }
        if (arraySequence.getSize() == 0) {
            throw new DataModelException("empty collection " + string);
        }
        return arraySequence;
    }

    public BasicNode getDocument(String string) throws DataModelException {
        try {
            String string2;
            BasicNode basicNode;
            if (PlatformUtil.IS_WINDOWS) {
                string = string.replace('\\', '/');
            }
            if ((basicNode = this.documents.get(string2 = this.resolveURI(string))) == null) {
                basicNode = this.session.getDocument(string2);
                if (basicNode != null) {
                    this.documents.put(string2, basicNode);
                } else {
                    throw new DataModelException("document " + string + " not found");
                }
            }
            return basicNode;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DataModelException("invalid document URI: " + string);
        }
    }

    protected String resolveURI(String string) throws URISyntaxException {
        Object object;
        if (this.baseURI == null) {
            object = this.mainQuery.getBaseURI();
            if (object == null) {
                try {
                    object = FileUtil.fileToSystemId(new File(".")) + "/";
                }
                catch (IOException iOException) {
                    object = "file:///.";
                }
            }
            this.baseURI = URI.create(Util.escapeURI((String)object));
        }
        object = new URI(Util.escapeURI(string));
        URI uRI = this.baseURI.resolve((URI)object);
        return uRI.toString();
    }

    public String getNSPrefix(String string) {
        return this.mainQuery.getNSPrefix(string);
    }

    public DateTime getCurrentDate() {
        return this.currentDate;
    }

    public void setDate(Date date, TimeZone timeZone) {
        this.timeZone = timeZone.getRawOffset() / 60000;
        this.currentDate = new DateTime(date == null ? new Date() : date, this.timeZone);
    }

    public int getImplicitTimezone() {
        return this.timeZone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        DynamicContext dynamicContext = this;
        synchronized (dynamicContext) {
            this.monitorMode = 1;
            this.notify();
        }
    }

    public void setTimedOut() {
        this.monitorMode = 2;
    }

    public void suspend() {
        this.monitorMode = 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(boolean bl) {
        DynamicContext dynamicContext = this;
        synchronized (dynamicContext) {
            this.monitorMode = bl ? 0 : 3;
            this.notify();
        }
    }

    public XQValue eval(PathExpr pathExpr, Focus focus, EvalContext evalContext) throws EvaluationException {
        XQValue xQValue = pathExpr.getStep(0).eval(focus, evalContext);
        return pathExpr.evalNextSteps(xQValue, 1, evalContext);
    }

    public Expression checkExpression(Expression expression) throws CompilationException {
        return this.session.staticCheck(expression, this.mainQuery);
    }

    public ExpressionImpl compileExpression(String string) throws EvaluationException {
        try {
            return this.session.compile(string, this.mainQuery);
        }
        catch (CompilationException compilationException) {
            Message[] messageArray = compilationException.getMessages();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.print("in eval() function: ");
            printWriter.println(compilationException.getMessage());
            for (int i = 0; i < messageArray.length; ++i) {
                messageArray[i].print(printWriter, false);
            }
            printWriter.flush();
            throw new EvaluationException(stringWriter.toString(), compilationException);
        }
    }

    public void passVariablesTo(ExpressionImpl expressionImpl) throws CompilationException {
        HashMap hashMap = expressionImpl.externGlobals;
        for (Object object : hashMap.keySet()) {
            expressionImpl.rawBindVariable((QName)object, (XQValue)hashMap.get(object));
        }
        for (Object object : this.globals.keySet()) {
            expressionImpl.rawBindVariable(((GlobalVariable)object).name, (XQValue)this.globals.get(object));
        }
    }

    public IDocument xslTransform(Node node, String string, Properties properties, Properties properties2) throws EvaluationException {
        try {
            String string2;
            Enumeration<Object> enumeration;
            Templates templates = this.moduleMan.loadTemplates(string);
            Transformer transformer = templates.newTransformer();
            NodeSource nodeSource = null;
            Object object = null;
            IDocument iDocument = null;
            nodeSource = new NodeSource(node);
            String string3 = properties2.getProperty(XSLT_OUTPUT_FILE);
            if (string3 != null) {
                object = new StreamResult(string3);
            } else {
                iDocument = new IDocument();
                enumeration = new SAXResult();
                ((SAXResult)((Object)enumeration)).setHandler(iDocument);
                ((SAXResult)((Object)enumeration)).setLexicalHandler(iDocument);
                ((SAXResult)((Object)enumeration)).setSystemId(FileUtil.fileToURLName("."));
                object = enumeration;
            }
            enumeration = properties2.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (string2.equals(XSLT_OUTPUT_FILE)) continue;
                transformer.setOutputProperty(string2, properties2.getProperty(string2));
            }
            enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                transformer.setParameter(string2, properties.get(string2));
            }
            transformer.transform(nodeSource, (Result)object);
            return iDocument;
        }
        catch (TransformerException transformerException) {
            throw new EvaluationException(transformerException.getMessage(), transformerException);
        }
    }

    public Updates pushUpdates() {
        this.updateStack = new Updates(this, this.updateStack);
        return this.updateStack;
    }

    public void popUpdates() {
        if (this.updateStack != null) {
            this.updateStack = this.updateStack.getEnclosing();
        }
    }

    public Updates haveUpdateList() {
        if (this.updateStack == null) {
            this.updateStack = new Updates(this, this.updateStack);
        }
        return this.updateStack;
    }

    public void applyUpdates() throws EvaluationException {
        if (this.updateStack != null) {
            this.updateStack.apply();
            if (this.updateStack.getEnclosing() != null) {
                System.err.println("OOPS improperly unstacked PUL");
            }
        }
    }

    public XMLPushStreamBase newLibraryDocument(String string) throws DataModelException {
        return null;
    }

    public XMLPushStreamBase newParsedDocument(String string) {
        IDocument iDocument = new IDocument();
        iDocument.setBaseURI(string);
        return new PushStreamToSAX(iDocument);
    }

    public void endParsedDocument() throws DataModelException {
    }

    public UpdaterFactory getUpdaterFactory() {
        return this.updaterFactory;
    }

    public void setUpdaterFactory(UpdaterFactory updaterFactory) {
        this.updaterFactory = updaterFactory;
    }
}

