/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.ItemType;
import com.qizx.api.Node;
import com.qizx.api.util.time.Date;
import com.qizx.api.util.time.DateTime;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.BaseValue;
import com.qizx.xquery.ComparisonContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.SingleString;
import com.qizx.xquery.dt.UntypedAtomicType;

public abstract class NodeSequenceBase
extends BaseValue {
    public static final NodeSequenceBase noNodes = new NodeSequenceBase(){

        public boolean next() {
            return false;
        }

        public BasicNode basicNode() {
            return null;
        }

        public XQValue bornAgain() {
            return null;
        }
    };

    public ItemType getType() throws EvaluationException {
        return XQType.NODE;
    }

    public XQItemType getItemType() {
        return XQType.NODE;
    }

    public boolean isNode() {
        return true;
    }

    public Node getNode() {
        return this.basicNode();
    }

    public XQItem getItem() {
        return this.basicNode();
    }

    public abstract BasicNode basicNode();

    public XQItem asAtom() throws EvaluationException {
        try {
            return new SingleString(this.getNode().getStringValue(), XQType.UNTYPED_ATOMIC);
        }
        catch (DataModelException dataModelException) {
            throw BasicNode.wrapDMException(dataModelException);
        }
    }

    public boolean getBoolean() throws EvaluationException {
        return true;
    }

    public String getString() throws EvaluationException {
        try {
            return this.getNode().getStringValue();
        }
        catch (DataModelException dataModelException) {
            throw BasicNode.wrapDMException(dataModelException);
        }
    }

    public long getInteger() throws EvaluationException {
        return Conversion.toInteger(this.getString());
    }

    public double getDouble() throws EvaluationException {
        try {
            return Conversion.toDouble(this.getString());
        }
        catch (EvaluationException evaluationException) {
            double d = ((BasicNode)this.getNode()).getDoubleByRules();
            if (d == d) {
                return d;
            }
            throw evaluationException;
        }
    }

    public float getFloat() throws EvaluationException {
        try {
            return Conversion.toFloat(this.getString());
        }
        catch (EvaluationException evaluationException) {
            double d = ((BasicNode)this.getNode()).getDoubleByRules();
            if (d == d) {
                return (float)d;
            }
            throw evaluationException;
        }
    }

    public Date getDate() throws EvaluationException, DateTimeException {
        return this.basicNode().getDate();
    }

    public DateTime getDateTime() throws EvaluationException, DateTimeException {
        return this.basicNode().getDateTime();
    }

    public int compareTo(XQItem xQItem, ComparisonContext comparisonContext, int n) throws EvaluationException {
        return UntypedAtomicType.comparison(this, xQItem, comparisonContext, n);
    }
}

