/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Item;
import com.qizx.api.ItemType;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.QizxException;
import com.qizx.api.XMLPullStream;
import com.qizx.api.util.PushStreamToDOM;
import com.qizx.api.util.time.Date;
import com.qizx.api.util.time.DateTime;
import com.qizx.api.util.time.DateTimeBase;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.api.util.time.Duration;
import com.qizx.util.Collations;
import com.qizx.util.NamespaceContext;
import com.qizx.util.basic.Comparison;
import com.qizx.util.basic.FileUtil;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.Conversion;
import com.qizx.xdm.DataConversion;
import com.qizx.xdm.FONIDocument;
import com.qizx.xdm.IQName;
import com.qizx.xdm.NodeFilter;
import com.qizx.xdm.NodePullStream;
import com.qizx.xdm.NodeSequenceBase;
import com.qizx.xquery.ComparisonContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.NodeType;
import com.qizx.xquery.dt.UntypedAtomicType;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;

public class FONIDataModel {
    private static NodeSequenceBase empty = null;
    private FONIDocument dom;
    private FONINode root;
    private DataConversion dataConversion;

    public FONIDataModel(FONIDocument fONIDocument) {
        this.dom = fONIDocument;
        if (fONIDocument.getOwner() != null) {
            this.dataConversion = fONIDocument.getOwner().getDataConversion();
        }
    }

    public FONIDocument getDom() {
        return this.dom;
    }

    public BasicNode getDocumentNode() throws DataModelException {
        if (this.root == null) {
            this.root = this.newNode(this.dom.getRootNode());
        }
        return this.root;
    }

    public FONINode newNode(int n) {
        if (n == 0) {
            return null;
        }
        return new FONINode(n, this);
    }

    public Node newDmNode(int n) {
        return this.newNode(n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FONIDataModel)) {
            return false;
        }
        FONIDataModel fONIDataModel = (FONIDataModel)object;
        return this.dom.equals(fONIDataModel.dom);
    }

    public int hashCode() {
        return this.dom.hashCode();
    }

    public static String getNsPrefix(FONIDocument fONIDocument, int n, String string) throws DataModelException {
        while (n != 0) {
            int n2 = fONIDocument.getFirstNSNode(n);
            while (n2 != 0) {
                if (string.equals(fONIDocument.pnGetStringValue(n2))) {
                    return fONIDocument.pnGetName(n2).getLocalPart();
                }
                n2 = fONIDocument.pnGetNext(n2);
            }
            n = fONIDocument.getParent(n);
        }
        return null;
    }

    public static String getNsUri(FONIDocument fONIDocument, int n, String string) throws DataModelException {
        while (n != 0) {
            int n2 = fONIDocument.getFirstNSNode(n);
            while (n2 != 0) {
                if (string.equals(fONIDocument.pnGetName(n2).getLocalPart())) {
                    return fONIDocument.pnGetStringValue(n2);
                }
                n2 = fONIDocument.pnGetNext(n2);
            }
            n = fONIDocument.getParent(n);
        }
        return null;
    }

    public static int addNsTo(FONIDocument fONIDocument, int n, NamespaceContext namespaceContext) throws DataModelException {
        int n2 = 0;
        int n3 = fONIDocument.getFirstNSNode(n);
        while (n3 != 0) {
            namespaceContext.addMapping(fONIDocument.pnGetName(n3).getLocalPart(), fONIDocument.pnGetStringValue(n3));
            ++n2;
            n3 = fONIDocument.pnGetNext(n3);
        }
        return n2;
    }

    public static int addUsedNsTo(FONIDocument fONIDocument, int n, NamespaceContext namespaceContext) throws DataModelException {
        int n2 = 0;
        IQName iQName = fONIDocument.getName(n);
        String string = iQName.getNamespaceURI();
        if (string != "") {
            namespaceContext.addMapping(FONIDataModel.getNsPrefix(fONIDocument, n, string), string);
            ++n2;
        }
        int n3 = fONIDocument.getAttribute(n, -1);
        while (n3 != 0) {
            iQName = fONIDocument.pnGetName(n3);
            string = iQName.getNamespaceURI();
            if (string != "") {
                namespaceContext.addMapping(FONIDataModel.getNsPrefix(fONIDocument, n, string), string);
                ++n2;
            }
            n3 = fONIDocument.pnGetNext(n3);
        }
        return n2;
    }

    public static void addInscopeNsTo(FONIDocument fONIDocument, int n, NamespaceContext namespaceContext) throws DataModelException {
        int n2 = fONIDocument.getParent(n);
        if (n2 != 0) {
            FONIDataModel.addInscopeNsTo(fONIDocument, n2, namespaceContext);
        }
        FONIDataModel.addNsTo(fONIDocument, n, namespaceContext);
    }

    static class Attributes
    extends ASequence {
        NodeFilter nodeTest;

        Attributes(int n, NodeFilter nodeFilter, FONIDataModel fONIDataModel) throws DataModelException {
            super(n, 0, fONIDataModel);
            this.firstId = fONIDataModel.dom.getAttribute(n, -1);
            this.curId = -this.firstId;
            this.nodeTest = nodeFilter;
        }

        boolean checkNode() throws EvaluationException {
            if (this.curId == 0) {
                return false;
            }
            try {
                return this.nodeTest == null || (this.nodeTest.needsNode() ? this.nodeTest.accepts(this.makeNode(this.curId)) : this.nodeTest.accepts(3, this.getDom().pnGetName(this.curId)));
            }
            catch (DataModelException dataModelException) {
                throw BasicNode.wrapDMException(dataModelException);
            }
        }

        public XQValue bornAgain() {
            try {
                return new Attributes(this.ownerId, this.nodeTest, this.dm);
            }
            catch (DataModelException dataModelException) {
                return XQValue.empty;
            }
        }

        public boolean next() throws EvaluationException {
            while (super.next()) {
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    static class ASequence
    extends NodeSequenceBase {
        FONIDataModel dm;
        int ownerId;
        int firstId;
        int curId;

        ASequence(int n, int n2, FONIDataModel fONIDataModel) {
            this.ownerId = n;
            this.firstId = n2;
            this.curId = -n2;
            this.dm = fONIDataModel;
        }

        public boolean next() throws EvaluationException {
            if (this.curId <= 0) {
                this.curId = -this.curId;
            } else {
                try {
                    this.curId = this.dm.dom.pnGetNext(this.curId);
                }
                catch (DataModelException dataModelException) {
                    BasicNode.wrapDMException(dataModelException);
                }
            }
            return this.curId != 0;
        }

        public BasicNode basicNode() {
            return this.curId == 0 ? null : this.makeNode(this.curId);
        }

        public XQItemType getItemType() {
            return XQType.ATTRIBUTE;
        }

        ANode makeNode(int n) {
            return new ANode(this.ownerId, n, this.dm);
        }

        public XQValue bornAgain() {
            return new ASequence(this.ownerId, this.firstId, this.dm);
        }

        public final FONIDocument getDom() {
            return this.dm.dom;
        }
    }

    static class Preceding
    extends PrecedingSiblings {
        Preceding(int n, NodeFilter nodeFilter, FONIDataModel fONIDataModel) throws DataModelException {
            super(n, nodeFilter, fONIDataModel);
            this.curId = this.getDom().getRootNode();
        }

        public XQValue bornAgain() {
            try {
                return new Preceding(this.startId, this.nodeTest, this.dm);
            }
            catch (DataModelException dataModelException) {
                return XQValue.empty;
            }
        }

        public boolean next() throws EvaluationException {
            try {
                while (this.curId != 0) {
                    if (this.started) {
                        this.curId = this.getDom().getNodeNext(this.curId);
                    }
                    this.started = true;
                    if (this.curId == this.startId) {
                        this.curId = 0;
                        return false;
                    }
                    if (this.isAncestor(this.curId) || !this.checkNode()) continue;
                    return true;
                }
            }
            catch (DataModelException dataModelException) {
                BasicNode.wrapDMException(dataModelException);
            }
            return false;
        }

        private boolean isAncestor(int n) throws DataModelException {
            int n2 = this.startId - n;
            return n2 >= 0 && n2 < this.getDom().getNodeSpan(n);
        }
    }

    static class PrecedingSiblings
    extends TypedSequence {
        PrecedingSiblings(int n, NodeFilter nodeFilter, FONIDataModel fONIDataModel) throws DataModelException {
            super(n, nodeFilter, fONIDataModel);
            this.curId = this.getDom().getFirstChild(this.getDom().getParent(n));
        }

        public XQValue bornAgain() {
            try {
                return new PrecedingSiblings(this.startId, this.nodeTest, this.dm);
            }
            catch (DataModelException dataModelException) {
                return XQValue.empty;
            }
        }

        public boolean next() throws EvaluationException {
            while (this.curId != 0) {
                if (this.started) {
                    try {
                        this.curId = this.getDom().getNextSibling(this.curId);
                    }
                    catch (DataModelException dataModelException) {
                        BasicNode.wrapDMException(dataModelException);
                    }
                }
                this.started = true;
                if (this.curId == this.startId) {
                    this.curId = 0;
                    return false;
                }
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    static class Following
    extends TypedSequence {
        Following(int n, NodeFilter nodeFilter, FONIDataModel fONIDataModel) {
            super(n, nodeFilter, fONIDataModel);
            try {
                this.curId = this.getDom().getNodeAfter(n);
            }
            catch (DataModelException dataModelException) {
                // empty catch block
            }
        }

        public XQValue bornAgain() {
            return new Following(this.startId, this.nodeTest, this.dm);
        }

        public boolean next() throws EvaluationException {
            while (this.curId != 0) {
                try {
                    if (this.started) {
                        this.curId = this.getDom().getNodeNext(this.curId);
                    }
                    this.started = true;
                }
                catch (DataModelException dataModelException) {
                    BasicNode.wrapDMException(dataModelException);
                }
                if (this.curId == 0 || !this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    static class FollowingSiblings
    extends TypedSequence {
        FollowingSiblings(int n, NodeFilter nodeFilter, FONIDataModel fONIDataModel) {
            super(n, nodeFilter, fONIDataModel);
        }

        public XQValue bornAgain() {
            return new FollowingSiblings(this.startId, this.nodeTest, this.dm);
        }

        public boolean next() throws EvaluationException {
            while (this.curId != 0) {
                try {
                    this.curId = this.getDom().getNextSibling(this.curId);
                }
                catch (DataModelException dataModelException) {
                    BasicNode.wrapDMException(dataModelException);
                }
                if (this.curId == 0 || !this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    static class Descendants
    extends DescendantsOrSelf {
        Descendants(int n, NodeFilter nodeFilter, FONIDataModel fONIDataModel) throws DataModelException {
            super(n, nodeFilter, fONIDataModel);
            this.started = true;
        }

        public XQValue bornAgain() {
            try {
                return new Descendants(this.startId, this.nodeTest, this.dm);
            }
            catch (DataModelException dataModelException) {
                return XQValue.empty;
            }
        }
    }

    static class DescendantsOrSelf
    extends TypedSequence {
        int lastNode;

        DescendantsOrSelf(int n, NodeFilter nodeFilter, FONIDataModel fONIDataModel) throws DataModelException {
            super(n, nodeFilter, fONIDataModel);
            this.lastNode = this.getDom().getNodeAfter(Math.abs(n));
            if (this.lastNode == 0) {
                this.lastNode = 0x7FFFFFFE;
            }
        }

        DescendantsOrSelf(int n, NodeFilter nodeFilter, FONIDataModel fONIDataModel, int n2) {
            super(n, nodeFilter, fONIDataModel);
            this.lastNode = n2;
        }

        public XQValue bornAgain() {
            return new DescendantsOrSelf(this.startId, this.nodeTest, this.dm, this.lastNode);
        }

        public boolean next() throws EvaluationException {
            while (this.curId != 0) {
                if (this.started) {
                    try {
                        this.curId = this.getDom().getNodeNext(this.curId);
                    }
                    catch (DataModelException dataModelException) {
                        BasicNode.wrapDMException(dataModelException);
                    }
                }
                this.started = true;
                if (this.curId >= this.lastNode) {
                    this.curId = 0;
                    continue;
                }
                if (this.curId == 0 || !this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    static class Children
    extends TypedSequence {
        Children(int n, NodeFilter nodeFilter, FONIDataModel fONIDataModel) throws DataModelException {
            super(n, null, fONIDataModel);
            this.nodeTest = nodeFilter;
            this.curId = this.getDom().getFirstChild(n);
        }

        public XQValue bornAgain() {
            try {
                return new Children(this.startId, this.nodeTest, this.dm);
            }
            catch (DataModelException dataModelException) {
                return XQValue.empty;
            }
        }

        public boolean next() throws EvaluationException {
            while (this.curId != 0) {
                if (this.started) {
                    try {
                        this.curId = this.getDom().getNextSibling(this.curId);
                    }
                    catch (DataModelException dataModelException) {
                        BasicNode.wrapDMException(dataModelException);
                    }
                }
                this.started = true;
                if (this.curId == 0 || !this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    static class Ancestors
    extends AncestorsOrSelf {
        Ancestors(int n, NodeFilter nodeFilter, FONIDataModel fONIDataModel) {
            super(n, nodeFilter, fONIDataModel);
            this.started = true;
        }

        public XQValue bornAgain() {
            return new Ancestors(this.startId, this.nodeTest, this.dm);
        }
    }

    static class AncestorsOrSelf
    extends TypedSequence {
        AncestorsOrSelf(int n, NodeFilter nodeFilter, FONIDataModel fONIDataModel) {
            super(n, nodeFilter, fONIDataModel);
        }

        public boolean next() throws EvaluationException {
            while (this.curId != 0) {
                if (this.started) {
                    try {
                        this.curId = this.getDom().getParent(this.curId);
                    }
                    catch (DataModelException dataModelException) {
                        BasicNode.wrapDMException(dataModelException);
                    }
                }
                this.started = true;
                if (this.curId == 0 || !this.checkNode()) continue;
                return true;
            }
            return false;
        }

        public XQValue bornAgain() {
            return new AncestorsOrSelf(this.startId, this.nodeTest, this.dm);
        }
    }

    static class SingleNode
    extends TypedSequence {
        SingleNode(int n, NodeFilter nodeFilter, FONIDataModel fONIDataModel) {
            super(n, nodeFilter, fONIDataModel);
        }

        public boolean next() throws EvaluationException {
            if (this.started) {
                return false;
            }
            this.started = true;
            return this.checkNode();
        }

        public XQValue bornAgain() {
            return new SingleNode(this.startId, this.nodeTest, this.dm);
        }
    }

    static class Parent
    extends TypedSequence {
        Parent(int n, NodeFilter nodeFilter, FONIDataModel fONIDataModel) {
            super(n, nodeFilter, fONIDataModel);
        }

        public boolean next() throws EvaluationException {
            if (this.started) {
                return false;
            }
            this.started = true;
            try {
                this.curId = this.getDom().getParent(this.curId);
            }
            catch (DataModelException dataModelException) {
                BasicNode.wrapDMException(dataModelException);
            }
            return this.checkNode();
        }

        public XQValue bornAgain() {
            return new Parent(this.startId, this.nodeTest, this.dm);
        }
    }

    static abstract class TypedSequence
    extends ISequence {
        NodeFilter nodeTest;
        boolean started = false;

        TypedSequence(int n, NodeFilter nodeFilter, FONIDataModel fONIDataModel) {
            super(n, fONIDataModel);
            this.nodeTest = nodeFilter;
        }

        boolean checkNode() {
            if (this.curId == 0) {
                return false;
            }
            try {
                return this.nodeTest == null || (this.nodeTest.needsNode() ? this.nodeTest.accepts(this.getNode()) : this.nodeTest.accepts(this.getDom().getKind(this.curId), this.getDom().getName(this.curId)));
            }
            catch (DataModelException dataModelException) {
                return false;
            }
        }

        public NodeSequenceBase restart(int n, FONIDataModel fONIDataModel, NodeFilter nodeFilter) {
            this.started = false;
            this.dm = fONIDataModel;
            this.startId = this.curId = n;
            this.nodeTest = nodeFilter;
            return this;
        }
    }

    static abstract class ISequence
    extends NodeSequenceBase {
        protected FONIDataModel dm;
        int startId;
        int curId;

        ISequence(int n, FONIDataModel fONIDataModel) {
            this.dm = fONIDataModel;
            this.curId = this.startId = n;
            this.itemType = XQType.NODE;
        }

        public int currentId() {
            return this.curId;
        }

        public BasicNode basicNode() {
            return this.curId == 0 ? null : this.dm.newNode(this.curId);
        }

        public ItemType getType() throws EvaluationException {
            try {
                return NodeType.getTypeByKind(this.getDom().getKind(this.curId));
            }
            catch (DataModelException dataModelException) {
                throw BasicNode.wrapDMException(dataModelException);
            }
        }

        public final FONIDocument getDom() {
            return this.dm.dom;
        }

        public double getFulltextScore(Item item) throws EvaluationException {
            return -1.0;
        }
    }

    static class NSNode
    extends ANode {
        NSNode(int n, int n2, FONIDataModel fONIDataModel) {
            super(n, n2, fONIDataModel);
        }

        public String getNodeKind() {
            return "namespace";
        }

        public int getNodeNature() {
            return 4;
        }

        public ItemType getType() {
            return XQType.NAMESPACE;
        }
    }

    static class ANode
    extends FONINode {
        int offset;

        ANode(int n, int n2, FONIDataModel fONIDataModel) {
            super(n, fONIDataModel);
            this.offset = n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ANode)) {
                return false;
            }
            ANode aNode = (ANode)object;
            return aNode.id == this.id && aNode.offset == this.offset && aNode.getDom().equals(this.getDom());
        }

        public int hashCode() {
            return this.id * this.offset;
        }

        public int documentOrderCompareTo(Node node) {
            int n = super.documentOrderCompareTo(node);
            if (n != 0) {
                return n;
            }
            if (!(node instanceof ANode)) {
                return 1;
            }
            ANode aNode = (ANode)node;
            int n2 = this.offset - aNode.offset;
            return n2 < 0 ? -1 : (n2 > 0 ? 1 : 0);
        }

        public int getNodeNature() {
            return 3;
        }

        public String getNodeKind() {
            return "attribute";
        }

        public ItemType getType() {
            return XQType.ATTRIBUTE;
        }

        public QName getNodeName() throws DataModelException {
            IQName iQName = this.getDom().getOtherName(this.getDom().pnGetNameId(this.offset));
            return iQName;
        }

        public String getStringValue() throws DataModelException {
            return this.getDom().pnGetStringValue(this.offset);
        }

        public char[] getCharValue() throws DataModelException {
            return this.getDom().pnGetCharValue(this.offset, 0);
        }

        public double getDoubleByRules() {
            if (this.dm.dataConversion != null) {
                return this.dm.dataConversion.convertNumber(this);
            }
            return Double.NaN;
        }

        public Node getParent() {
            return this.getDM().newNode(this.id);
        }

        public NodeSequenceBase getParent(NodeFilter nodeFilter) {
            return new SingleNode(this.id, nodeFilter, this.dm);
        }

        public BasicNode firstChild() throws DataModelException {
            return null;
        }

        public NodeSequenceBase getChildren() {
            return NodeSequenceBase.noNodes;
        }

        public NodeSequenceBase getDescendants(NodeFilter nodeFilter) {
            return empty;
        }

        public NodeSequenceBase getDescendantsOrSelf(NodeFilter nodeFilter) {
            if (nodeFilter == null || nodeFilter.accepts(this)) {
                return new Parent(this.id, null, this.dm);
            }
            return NodeSequenceBase.noNodes;
        }

        public Node[] getAttributes() {
            return null;
        }
    }

    public static class FONINode
    extends BasicNode {
        public static final int ROOT_DEPTH = -1;
        protected FONIDataModel dm;
        protected int id;

        public FONINode(int n, FONIDataModel fONIDataModel) {
            this.id = n;
            this.dm = fONIDataModel;
        }

        public FONIDataModel getDM() {
            return this.dm;
        }

        public FONIDocument getDom() {
            return this.dm.dom;
        }

        public FONIDocument.Owner getOwner() {
            return this.getDom().getOwner();
        }

        public int getDocId() {
            return this.getDom().getDocumentId();
        }

        public String toString() {
            return this.id + ":" + this.getDom().getDocumentId() + ":" + super.toString();
        }

        public Node getParent() throws DataModelException {
            return this.getDM().newNode(this.getDom().getParent(this.id));
        }

        public BasicNode firstChild() throws DataModelException {
            return this.getDM().newNode(this.getDom().getFirstChild(this.id));
        }

        public BasicNode nextSibling() throws DataModelException {
            return this.getDM().newNode(this.getDom().getNextSibling(this.id));
        }

        public BasicNode basicNode() {
            return this;
        }

        public XQValue getTypedValue() {
            return null;
        }

        public QName getNodeName() throws DataModelException {
            return this.getDom().getName(this.id);
        }

        public String getStringValue() throws DataModelException {
            return this.getDom().getStringValue(this.id);
        }

        public char[] getCharValue() throws DataModelException {
            return this.getDom().getCharValue(this.id, 0);
        }

        public double getDoubleByRules() {
            if (this.dm.dataConversion != null) {
                return this.dm.dataConversion.convertNumber(this);
            }
            return Double.NaN;
        }

        public Date getDate() throws EvaluationException, DateTimeException {
            try {
                return Date.parseDate(this.getStringValue());
            }
            catch (DateTimeException dateTimeException) {
                double d;
                if (this.dm.dataConversion != null && (d = this.dm.dataConversion.convertDate(this)) == d) {
                    return new Date((long)d);
                }
            }
            catch (DataModelException dataModelException) {
                // empty catch block
            }
            throw new XQTypeException(Conversion.ERR_CAST, "cannot cast to xs:date: invalid value");
        }

        public DateTime getDateTime() throws EvaluationException, DateTimeException {
            try {
                return DateTime.parseDateTime(this.getStringValue());
            }
            catch (DateTimeException dateTimeException) {
                double d;
                if (this.dm.dataConversion != null && (d = this.dm.dataConversion.convertDate(this)) == d) {
                    return new DateTime((long)d);
                }
            }
            catch (DataModelException dataModelException) {
                // empty catch block
            }
            throw new XQTypeException(Conversion.ERR_CAST, "cannot cast to xs:dateTime: invalid value");
        }

        public int getNodeNature() throws DataModelException {
            return this.getDom().getKind(this.id);
        }

        public String getNodeKind() throws DataModelException {
            switch (this.getDom().getKind(this.id)) {
                case 1: {
                    return "document";
                }
                case 2: {
                    return "element";
                }
                case 3: {
                    return "attribute";
                }
                case 7: {
                    return "text";
                }
                case 5: {
                    return "processing-instruction";
                }
                case 6: {
                    return "comment";
                }
                case 4: {
                    return "namespace";
                }
            }
            throw new DataModelException("wrong FONInode, id=" + this.id);
        }

        public String getDocumentURI() throws DataModelException {
            return this.getDom().getBaseURI();
        }

        public String getBaseURI() throws DataModelException {
            FONIDocument fONIDocument = this.getDom();
            int n = fONIDocument.internOtherName(IQName.XML_BASE);
            if (n >= 0) {
                try {
                    return FONINode.getBaseUri(fONIDocument, this.id, n);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new DataModelException(uRISyntaxException.getMessage());
                }
            }
            return fONIDocument.getBaseURI();
        }

        private static String getBaseUri(FONIDocument fONIDocument, int n, int n2) throws URISyntaxException, DataModelException {
            int n3 = n;
            while (n3 != 0) {
                int n4 = fONIDocument.getAttribute(n3, n2);
                if (n4 != 0) {
                    String string = fONIDocument.pnGetStringValue(n4);
                    URI uRI = FileUtil.uriConvert(string);
                    if (uRI != null && uRI.isAbsolute()) {
                        return string;
                    }
                    return FileUtil.resolve(FONINode.getBaseUri(fONIDocument, fONIDocument.getParent(n3), n2), string);
                }
                n3 = fONIDocument.getParent(n3);
            }
            return fONIDocument.getBaseURI();
        }

        public String[] getDTDInfo() throws DataModelException {
            return this.getDom().getDTDInfo();
        }

        public int docPosition() {
            FONIDocument.Owner owner = this.dm.getDom().getOwner();
            if (owner != null) {
                return owner.hashCode() + this.getDom().getDocumentId();
            }
            return this.dm.hashCode();
        }

        public boolean contains(Node node) throws DataModelException {
            if (!(node instanceof FONINode)) {
                return false;
            }
            int n = ((FONINode)node).id - this.id;
            return n >= 0 && n < this.getDom().getNodeSpan(this.id);
        }

        public int getNodeSpan() throws DataModelException {
            return this.getDom().getNodeSpan(this.id);
        }

        public int getNodeDepth() throws DataModelException {
            int n = -1;
            int n2 = this.getDom().getParent(this.id);
            while (n2 != 0) {
                ++n;
                n2 = this.getDom().getParent(n2);
            }
            return n;
        }

        public Node[] getAttributes() throws DataModelException {
            int n = this.getAttributeCount();
            if (n == 0) {
                return null;
            }
            Node[] nodeArray = new Node[n];
            int n2 = this.getDom().getAttribute(this.id, -1);
            int n3 = 0;
            while (n2 != 0) {
                nodeArray[n3++] = new ANode(this.id, n2, this.dm);
                n2 = this.getDom().pnGetNext(n2);
            }
            return nodeArray;
        }

        public int getAttributeCount() throws DataModelException {
            return this.getDom().getAttrCount(this.id);
        }

        public boolean deepEquals(XQItem xQItem, ComparisonContext comparisonContext) throws EvaluationException {
            if (!(xQItem instanceof BasicNode)) {
                return false;
            }
            try {
                return this.deepEq(this.id, (BasicNode)xQItem, comparisonContext.getCollator());
            }
            catch (DataModelException dataModelException) {
                throw FONINode.wrapDMException(dataModelException);
            }
        }

        public boolean deepEquals(Node node, Collator collator) throws DataModelException {
            return this.deepEq(this.id, (BasicNode)node, collator);
        }

        protected boolean deepEq(int n, BasicNode basicNode, Collator collator) throws DataModelException {
            int n2 = this.getDom().getKind(n);
            if (n2 != basicNode.getNodeNature() || this.getDom().getName(n) != basicNode.getNodeName()) {
                return false;
            }
            if (n2 == 1) {
                return this.contentEq(n, basicNode, collator);
            }
            if (n2 == 2) {
                return this.attributesEq(n, basicNode, collator) && this.contentEq(n, basicNode, collator);
            }
            return Collations.compare(this.getDom().getStringValue(n), basicNode.getStringValue(), collator) == 0;
        }

        boolean attributesEq(int n, Node node, Collator collator) throws DataModelException {
            FONIDocument fONIDocument = this.getDom();
            int n2 = fONIDocument.getAttribute(n, -1);
            Node[] nodeArray = node.getAttributes();
            if (n2 == 0) {
                return nodeArray == null;
            }
            if (nodeArray == null) {
                return false;
            }
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node2 = nodeArray[i];
                int n3 = fONIDocument.internOtherName(node2.getNodeName());
                int n4 = fONIDocument.getAttribute(n, n3);
                if (n4 != 0 && Collations.compare(fONIDocument.pnGetStringValue(n4), node2.getStringValue(), collator) == 0) continue;
                return false;
            }
            return fONIDocument.getAttrCount(n) == nodeArray.length;
        }

        boolean contentEq(int n, BasicNode basicNode, Collator collator) throws DataModelException {
            FONIDocument fONIDocument = this.getDom();
            int n2 = fONIDocument.getFirstChild(n);
            BasicNode basicNode2 = basicNode.firstChild();
            while (n2 != 0) {
                int n3 = fONIDocument.getKind(n2);
                if (n3 != 6 && n3 != 5) {
                    int n4;
                    do {
                        if (basicNode2 != null) continue;
                        return false;
                    } while ((n4 = basicNode2.getNodeNature()) == 6 || n4 == 5);
                    if (!this.deepEq(n2, basicNode2, collator)) {
                        return false;
                    }
                }
                n2 = fONIDocument.getNextSibling(n2);
                basicNode2 = (BasicNode)basicNode2.getNextSibling();
            }
            return basicNode2 == null;
        }

        public int compareStringValues(Node node, Collator collator) throws DataModelException {
            String string = this.getStringValue();
            String string2 = node.getStringValue();
            return collator != null ? collator.compare(string, string2) : string.compareTo(string2);
        }

        public int compareTo(XQItem xQItem, ComparisonContext comparisonContext, int n) throws EvaluationException {
            return UntypedAtomicType.comparison(this, xQItem, comparisonContext, n);
        }

        public int documentOrderCompareTo(Node node) {
            FONINode fONINode;
            if (node instanceof FONINode && (fONINode = (FONINode)node).getDom().equals(this.getDom())) {
                return this.id < fONINode.id ? -1 : (this.id > fONINode.id ? 1 : 0);
            }
            return Comparison.of(this.docPosition(), ((BasicNode)node).docPosition());
        }

        public Node getDocumentNode() throws DataModelException {
            return this.getDM().newNode(this.getDom().getRootNode());
        }

        public Node getAttribute(QName qName) throws DataModelException {
            int n = this.getDom().internOtherName(qName);
            if (n < 0) {
                return null;
            }
            int n2 = this.getDom().getAttribute(this.id, n);
            return n2 == 0 ? null : new ANode(this.id, n2, this.dm);
        }

        public String getNamespacePrefix(String string) throws DataModelException {
            return FONIDataModel.getNsPrefix(this.getDom(), this.id, string);
        }

        public String getNamespaceUri(String string) throws DataModelException {
            return FONIDataModel.getNsUri(this.getDom(), this.id, string);
        }

        public boolean hasLocalNamespaces() throws DataModelException {
            return this.getDom().getFirstNSNode(this.id) != 0;
        }

        public int addNamespacesTo(NamespaceContext namespaceContext) throws DataModelException {
            return FONIDataModel.addNsTo(this.getDom(), this.id, namespaceContext);
        }

        public int addUsedNamespacesTo(NamespaceContext namespaceContext) throws DataModelException {
            return FONIDataModel.addUsedNsTo(this.getDom(), this.id, namespaceContext);
        }

        public void addInScopeNamespacesTo(NamespaceContext namespaceContext) throws DataModelException {
            FONIDataModel.addInscopeNsTo(this.getDom(), this.id, namespaceContext);
        }

        public void hideContextNamespacesIn(NamespaceContext namespaceContext) throws DataModelException {
        }

        public NodeSequenceBase getAncestors(NodeFilter nodeFilter) {
            return new Ancestors(this.id, nodeFilter, this.dm);
        }

        public NodeSequenceBase getAncestorsOrSelf(NodeFilter nodeFilter) {
            return new AncestorsOrSelf(this.id, nodeFilter, this.dm);
        }

        public NodeSequenceBase getParent(NodeFilter nodeFilter) {
            return new Parent(this.id, nodeFilter, this.dm);
        }

        public NodeSequenceBase getChildren(NodeFilter nodeFilter) throws DataModelException {
            return new Children(this.id, nodeFilter, this.dm);
        }

        public NodeSequenceBase getDescendants(NodeFilter nodeFilter) throws DataModelException {
            return new Descendants(this.id, nodeFilter, this.dm);
        }

        public NodeSequenceBase getDescendantsOrSelf(NodeFilter nodeFilter) throws DataModelException {
            return new DescendantsOrSelf(this.id, nodeFilter, this.dm);
        }

        public NodeSequenceBase getAttributes(NodeFilter nodeFilter) throws DataModelException {
            return new Attributes(this.id, nodeFilter, this.dm);
        }

        public NodeSequenceBase getFollowingSiblings(NodeFilter nodeFilter) {
            return new FollowingSiblings(this.id, nodeFilter, this.dm);
        }

        public NodeSequenceBase getPrecedingSiblings(NodeFilter nodeFilter) throws DataModelException {
            return new PrecedingSiblings(this.id, nodeFilter, this.dm);
        }

        public NodeSequenceBase getFollowing(NodeFilter nodeFilter) {
            return new Following(this.id, nodeFilter, this.dm);
        }

        public NodeSequenceBase getPreceding(NodeFilter nodeFilter) throws DataModelException {
            return new Preceding(this.id, nodeFilter, this.dm);
        }

        public boolean isNode() {
            return true;
        }

        public Node getNode() {
            return this;
        }

        public XQItem getItem() {
            return this;
        }

        public String getString() throws EvaluationException {
            try {
                return this.getStringValue();
            }
            catch (DataModelException dataModelException) {
                throw FONINode.wrapDMException(dataModelException);
            }
        }

        public boolean getBoolean() throws EvaluationException {
            return this.getString().length() != 0;
        }

        public long getInteger() throws EvaluationException {
            return Conversion.toInteger(this.getString());
        }

        public BigDecimal getDecimal() throws EvaluationException {
            return Conversion.toDecimal(this.getString(), true);
        }

        public float getFloat() throws EvaluationException {
            return Conversion.toFloat(this.getString());
        }

        public double getDouble() throws EvaluationException {
            return Conversion.toDouble(this.getString());
        }

        public Duration getDuration() throws EvaluationException {
            try {
                return Duration.parseDuration(this.getString());
            }
            catch (DateTimeException dateTimeException) {
                throw new EvaluationException(dateTimeException.getMessage());
            }
        }

        public DateTimeBase getMoment() throws EvaluationException {
            throw new EvaluationException("cannot convert node to date or time");
        }

        public BasicNode[] getIdMatchingNodes(String string, boolean bl) throws DataModelException {
            FONIDataModel fONIDataModel = this.getDM();
            int[] nArray = this.getDom().getIdMatchingNodes(string, bl);
            if (nArray == null) {
                return null;
            }
            int n = bl ? nArray.length / 2 : nArray.length;
            BasicNode[] basicNodeArray = new BasicNode[n];
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    int n2 = nArray[2 * i];
                    basicNodeArray[i] = new ANode(n2, this.attrByRank(n2, nArray[2 * i + 1]), fONIDataModel);
                    continue;
                }
                basicNodeArray[i] = fONIDataModel.newNode(nArray[i]);
            }
            return basicNodeArray;
        }

        private int attrByRank(int n, int n2) throws DataModelException {
            int n3 = this.getDom().getAttribute(n, -1);
            while (n3 != 0 && n2 > 0) {
                n3 = this.getDom().pnGetNext(n3);
                --n2;
            }
            return n3;
        }

        public int getNodeId() {
            return this.id;
        }

        public XMLPullStream exportNode() {
            return new NodePullStream(this);
        }

        public Object getObject() throws QizxException {
            return new PushStreamToDOM().exportNode(this);
        }

        public boolean equals(Object object) {
            if (!(object instanceof FONINode)) {
                return false;
            }
            FONINode fONINode = (FONINode)object;
            if (fONINode.id != this.id || fONINode.getClass() != this.getClass()) {
                return false;
            }
            FONIDocument fONIDocument = fONINode.getDom();
            FONIDocument fONIDocument2 = this.getDom();
            if (fONIDocument == null || fONIDocument2 == null) {
                return false;
            }
            return fONIDocument.equals(fONIDocument2);
        }

        public int hashCode() {
            return this.id;
        }
    }
}

