/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.api.XMLPushStream;
import com.qizx.api.util.SAXToPushStream;
import com.qizx.util.basic.FileUtil;
import com.qizx.util.basic.PathUtil;
import com.qizx.xdm.FONIDataModel;
import com.qizx.xdm.FONIDocument;
import com.qizx.xdm.IDocument;
import com.qizx.xdm.XDefaultHandler;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class DocumentParser {
    static final String SAXLEX = "http://xml.org/sax/properties/lexical-handler";
    static final String XINCLUDE = "http://apache.org/xml/features/xinclude";
    private static final String CHAR_ENTITIES_TXT = "commonCharEntities.txt";
    private static boolean WHITESPACE_STRIPPED = "yes".equalsIgnoreCase(System.getProperty("qizx.stripws"));
    private static CatalogManager catalogManager;
    protected SAXParserFactory factory;
    protected boolean stripWhiteSpace = WHITESPACE_STRIPPED;
    protected CatalogManager localCatalogManager;

    public static synchronized void resetXMLCatalogs() {
        System.setProperty("entityExpansionLimit", "1000000000");
        catalogManager = new CatalogManager(null);
        catalogManager.setIgnoreMissingProperties(true);
        catalogManager.setPreferPublic(true);
        catalogManager.setUseStaticCatalog(false);
        catalogManager.setVerbosity(0);
    }

    private synchronized EntityResolver newCatalogResolver() {
        CatalogManager catalogManager = this.localCatalogManager != null ? this.localCatalogManager : DocumentParser.catalogManager;
        final CatalogResolver catalogResolver = new CatalogResolver(catalogManager);
        return new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                String string3;
                InputSource inputSource = catalogResolver.resolveEntity(string, string2);
                if (inputSource == null && string2 != null && string == null) {
                    string3 = PathUtil.getBaseName(string2);
                    inputSource = catalogResolver.resolveEntity(string, string3);
                }
                if (inputSource == null && string2 != null) {
                    string3 = FileUtil.urlToFileName(string2);
                    if (string3 != null && new File(string3).exists()) {
                        return new InputSource(string2);
                    }
                    if (string2.endsWith(".dtd") || string2.endsWith(".DTD")) {
                        URL uRL = this.getClass().getResource(DocumentParser.CHAR_ENTITIES_TXT);
                        if (uRL != null) {
                            inputSource = new InputSource(uRL.openStream());
                            inputSource.setSystemId("unresolved.dtd");
                        } else {
                            System.err.println("no such resource: commonCharEntities.txt");
                        }
                    }
                }
                return inputSource;
            }
        };
    }

    public DocumentParser() {
        this.init();
    }

    protected void init() {
        this.factory = SAXParserFactory.newInstance();
        this.factory.setNamespaceAware(true);
    }

    public XMLReader newParser(Map map) throws SAXException {
        try {
            Object object2;
            if (map != null) {
                for (Object object2 : map.keySet()) {
                    Object v = map.get(object2);
                    try {
                        this.factory.setFeature((String)object2, v == Boolean.TRUE || v instanceof String && "true".equalsIgnoreCase((String)v));
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        throw new SAXException("unrecognized feature " + (String)object2, sAXNotRecognizedException);
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                        throw new SAXException("non-supported feature " + (String)object2, sAXNotSupportedException);
                    }
                }
            }
            SAXParser sAXParser = this.factory.newSAXParser();
            object2 = sAXParser.getXMLReader();
            object2.setEntityResolver(this.newCatalogResolver());
            return object2;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("cannot create parser", parserConfigurationException);
        }
    }

    public XMLReader newParser() throws SAXException {
        return this.newParser(null);
    }

    public CatalogManager getLocalCatalogManager() {
        return this.localCatalogManager;
    }

    public void setLocalCatalogManager(CatalogManager catalogManager) {
        this.localCatalogManager = catalogManager;
    }

    public void setStripWhiteSpace(boolean bl) {
        this.stripWhiteSpace = bl;
    }

    public boolean getStripWhiteSpace() {
        return this.stripWhiteSpace;
    }

    public static Node parse(InputSource inputSource) throws SAXException, IOException, DataModelException {
        return DocumentParser.parse(inputSource, (Map)null);
    }

    public static Node parse(InputSource inputSource, Map map) throws SAXException, IOException, DataModelException {
        DocumentParser documentParser = new DocumentParser();
        IDocument iDocument = new IDocument();
        documentParser.parseDocument(inputSource, (XDefaultHandler)iDocument, map);
        FONIDataModel fONIDataModel = new FONIDataModel(iDocument);
        return fONIDataModel.getDocumentNode();
    }

    public static Node parse(InputSource inputSource, XMLReader xMLReader) throws SAXException, IOException, DataModelException {
        DocumentParser documentParser = new DocumentParser();
        IDocument iDocument = new IDocument();
        documentParser.parseDocument(inputSource, (XDefaultHandler)iDocument, xMLReader);
        FONIDataModel fONIDataModel = new FONIDataModel(iDocument);
        return fONIDataModel.getDocumentNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FONIDocument parseDocument(URL uRL) throws SAXException, IOException {
        InputSource inputSource = new InputSource(uRL.toString());
        FONIDocument fONIDocument = null;
        fONIDocument = this.parseDocument(inputSource);
        return fONIDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FONIDocument parseDocument(File file) throws SAXException, IOException {
        String string = FileUtil.fileToSystemId(file);
        InputSource inputSource = new InputSource(string);
        FONIDocument fONIDocument = null;
        fONIDocument = this.parseDocument(inputSource);
        return fONIDocument;
    }

    public FONIDocument parseDocument(InputSource inputSource) throws SAXException, IOException {
        return this.parseDocument(inputSource, (Map)null);
    }

    public FONIDocument parseDocument(InputSource inputSource, Map map) throws SAXException, IOException {
        IDocument iDocument = new IDocument();
        iDocument.setWhitespaceStripped(this.stripWhiteSpace);
        this.parseDocument(inputSource, (XDefaultHandler)iDocument, map);
        return iDocument;
    }

    public void parseDocument(InputSource inputSource, XDefaultHandler xDefaultHandler, XMLReader xMLReader) throws SAXException, IOException {
        try {
            xMLReader.setProperty(SAXLEX, xDefaultHandler);
        }
        catch (Exception exception) {
            System.err.println("*** lexical-handler: " + exception);
        }
        xMLReader.setDTDHandler(xDefaultHandler);
        xMLReader.setContentHandler(xDefaultHandler);
        xMLReader.setErrorHandler(xDefaultHandler);
        xMLReader.parse(inputSource);
    }

    public void parseDocument(InputSource inputSource, XDefaultHandler xDefaultHandler, Map map) throws SAXException, IOException {
        this.parseDocument(inputSource, xDefaultHandler, this.newParser(map));
    }

    public void parseDocument(InputSource inputSource, XMLPushStream xMLPushStream, XMLReader xMLReader) throws SAXException, IOException {
        SAXToPushStream sAXToPushStream = new SAXToPushStream(xMLPushStream);
        sAXToPushStream.setWhitespaceStripped(this.stripWhiteSpace);
        this.parseDocument(inputSource, (XDefaultHandler)sAXToPushStream, xMLReader);
    }

    public void parseDocument(InputSource inputSource, XMLPushStream xMLPushStream) throws SAXException, IOException {
        this.parseDocument(inputSource, xMLPushStream, this.newParser());
    }

    static {
        DocumentParser.resetXMLCatalogs();
    }
}

