/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQTypeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class Conversion {
    public static final QName ERR_CAST = ModuleContext.xqueryErrorCode("FORG0001");
    private static final int DECIMAL_PRECISION = 18;
    private static Method toPlainString;
    static double MAX_INTVALUE;
    static double MIN_INTVALUE;
    static DecimalFormatSymbols syms;
    static DecimalFormat fmtSciD;
    static DecimalFormat fmtDecD;
    static DecimalFormat fmtSciF;
    static DecimalFormat fmtDecF;

    public static boolean toBoolean(double d) {
        return d != 0.0 && d == d;
    }

    public static boolean toBoolean(String string) throws XQTypeException {
        if ("true".equalsIgnoreCase(string) || "1".equals(string)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string) || "0".equals(string)) {
            return false;
        }
        throw new XQTypeException(ERR_CAST, "invalid value '" + string + "' for boolean type");
    }

    public static long toInteger(boolean bl) {
        return bl ? 1L : 0L;
    }

    public static long toInteger(String string) throws XQTypeException {
        try {
            return Long.parseLong(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new XQTypeException(ERR_CAST, "invalid value '" + string + "' for integer type");
        }
    }

    public static boolean isIntegerRange(double d) {
        return d >= MIN_INTVALUE && d < MAX_INTVALUE;
    }

    public static float toFloat(boolean bl) {
        return bl ? 1.0f : 0.0f;
    }

    public static float toFloat(String string) throws XQTypeException {
        try {
            return Float.parseFloat(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF")) {
                return Float.POSITIVE_INFINITY;
            }
            if (string.equals("-INF")) {
                return Float.NEGATIVE_INFINITY;
            }
            throw new XQTypeException(ERR_CAST, "invalid value '" + string + "' for type float");
        }
    }

    public static double toDouble(boolean bl) {
        return bl ? 1.0 : 0.0;
    }

    public static double toDouble(String string) throws XQTypeException {
        try {
            return Double.parseDouble(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF")) {
                return Double.POSITIVE_INFINITY;
            }
            if (string.equals("-INF")) {
                return Double.NEGATIVE_INFINITY;
            }
            throw new XQTypeException(ERR_CAST, "invalid value '" + string + "' for type double");
        }
    }

    public static double roundHalfToEven(double d, int n) {
        double d2 = Math.pow(10.0, n);
        double d3 = Math.rint(d * d2) / d2;
        return d3;
    }

    public static BigDecimal toDecimal(boolean bl) {
        return new BigDecimal(bl ? 1.0 : 0.0);
    }

    public static BigDecimal toDecimal(long l) {
        return new BigDecimal(Long.toString(l));
    }

    public static BigDecimal toDecimal(String string, boolean bl) throws XQTypeException {
        try {
            if (bl || string.lastIndexOf(101) < 0 && string.lastIndexOf(69) < 0) {
                return new BigDecimal(string.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new XQTypeException(ERR_CAST, "invalid value '" + string + "' for type decimal");
    }

    public static BigDecimal toDecimal(double d) throws EvaluationException {
        BigDecimal bigDecimal = new BigDecimal(d);
        return bigDecimal.setScale(16, 6);
    }

    public static String toString(boolean bl) {
        return bl ? "true" : "false";
    }

    public static String toString(long l) throws EvaluationException {
        return Long.toString(l);
    }

    public static String toString(float f) throws EvaluationException {
        String string;
        if (f == 0.0f) {
            return 1.0f / f == Float.POSITIVE_INFINITY ? "0" : "-0";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        if (f != f) {
            return "NaN";
        }
        float f2 = Math.abs(f);
        String string2 = null;
        if (f2 >= 1.0E-6f && f2 < 1000000.0f) {
            string = fmtDecF.format(f);
            if (string.indexOf(46) >= 0) {
                int n;
                for (n = string.length(); n > 0 && string.charAt(n - 1) == '0'; --n) {
                }
                if (n > 0 && string.charAt(n - 1) == '.') {
                    --n;
                }
                string = string.substring(0, n);
            }
        } else {
            string = fmtSciF.format(f);
            int n = string.indexOf(69);
            if (n > 0) {
                string2 = string.substring(n + 1, string.length());
                string = string.substring(0, n);
            }
        }
        return string2 == null ? string : string.concat("E").concat(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(double d) throws EvaluationException {
        String string;
        if (d == 0.0) {
            return 1.0 / d == Double.POSITIVE_INFINITY ? "0" : "-0";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "INF";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        if (d != d) {
            return "NaN";
        }
        double d2 = Math.abs(d);
        String string2 = null;
        if (d2 >= 1.0E-6 && d2 < 1000000.0) {
            DecimalFormat decimalFormat = fmtDecD;
            synchronized (decimalFormat) {
                string = fmtDecD.format(d);
            }
            int n = string.length();
            if (n > 2 && string.charAt(n - 1) == '0' && string.charAt(n - 2) == '.') {
                string = string.substring(0, n - 2);
            }
        } else {
            DecimalFormat decimalFormat = fmtSciD;
            synchronized (decimalFormat) {
                string = fmtSciD.format(d);
            }
            int n = string.indexOf(69);
            if (n > 0) {
                string2 = string.substring(n + 1, string.length());
                string = string.substring(0, n);
            }
        }
        return string2 == null ? string : string.concat("E").concat(string2);
    }

    public static BigDecimal round(BigDecimal bigDecimal) {
        switch (bigDecimal.signum()) {
            case -1: {
                return bigDecimal.setScale(0, 5);
            }
            default: {
                return bigDecimal;
            }
            case 1: 
        }
        return bigDecimal.setScale(0, 4);
    }

    public static BigDecimal roundHalfToEven(BigDecimal bigDecimal, int n) {
        if (n < 0) {
            long l = bigDecimal.longValue();
            long l2 = 1L;
            for (int i = n; i < 0; ++i) {
                l2 *= 10L;
            }
            long l3 = l % l2;
            l -= l3;
            if (l3 * 2L >= l2) {
                l += l2;
            }
            return BigDecimal.valueOf(l);
        }
        return bigDecimal.setScale(n, 6);
    }

    public static BigDecimal divide(BigDecimal bigDecimal, int n) throws ArithmeticException {
        return Conversion.divide(bigDecimal, BigDecimal.valueOf(n));
    }

    public static BigDecimal divide(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws ArithmeticException {
        return bigDecimal.divide(bigDecimal2, Math.max(18, bigDecimal.scale()), 6);
    }

    public static String toString(BigDecimal bigDecimal) {
        String string = null;
        if (toPlainString != null) {
            try {
                string = (String)toPlainString.invoke((Object)bigDecimal, (Object[])null);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                return null;
            }
        } else {
            string = bigDecimal.toString();
        }
        if (string.lastIndexOf(46) < 0) {
            return string;
        }
        int n = string.length();
        while (--n > 0 && string.charAt(n) == '0') {
        }
        if (n > 0 && string.charAt(n) == '.') {
            --n;
        }
        return string.substring(0, n + 1);
    }

    static {
        try {
            toPlainString = BigDecimal.class.getMethod("toPlainString", null);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        MAX_INTVALUE = 4.611686018427388E18;
        MIN_INTVALUE = -MAX_INTVALUE;
        syms = new DecimalFormatSymbols(Locale.US);
        fmtSciD = new DecimalFormat("0.0################E0##", syms);
        fmtDecD = new DecimalFormat("#####0.0################", syms);
        fmtSciF = new DecimalFormat("0.0####E0##", syms);
        fmtDecF = new DecimalFormat("#####0.0######", syms);
    }
}

