/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.ItemType;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.XMLPushStream;
import com.qizx.api.util.time.Date;
import com.qizx.api.util.time.DateTime;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.util.NamespaceContext;
import com.qizx.xdm.Conversion;
import com.qizx.xdm.NodeFilter;
import com.qizx.xdm.NodeSequenceBase;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.dt.NodeType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.Collator;

public abstract class BasicNode
implements Node,
XQItem,
Serializable {
    public static final int ATOM_BITSET = 13;

    public String toString() {
        try {
            String string = this.getNodeKind() + "(";
            switch (this.getNodeNature()) {
                case 2: {
                    return "Element(" + this.getNodeName() + ")";
                }
                case 3: {
                    return "Attr(" + this.getNodeName() + ")= " + this.getStringValue();
                }
                case 5: {
                    return "PI(" + this.getNodeName() + ")= " + this.getStringValue() + ")";
                }
            }
            return this.getNodeKind() + "(" + this.getStringValue() + ")";
        }
        catch (DataModelException dataModelException) {
            return "Node(?)";
        }
    }

    public ItemType getType() throws EvaluationException {
        return this.getItemType();
    }

    public XQItemType getItemType() throws EvaluationException {
        try {
            return NodeType.getTypeByKind(this.getNodeNature());
        }
        catch (DataModelException dataModelException) {
            throw BasicNode.wrapDMException(dataModelException);
        }
    }

    public boolean getBoolean() throws EvaluationException {
        return this.getString().length() != 0;
    }

    public float getFloat() throws EvaluationException {
        return Conversion.toFloat(this.getString());
    }

    public double getDouble() throws EvaluationException {
        return Conversion.toDouble(this.getString());
    }

    public double getDoubleByRules() {
        return Double.NaN;
    }

    public long getInteger() throws EvaluationException {
        return Conversion.toInteger(this.getString());
    }

    public BigDecimal getDecimal() throws EvaluationException {
        return Conversion.toDecimal(this.getString(), true);
    }

    public QName getQName() throws EvaluationException {
        throw new EvaluationException("Node not convertible to QName");
    }

    public long getLongAtomValue() {
        return -1L;
    }

    public Object getAtomValue() {
        return null;
    }

    public Date getDate() throws EvaluationException, DateTimeException {
        return Date.parseDate(this.getString().trim());
    }

    public DateTime getDateTime() throws EvaluationException, DateTimeException {
        return DateTime.parseDateTime(this.getString().trim());
    }

    public abstract String[] getDTDInfo() throws DataModelException;

    public boolean isNode() {
        return true;
    }

    public boolean isElement() throws DataModelException {
        return this.getNodeNature() == 2;
    }

    public Node getNode() {
        return this;
    }

    public void export(XMLPushStream xMLPushStream) throws DataModelException {
        xMLPushStream.putNodeCopy(this, 0);
    }

    public Node getFirstChild() throws DataModelException {
        return this.firstChild();
    }

    public Node getNextSibling() throws DataModelException {
        return this.nextSibling();
    }

    public abstract BasicNode firstChild() throws DataModelException;

    public abstract BasicNode nextSibling() throws DataModelException;

    public Node getNextNode() throws DataModelException {
        return this.nodeNext();
    }

    public Node getFollowingNode() throws DataModelException {
        return this.nodeAfter();
    }

    public BasicNode nodeNext() throws DataModelException {
        BasicNode basicNode = this.firstChild();
        return basicNode != null ? basicNode : this.nodeAfter();
    }

    public BasicNode nodeAfter() throws DataModelException {
        BasicNode basicNode;
        BasicNode basicNode2 = this;
        while ((basicNode = basicNode2.nextSibling()) == null) {
            Node node = basicNode2.getParent();
            if (node == null) {
                return null;
            }
            basicNode2 = (BasicNode)node;
        }
        return basicNode;
    }

    public int stringValueCompareTo(Node node, Collator collator) throws DataModelException {
        String string = this.getStringValue();
        String string2 = node.getStringValue();
        return collator != null ? collator.compare(string, string2) : string.compareTo(string2);
    }

    public abstract NodeSequenceBase getParent(NodeFilter var1) throws DataModelException;

    public abstract NodeSequenceBase getAncestors(NodeFilter var1) throws DataModelException;

    public abstract NodeSequenceBase getAncestorsOrSelf(NodeFilter var1) throws DataModelException;

    public abstract NodeSequenceBase getAttributes(NodeFilter var1) throws DataModelException;

    public abstract NodeSequenceBase getChildren(NodeFilter var1) throws DataModelException;

    public abstract NodeSequenceBase getDescendants(NodeFilter var1) throws DataModelException;

    public abstract NodeSequenceBase getDescendantsOrSelf(NodeFilter var1) throws DataModelException;

    public abstract NodeSequenceBase getFollowing(NodeFilter var1) throws DataModelException;

    public abstract NodeSequenceBase getFollowingSiblings(NodeFilter var1) throws DataModelException;

    public abstract NodeSequenceBase getPreceding(NodeFilter var1) throws DataModelException;

    public abstract NodeSequenceBase getPrecedingSiblings(NodeFilter var1) throws DataModelException;

    public abstract int docPosition();

    public abstract BasicNode[] getIdMatchingNodes(String var1, boolean var2) throws DataModelException;

    public abstract void addInScopeNamespacesTo(NamespaceContext var1) throws DataModelException;

    public abstract boolean hasLocalNamespaces() throws DataModelException;

    public abstract int addNamespacesTo(NamespaceContext var1) throws DataModelException;

    public abstract int addUsedNamespacesTo(NamespaceContext var1) throws DataModelException;

    public static EvaluationException wrapDMException(DataModelException dataModelException) {
        return new EvaluationException(dataModelException.getErrorCode(), "data model error: " + dataModelException.getMessage(), dataModelException);
    }
}

