/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.logging;

import com.qizx.api.util.logging.Log;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerLog
implements Log {
    private Logger logger;
    private String prefix = "";
    private int errorCount;
    private boolean allowDebug;
    private boolean allowInfo;

    public LoggerLog(Logger logger, String string) {
        this.logger = logger;
        if (string != null) {
            this.prefix = "[" + string + "] ";
        }
    }

    public String getName() {
        return this.logger.getName();
    }

    public Log.Level getLevel() {
        this.allowInfo = false;
        this.allowDebug = false;
        Level level = this.logger.getLevel();
        if (level == Level.SEVERE) {
            return Log.ERROR;
        }
        if (level == Level.WARNING) {
            return Log.WARNING;
        }
        if (level == Level.INFO) {
            this.allowInfo = true;
            return Log.INFO;
        }
        this.allowDebug = true;
        return Log.DEBUG;
    }

    public void setLevel(Log.Level level) {
    }

    public int getWarningCount() {
        return 0;
    }

    public void setWarningCount(int n) {
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int n) {
        this.errorCount = n;
    }

    public int getWorkLevel() {
        this.getLevel();
        return this.logger.getLevel().intValue();
    }

    public boolean allowsError() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean allowsWarning() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public boolean allowsInfo() {
        return this.allowInfo;
    }

    public boolean allowsDebug() {
        return this.allowDebug;
    }

    public void error(String string) {
        this.logger.severe(this.prefix + string);
    }

    public void error(String string, Throwable throwable) {
        this.logger.log(Level.SEVERE, this.prefix + string, throwable);
    }

    public void warning(String string) {
        this.logger.warning(this.prefix + string);
    }

    public void warning(String string, Throwable throwable) {
        this.logger.log(Level.WARNING, this.prefix + string, throwable);
    }

    public void info(String string) {
        if (this.allowInfo) {
            this.logger.info(this.prefix + string);
        }
    }

    public void info(String string, Throwable throwable) {
        if (this.allowInfo) {
            this.logger.log(Level.INFO, this.prefix + string, throwable);
        }
    }

    public void debug(String string) {
        if (this.allowDebug) {
            this.logger.fine(this.prefix + string);
        }
    }

    public void debug(String string, Throwable throwable) {
        if (this.allowDebug) {
            this.logger.log(Level.FINE, this.prefix + string, throwable);
        }
    }
}

