/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.io;

import com.qizx.util.io.ByteInputBase;
import com.qizx.util.io.TempByteOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;

public class TempByteInput
extends ByteInputBase
implements Serializable {
    private File tempFile;
    private FileInputStream input;

    public TempByteInput(TempByteOutput tempByteOutput) throws IOException {
        super(tempByteOutput.bufferSize);
        this.tempFile = tempByteOutput.tempFile;
        if (this.tempFile == null) {
            this.bufSize = tempByteOutput.bufPtr;
            System.arraycopy(tempByteOutput.data, 0, this.data, 0, this.bufSize);
        } else {
            this.input = new FileInputStream(this.tempFile);
        }
    }

    public void close() throws IOException {
        if (this.tempFile != null) {
            this.tempFile.delete();
            this.tempFile = null;
        }
    }

    protected int readBuffer() throws IOException {
        return this.input == null ? -1 : this.input.read(this.data, 0, this.data.length);
    }
}

