/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.io;

import com.qizx.util.io.ByteOutputBase;
import java.io.IOException;

public class CoreByteOutput
extends ByteOutputBase {
    byte[][] blocks;
    int[] blockSizes;
    int blockCount;

    public CoreByteOutput() {
        super(8192);
        this.blocks = new byte[8][];
        this.blockSizes = new int[this.blocks.length];
    }

    public CoreByteOutput(byte[] byArray) {
        super(byArray);
        this.blocks = null;
    }

    public long getLength() {
        long l = 0L;
        for (int i = 0; i < this.blockCount; ++i) {
            l += (long)this.blockSizes[i];
        }
        return l;
    }

    protected void writeBuffer(byte[] byArray, int n) {
        Object object;
        if (this.blocks == null) {
            return;
        }
        if (this.blockCount >= this.blocks.length) {
            object = this.blocks;
            this.blocks = new byte[((byte[][])object).length * 2][];
            System.arraycopy(object, 0, this.blocks, 0, ((byte[][])object).length);
            int[] nArray = this.blockSizes;
            this.blockSizes = new int[this.blocks.length];
            System.arraycopy(nArray, 0, this.blockSizes, 0, nArray.length);
        }
        this.blockSizes[this.blockCount] = n;
        object = new byte[n];
        System.arraycopy(this.data, 0, object, 0, n);
        this.blocks[this.blockCount++] = (byte[])object;
    }

    public void close() throws IOException {
        if (this.bufPtr > 0) {
            this.flushBuffer();
        }
        this.bufPtr = 0;
    }
}

