/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.io;

import com.qizx.util.io.ByteInputBase;
import com.qizx.util.io.CoreByteOutput;
import java.io.IOException;
import java.io.Serializable;

public class CoreByteInput
extends ByteInputBase
implements Serializable {
    byte[][] blocks;
    int[] blockSizes;
    int blockCount;
    int blockPtr;

    public CoreByteInput() {
        super(8192);
        this.blocks = new byte[4][];
        this.blockSizes = new int[this.blocks.length];
    }

    public CoreByteInput(CoreByteOutput coreByteOutput) {
        super(coreByteOutput.bufferSize);
        this.blocks = coreByteOutput.blocks;
        this.blockSizes = coreByteOutput.blockSizes;
        this.blockCount = coreByteOutput.blockCount;
    }

    public CoreByteInput(byte[] byArray, int n) {
        super(byArray, n);
    }

    public void restartOn(byte[] byArray, int n) throws IOException {
        this.data = byArray;
        this.bufSize = n;
        this.ptr = 0;
    }

    protected int readBuffer() {
        if (this.blockPtr >= this.blockCount) {
            return -1;
        }
        int n = this.blockSizes == null ? this.blocks[this.blockPtr].length : this.blockSizes[this.blockPtr];
        System.arraycopy(this.blocks[this.blockPtr], 0, this.data, 0, n);
        ++this.blockPtr;
        return n;
    }

    public void store(byte[] byArray, int n) {
        if (this.blockCount >= this.blocks.length) {
            byte[][] byArray2 = this.blocks;
            this.blocks = new byte[byArray2.length * 2][];
            System.arraycopy(byArray2, 0, this.blocks, 0, byArray2.length);
            int[] nArray = this.blockSizes;
            this.blockSizes = new int[byArray2.length * 2];
            System.arraycopy(nArray, 0, this.blockSizes, 0, byArray2.length);
        }
        this.blocks[this.blockCount] = byArray;
        this.blockSizes[this.blockCount++] = n;
    }
}

