/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.basic;

import java.util.StringTokenizer;

public class XMLUtil {
    private static final int SUPPLEM_LB = 65536;
    private static final int SUPPLEM_UB = 0x10FFFF;
    private static final char HI_SURROG_LB = '\ud800';
    private static final char HI_SURROG_UB = '\udbff';
    private static final char LO_SURROG_LB = '\udc00';
    private static final char LO_SURROG_UB = '\udf00';
    private static final char SURROG_LB = '\ud800';
    private static final char SURROG_UB = '\udf00';
    private static int uniqueId = 0;

    public static final boolean isPITarget(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return XMLUtil.isName(string) && !string.regionMatches(true, 0, "xml", 0, 3);
    }

    public static final boolean isNmtoken(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (XMLUtil.isNameChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isNCName(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return false;
        }
        char c = string.charAt(0);
        switch (c) {
            case '_': {
                break;
            }
            default: {
                if (Character.isLetter(c)) break;
                return false;
            }
        }
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if (c != ':' && XMLUtil.isNameChar(c)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isName(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return false;
        }
        char c = string.charAt(0);
        switch (c) {
            case ':': 
            case '_': {
                break;
            }
            default: {
                if (Character.isLetter(c)) break;
                return false;
            }
        }
        for (int i = 1; i < n; ++i) {
            if (XMLUtil.isNameChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isNameChar(char c) {
        switch (c) {
            case '-': 
            case '.': 
            case ':': 
            case '_': {
                break;
            }
            case '\u05bf': 
            case '\u05c4': 
            case '\u0670': 
            case '\u093c': 
            case '\u094d': 
            case '\u09bc': 
            case '\u09be': 
            case '\u09bf': 
            case '\u09d7': 
            case '\u0a02': 
            case '\u0a3c': 
            case '\u0a3e': 
            case '\u0a3f': 
            case '\u0abc': 
            case '\u0b3c': 
            case '\u0bd7': 
            case '\u0d57': 
            case '\u0e31': 
            case '\u0eb1': 
            case '\u0f35': 
            case '\u0f37': 
            case '\u0f39': 
            case '\u0f3e': 
            case '\u0f3f': 
            case '\u0f97': 
            case '\u0fb9': 
            case '\u20e1': 
            case '\u3099': 
            case '\u309a': {
                break;
            }
            case '\u00b7': 
            case '\u02d0': 
            case '\u02d1': 
            case '\u0387': 
            case '\u0640': 
            case '\u0e46': 
            case '\u0ec6': 
            case '\u3005': {
                break;
            }
            default: {
                if (Character.isLetterOrDigit(c) || c >= '\u0300' && c <= '\u0345' || c >= '\u0360' && c <= '\u0361' || c >= '\u0483' && c <= '\u0486' || c >= '\u0591' && c <= '\u05a1' || c >= '\u05a3' && c <= '\u05b9' || c >= '\u05bb' && c <= '\u05bd' || c >= '\u05c1' && c <= '\u05c2' || c >= '\u064b' && c <= '\u0652' || c >= '\u06d6' && c <= '\u06dc' || c >= '\u06dd' && c <= '\u06df' || c >= '\u06e0' && c <= '\u06e4' || c >= '\u06e7' && c <= '\u06e8' || c >= '\u06ea' && c <= '\u06ed' || c >= '\u0901' && c <= '\u0903' || c >= '\u093e' && c <= '\u094c' || c >= '\u0951' && c <= '\u0954' || c >= '\u0962' && c <= '\u0963' || c >= '\u0981' && c <= '\u0983' || c >= '\u09c0' && c <= '\u09c4' || c >= '\u09c7' && c <= '\u09c8' || c >= '\u09cb' && c <= '\u09cd' || c >= '\u09e2' && c <= '\u09e3' || c >= '\u0a40' && c <= '\u0a42' || c >= '\u0a47' && c <= '\u0a48' || c >= '\u0a4b' && c <= '\u0a4d' || c >= '\u0a70' && c <= '\u0a71' || c >= '\u0a81' && c <= '\u0a83' || c >= '\u0abe' && c <= '\u0ac5' || c >= '\u0ac7' && c <= '\u0ac9' || c >= '\u0acb' && c <= '\u0acd' || c >= '\u0b01' && c <= '\u0b03' || c >= '\u0b3e' && c <= '\u0b43' || c >= '\u0b47' && c <= '\u0b48' || c >= '\u0b4b' && c <= '\u0b4d' || c >= '\u0b56' && c <= '\u0b57' || c >= '\u0b82' && c <= '\u0b83' || c >= '\u0bbe' && c <= '\u0bc2' || c >= '\u0bc6' && c <= '\u0bc8' || c >= '\u0bca' && c <= '\u0bcd' || c >= '\u0c01' && c <= '\u0c03' || c >= '\u0c3e' && c <= '\u0c44' || c >= '\u0c46' && c <= '\u0c48' || c >= '\u0c4a' && c <= '\u0c4d' || c >= '\u0c55' && c <= '\u0c56' || c >= '\u0c82' && c <= '\u0c83' || c >= '\u0cbe' && c <= '\u0cc4' || c >= '\u0cc6' && c <= '\u0cc8' || c >= '\u0cca' && c <= '\u0ccd' || c >= '\u0cd5' && c <= '\u0cd6' || c >= '\u0d02' && c <= '\u0d03' || c >= '\u0d3e' && c <= '\u0d43' || c >= '\u0d46' && c <= '\u0d48' || c >= '\u0d4a' && c <= '\u0d4d' || c >= '\u0e34' && c <= '\u0e3a' || c >= '\u0e47' && c <= '\u0e4e' || c >= '\u0eb4' && c <= '\u0eb9' || c >= '\u0ebb' && c <= '\u0ebc' || c >= '\u0ec8' && c <= '\u0ecd' || c >= '\u0f18' && c <= '\u0f19' || c >= '\u0f71' && c <= '\u0f84' || c >= '\u0f86' && c <= '\u0f8b' || c >= '\u0f90' && c <= '\u0f95' || c >= '\u0f99' && c <= '\u0fad' || c >= '\u0fb1' && c <= '\u0fb7' || c >= '\u20d0' && c <= '\u20dc' || c >= '\u302a' && c <= '\u302f' || c >= '\u3031' && c <= '\u3035' || c >= '\u309d' && c <= '\u309e' || c >= '\u30fc' && c <= '\u30fe') break;
                return false;
            }
        }
        return true;
    }

    public static final boolean isXMLSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static final boolean isXMLSpace(String string) {
        int n = string.length();
        while (--n >= 0) {
            if (XMLUtil.isXMLSpace(string.charAt(n))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isXMLSpace(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (XMLUtil.isXMLSpace(cArray[i + n])) continue;
            return false;
        }
        return true;
    }

    public static final boolean isXMLChar(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 13: {
                return true;
            }
        }
        return n >= 32 && n <= 55295 || n >= 57344 && n <= 65533;
    }

    public static boolean isSupplementalChar(int n) {
        return n >= 65536 && n <= 0x10FFFF;
    }

    public static boolean isSurrogateChar(char c) {
        return c >= '\ud800' && c <= '\udf00';
    }

    public static char highSurrogate(int n) {
        return (char)((n - 65536 >> 10) + 55296);
    }

    public static char lowSurrogate(int n) {
        return (char)((n - 65536 & 0x3FF) + 56320);
    }

    public static int supplementalChar(char c, char c2) {
        return (c - 55296 << 10) + (c2 - 56320);
    }

    public static final String collapseWhiteSpace(CharSequence charSequence) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLUtil.compressWhiteSpace(charSequence, stringBuffer);
        int n = stringBuffer.length() - 1;
        if (n >= 0) {
            if (stringBuffer.charAt(n) == ' ') {
                stringBuffer.deleteCharAt(n);
                --n;
            }
            if (n >= 0 && stringBuffer.charAt(0) == ' ') {
                stringBuffer.deleteCharAt(0);
            }
        }
        return stringBuffer.toString();
    }

    public static final String compressWhiteSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLUtil.compressWhiteSpace(string, stringBuffer);
        return stringBuffer.toString();
    }

    private static void compressWhiteSpace(CharSequence charSequence, StringBuffer stringBuffer) {
        int n = charSequence.length();
        int n2 = 63;
        for (int i = 0; i < n; ++i) {
            int n3 = charSequence.charAt(i);
            switch (n3) {
                case 9: 
                case 10: 
                case 13: {
                    n3 = 32;
                }
            }
            if (n3 == 32) {
                if (n2 == 32) continue;
                stringBuffer.append((char)n3);
                n2 = n3;
                continue;
            }
            stringBuffer.append((char)n3);
            n2 = n3;
        }
    }

    public static final String replaceWhiteSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 63;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\r': {
                    stringBuffer.append(' ');
                    break;
                }
                case '\n': {
                    if (n2 == 13) break;
                    stringBuffer.append(' ');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            n2 = c;
        }
        return stringBuffer.toString();
    }

    public static final String[] splitList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static final String escapeXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLUtil.escapeXML(string, stringBuffer);
        return stringBuffer.toString();
    }

    public static final String quoteXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        XMLUtil.escapeXML(string, stringBuffer);
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static final void escapeXML(String string, StringBuffer stringBuffer) {
        char[] cArray = string.toCharArray();
        XMLUtil.escapeXML(cArray, 0, cArray.length, stringBuffer);
    }

    public static final void escapeXML(char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        XMLUtil.escapeXML(cArray, n, n2, stringBuffer, false);
    }

    public static final void escapeXML(char[] cArray, int n, int n2, StringBuffer stringBuffer, boolean bl) {
        int n3 = n + n2;
        block8: for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\'': {
                    stringBuffer.append("&#39;");
                    continue block8;
                }
                case '\"': {
                    stringBuffer.append("&#34;");
                    continue block8;
                }
                case '<': {
                    stringBuffer.append("&#60;");
                    continue block8;
                }
                case '>': {
                    stringBuffer.append("&#62;");
                    continue block8;
                }
                case '&': {
                    stringBuffer.append("&#38;");
                    continue block8;
                }
                case '\u00a0': {
                    stringBuffer.append("&#x00A0;");
                    continue block8;
                }
                default: {
                    if (bl && c > '\u007f') {
                        stringBuffer.append("&#");
                        stringBuffer.append(Integer.toString(c));
                        stringBuffer.append(';');
                        continue block8;
                    }
                    stringBuffer.append(c);
                }
            }
        }
    }

    public static final String unescapeXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLUtil.unescapeXML(string, 0, string.length(), stringBuffer);
        return stringBuffer.toString();
    }

    public static final void unescapeXML(String string, int n, int n2, StringBuffer stringBuffer) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                StringBuffer stringBuffer2 = new StringBuffer();
                ++i;
                while (i < n3 && (c = string.charAt(i)) != ';') {
                    stringBuffer2.append(c);
                    ++i;
                }
                c = XMLUtil.parseCharRef(stringBuffer2.toString());
            }
            stringBuffer.append(c);
        }
    }

    private static char parseCharRef(String string) {
        if (string.length() >= 2 && string.charAt(0) == '#') {
            int n;
            try {
                n = string.charAt(1) == 'x' ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (n < 0 || n > 65535) {
                return '?';
            }
            return (char)n;
        }
        if (string.equals("amp")) {
            return '&';
        }
        if (string.equals("apos")) {
            return '\'';
        }
        if (string.equals("quot")) {
            return '\"';
        }
        if (string.equals("lt")) {
            return '<';
        }
        if (string.equals("gt")) {
            return '>';
        }
        return '?';
    }

    public static final String getUniqueId() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("___");
        stringBuffer.append(Long.toString(System.currentTimeMillis(), 36));
        stringBuffer.append(".");
        stringBuffer.append(Integer.toString(uniqueId++, 36));
        return stringBuffer.toString();
    }

    public static String normalizePI(String string) {
        int n;
        if (string == null || string.indexOf("?>") >= 0) {
            return null;
        }
        int n2 = string.length();
        for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        return n == 0 ? string : string.substring(n);
    }

    public static boolean checkComment(String string) {
        if (string == null) {
            return true;
        }
        return string.indexOf("--") < 0 && !string.startsWith("-") && !string.endsWith("-");
    }
}

