/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.basic;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.StringTokenizer;

public final class PlatformUtil {
    public static final int GENERIC_UNIX = 1;
    public static final int WINDOWS = 2;
    public static final int MAC_OS = 3;
    public static final int PLATFORM = PlatformUtil.platform();
    public static final boolean IS_GENERIC_UNIX = PLATFORM == 1;
    public static final boolean IS_WINDOWS = PLATFORM == 2;
    public static final boolean IS_MAC_OS = PLATFORM == 3;

    private static final int platform() {
        if (File.pathSeparatorChar == ';') {
            return 2;
        }
        String string = System.getProperty("os.name");
        if (string != null && string.toLowerCase().indexOf("mac") >= 0) {
            return 3;
        }
        return 1;
    }

    public static String homeDir() {
        String string = System.getProperty("HOME");
        if (string == null || string.length() == 0) {
            string = System.getProperty("user.home");
        }
        if (!new File(string).isDirectory()) {
            string = null;
        }
        return string;
    }

    public static String rcFileName(String string) {
        String string2 = PlatformUtil.homeDir();
        if (string2 == null) {
            return null;
        }
        String string3 = IS_WINDOWS ? string2 + File.separatorChar + string + ".ini" : string2 + File.separatorChar + "." + string;
        return string3;
    }

    public static String tmpFileName() {
        return PlatformUtil.tmpFileName(".tmp");
    }

    public static String tmpFileName(String string) {
        String string2 = Long.toString(System.currentTimeMillis(), 36) + string;
        String string3 = PlatformUtil.tmpDir();
        String string4 = string3 == null ? string2 : new File(string3, string2).getPath();
        return string4;
    }

    public static String tmpDir() {
        String string;
        if (IS_WINDOWS) {
            string = System.getProperty("TMP");
            if (!(string != null && string.length() != 0 || (string = System.getProperty("TEMP")) != null && string.length() != 0)) {
                string = "C:\\";
            }
        } else {
            string = "/tmp";
        }
        if (!new File(string).isDirectory()) {
            string = null;
        }
        return string;
    }

    public static String commandSeparator() {
        return IS_WINDOWS ? "&&" : ";";
    }

    public static Process shellStart(String string) throws IOException {
        Process process = IS_WINDOWS ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", string}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", string});
        return process;
    }

    public static int shellExec(String string) throws IOException, InterruptedException {
        return PlatformUtil.shellExec(string, false);
    }

    public static int shellExec(String string, boolean bl) throws IOException, InterruptedException {
        InputConsumer inputConsumer;
        InputConsumer inputConsumer2;
        if (bl) {
            System.out.println(string);
        }
        Process process = PlatformUtil.shellStart(string);
        if (bl) {
            inputConsumer2 = new InputConsumer(process.getInputStream(), System.out);
            inputConsumer = new InputConsumer(process.getErrorStream(), System.err);
        } else {
            inputConsumer2 = new InputConsumer(process.getInputStream());
            inputConsumer = new InputConsumer(process.getErrorStream());
        }
        inputConsumer2.start();
        inputConsumer.start();
        int n = process.waitFor();
        inputConsumer2.join();
        inputConsumer.join();
        return n;
    }

    public static int shellExec(String string, String[] stringArray) throws IOException, InterruptedException {
        Process process = PlatformUtil.shellStart(string);
        return PlatformUtil.captureOutput(process, stringArray);
    }

    public static int captureOutput(Process process, String[] stringArray) throws InterruptedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        InputConsumer inputConsumer = new InputConsumer(process.getInputStream(), byteArrayOutputStream);
        InputConsumer inputConsumer2 = new InputConsumer(process.getErrorStream(), byteArrayOutputStream2);
        inputConsumer.start();
        inputConsumer2.start();
        int n = process.waitFor();
        inputConsumer.join();
        inputConsumer2.join();
        stringArray[0] = byteArrayOutputStream.toString();
        stringArray[1] = byteArrayOutputStream2.toString();
        return n;
    }

    public static HashMap getEnvironment() {
        HashMap hashMap = new HashMap();
        PlatformUtil.getEnvironment(hashMap);
        return hashMap;
    }

    public static void getEnvironment(HashMap hashMap) {
        Object object;
        Object object2;
        String string = "";
        try {
            object2 = IS_WINDOWS ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "set"}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "env"});
            object = new ByteArrayOutputStream();
            InputConsumer inputConsumer = new InputConsumer(((Process)object2).getInputStream(), (OutputStream)object);
            InputConsumer inputConsumer2 = new InputConsumer(((Process)object2).getErrorStream());
            inputConsumer.start();
            inputConsumer2.start();
            ((Process)object2).waitFor();
            inputConsumer.join();
            inputConsumer2.join();
            string = ((ByteArrayOutputStream)object).toString();
        }
        catch (Exception exception) {
            return;
        }
        object2 = new StringTokenizer(string, "\r\n");
        while (((StringTokenizer)object2).hasMoreTokens()) {
            int n;
            object = ((StringTokenizer)object2).nextToken();
            int n2 = ((String)object).length();
            if (n2 == 0 || (n = ((String)object).indexOf(61)) <= 0 || n >= n2 - 1) continue;
            hashMap.put(((String)object).substring(0, n), ((String)object).substring(n + 1));
        }
    }

    private static class InputConsumer
    extends Thread {
        private InputStream in;
        private OutputStream out;
        private byte[] bytes = new byte[4096];

        public InputConsumer(InputStream inputStream) {
            this(inputStream, null);
        }

        public InputConsumer(InputStream inputStream, OutputStream outputStream) {
            this.in = inputStream;
            this.out = outputStream;
        }

        public void run() {
            while (true) {
                int n;
                try {
                    n = this.in.read(this.bytes);
                }
                catch (IOException iOException) {
                    n = -1;
                }
                if (n < 0) break;
                if (n <= 0 || this.out == null) continue;
                try {
                    this.out.write(this.bytes, 0, n);
                    this.out.flush();
                }
                catch (IOException iOException) {
                    this.out = null;
                }
            }
        }
    }
}

