/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.basic;

import com.qizx.util.io.ByteInput;
import com.qizx.util.io.ByteOutput;
import java.io.IOException;
import java.io.Serializable;

public class IntSet
implements Serializable {
    private static final int SHIFT = 5;
    private static final int USIZE = 32;
    private static final int MASK = 31;
    private int loBound;
    private int hiBound;
    private int[] bits;
    static final int[] HEXCOUNT = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};

    public IntSet() {
    }

    public IntSet(int n) {
        this.add(n);
    }

    public IntSet(int n, int n2) {
        this.add(n, n2);
    }

    public int size() {
        if (this.bits == null || this.hiBound == this.loBound) {
            return 0;
        }
        int n = 0;
        int n2 = this.bits.length;
        while (--n2 >= 0) {
            int n3 = this.bits[n2];
            n += HEXCOUNT[n3 & 0xF] + HEXCOUNT[n3 >> 4 & 0xF];
            n += HEXCOUNT[n3 >> 8 & 0xF] + HEXCOUNT[n3 >> 12 & 0xF];
            n += HEXCOUNT[n3 >> 16 & 0xF] + HEXCOUNT[n3 >> 20 & 0xF];
            n += HEXCOUNT[n3 >> 24 & 0xF] + HEXCOUNT[n3 >> 28 & 0xF];
        }
        return n;
    }

    public boolean test(int n) {
        if (n < this.loBound || n >= this.hiBound) {
            return false;
        }
        int n2 = n - this.loBound;
        return (this.bits[n2 >> 5] & 1 << (n2 & 0x1F)) != 0;
    }

    public int getNext(int n) {
        int n2;
        int n3 = n - this.loBound;
        if (n3 < 0) {
            n3 = 0;
        }
        int n4 = n3 >> 5;
        n3 &= 0x1F;
        int n5 = n2 = this.bits == null ? 0 : this.bits.length;
        while (n4 < n2) {
            int n6 = this.bits[n4] >>> n3;
            if (n6 != 0) {
                while (n3 < 32) {
                    if ((n6 & 1) != 0) {
                        return this.loBound + n4 * 32 + n3;
                    }
                    if ((n6 & 0xF) == 0) {
                        n3 += 4;
                        n6 >>>= 4;
                        continue;
                    }
                    ++n3;
                    n6 >>>= 1;
                }
            }
            n3 = 0;
            ++n4;
        }
        return -1;
    }

    public void add(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative element " + n);
        }
        int n2 = n & 0xFFFFFFE0;
        this.extend(n2, n2 + 32);
        int n3 = n - this.loBound;
        int n4 = n3 >> 5;
        this.bits[n4] = this.bits[n4] | 1 << (n3 & 0x1F);
    }

    public void add(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("negative element " + n);
        }
        this.extend(n & 0xFFFFFFE0, n2 + 31 & 0xFFFFFFE0);
        for (int i = n; i <= n2; ++i) {
            this.add(i);
        }
    }

    public void add(IntSet intSet) {
        this.extend(intSet.loBound, intSet.hiBound);
        int n = (intSet.loBound - this.loBound) / 32;
        int[] nArray = intSet.bits;
        if (nArray != null) {
            int n2 = nArray.length;
            while (--n2 >= 0) {
                int n3 = n2 + n;
                this.bits[n3] = this.bits[n3] | nArray[n2];
            }
        }
    }

    public void expectedbounds(int n, int n2) {
        this.extend(n & 0xFFFFFFE0, this.hiBound + 31 & 0xFFFFFFE0);
    }

    public void remove(int n) {
        if (n < this.loBound || n >= this.hiBound) {
            return;
        }
        int n2 = n - this.loBound;
        int n3 = n2 >> 5;
        this.bits[n3] = this.bits[n3] & ~(1 << (n2 & 0x1F));
    }

    public void remove(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.remove(i);
        }
    }

    public void remove(IntSet intSet) {
        int n = Math.max(this.loBound, intSet.loBound);
        int n2 = Math.min(this.hiBound, intSet.hiBound);
        if (n2 <= n) {
            return;
        }
        int n3 = (n2 - this.loBound) / 32;
        int n4 = (this.loBound - intSet.loBound) / 32;
        for (int i = (n - this.loBound) / 32; i < n3; ++i) {
            int n5 = i;
            this.bits[n5] = this.bits[n5] & ~intSet.bits[i + n4];
        }
    }

    public void invert(int n) {
        if (n < this.loBound || n >= this.hiBound) {
            return;
        }
        int n2 = n - this.loBound;
        int n3 = n2 >> 5;
        this.bits[n3] = this.bits[n3] ^ ~(1 << (n2 & 0x1F));
    }

    public void clear() {
        this.bits = null;
        this.loBound = 0;
        this.hiBound = 0;
    }

    public IntSet copy() {
        IntSet intSet = new IntSet();
        intSet.loBound = this.loBound;
        intSet.hiBound = this.hiBound;
        if (this.bits != null) {
            intSet.bits = (int[])this.bits.clone();
        }
        return intSet;
    }

    public static IntSet unionOf(IntSet intSet, IntSet intSet2) {
        if (intSet2 == null || intSet2.hiBound == intSet2.loBound) {
            return intSet.copy();
        }
        if (intSet == null || intSet.hiBound == intSet.loBound) {
            return intSet2.copy();
        }
        int n = Math.min(intSet.loBound, intSet2.loBound);
        int n2 = Math.max(intSet.hiBound, intSet2.hiBound);
        IntSet intSet3 = new IntSet();
        intSet3.init(n, n2);
        int n3 = (intSet.loBound - intSet3.loBound) / 32;
        int n4 = intSet.bits.length;
        while (--n4 >= 0) {
            intSet3.bits[n4 + n3] = intSet.bits[n4];
        }
        n3 = (intSet2.loBound - intSet3.loBound) / 32;
        n4 = intSet2.bits.length;
        while (--n4 >= 0) {
            int n5 = n4 + n3;
            intSet3.bits[n5] = intSet3.bits[n5] | intSet2.bits[n4];
        }
        return intSet3;
    }

    public static IntSet intersectionOf(IntSet intSet, IntSet intSet2) {
        IntSet intSet3 = new IntSet();
        if (intSet2 == null || intSet2.hiBound == intSet2.loBound || intSet == null || intSet.hiBound == intSet.loBound) {
            return intSet3;
        }
        int n = Math.max(intSet.loBound, intSet2.loBound);
        int n2 = Math.min(intSet.hiBound, intSet2.hiBound);
        if (n2 <= n) {
            return intSet3;
        }
        intSet3.init(n, n2);
        int n3 = (n - intSet.loBound) / 32;
        int n4 = intSet3.bits.length;
        while (--n4 >= 0) {
            intSet3.bits[n4] = intSet.bits[n4 + n3];
        }
        n3 = (n - intSet2.loBound) / 32;
        n4 = intSet3.bits.length;
        while (--n4 >= 0) {
            int n5 = n4;
            intSet3.bits[n5] = intSet3.bits[n5] & intSet2.bits[n4 + n3];
        }
        return intSet3;
    }

    public boolean intersectsRange(int n, int n2) {
        int n3 = this.getNext(n);
        return n3 >= n && n3 <= n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntSet)) {
            return false;
        }
        IntSet intSet = (IntSet)object;
        int n = -1;
        int n2 = -1;
        do {
            n = this.getNext(n + 1);
            n2 = intSet.getNext(n2 + 1);
            if (n >= 0) continue;
            return n2 < 0;
        } while (n == n2);
        return false;
    }

    public static IntSet differenceOf(IntSet intSet, IntSet intSet2) {
        IntSet intSet3 = intSet.copy();
        if (intSet2 == null || intSet2.hiBound == intSet2.loBound) {
            return intSet3;
        }
        int n = Math.max(intSet.loBound, intSet2.loBound);
        int n2 = Math.min(intSet.hiBound, intSet2.hiBound);
        if (n2 <= n) {
            return intSet3;
        }
        int n3 = (n2 - intSet3.loBound) / 32;
        int n4 = (intSet.loBound - intSet2.loBound) / 32;
        for (int i = (n - intSet3.loBound) / 32; i < n3; ++i) {
            int n5 = i;
            intSet3.bits[n5] = intSet3.bits[n5] & ~intSet2.bits[i + n4];
        }
        return intSet3;
    }

    public void save(ByteOutput byteOutput) throws IOException {
        byteOutput.putVint(this.loBound);
        byteOutput.putVint(this.hiBound - this.loBound);
        if (this.bits != null) {
            int n = this.bits.length;
            for (int i = 0; i < n; ++i) {
                byteOutput.putInt(this.bits[i]);
            }
        }
    }

    public void load(ByteInput byteInput) throws IOException {
        this.loBound = byteInput.getVint();
        int n = byteInput.getVint();
        this.hiBound = this.loBound + n;
        this.bits = new int[n / 32];
        int n2 = this.bits.length;
        for (int i = 0; i < n2; ++i) {
            this.bits[i] = byteInput.getInt();
        }
    }

    public static void skip(ByteInput byteInput) throws IOException {
        byteInput.getVint();
        int n = byteInput.getVint() / 32;
        for (int i = 0; i < n; ++i) {
            byteInput.getInt();
        }
    }

    public String toString() {
        return this.show(50);
    }

    public String show(int n) {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n2 = -1;
        while (stringBuffer.length() < n && (n2 = this.getNext(n2 + 1)) >= 0) {
            if (stringBuffer.length() > 1) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(Long.toString(n2));
        }
        stringBuffer.append(n2 < 0 ? "]" : "..]");
        return stringBuffer.toString();
    }

    private void init(int n, int n2) {
        this.loBound = n;
        this.hiBound = n2;
        int n3 = n2 - n;
        if (n3 > 0) {
            this.bits = new int[n3 / 32];
        }
    }

    private void extend(int n, int n2) {
        int n3;
        if (n >= this.loBound && n2 <= this.hiBound) {
            return;
        }
        if (this.hiBound == this.loBound) {
            this.init(n, n2);
            return;
        }
        int[] nArray = this.bits;
        int n4 = this.loBound;
        int n5 = Math.min(this.loBound, n);
        int n6 = Math.max(this.hiBound, n2);
        if ((n5 -= (n3 = (n6 - n5) / 16 / 32 * 32)) < 0) {
            n5 = 0;
        }
        this.init(n5, n6 += n3);
        System.arraycopy(nArray, 0, this.bits, (n4 - this.loBound) / 32, nArray.length);
    }
}

